/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.util;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class Debug {
    private static final String CLASS_NAME = ClientComms.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private static final String separator = "==============";
    private static final String lineSep = System.getProperty("line.separator", "\n");
    private String clientID;
    private ClientComms comms;

    public Debug(String string, ClientComms clientComms) {
        this.clientID = string;
        this.comms = clientComms;
        this.log.setResourceName(string);
    }

    public void dumpClientDebug() {
        this.dumpClientComms();
        this.dumpConOptions();
        this.dumpClientState();
        this.dumpBaseDebug();
    }

    public void dumpBaseDebug() {
        this.dumpVersion();
        this.dumpSystemProperties();
        this.dumpMemoryTrace();
    }

    protected void dumpMemoryTrace() {
        this.log.dumpTrace();
    }

    protected void dumpVersion() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(lineSep + separator + " Version Info " + separator + lineSep);
        stringBuffer.append(Debug.left("Version", 20, ' ') + ":  " + ClientComms.VERSION + lineSep);
        stringBuffer.append(Debug.left("Build Level", 20, ' ') + ":  " + ClientComms.BUILD_LEVEL + lineSep);
        stringBuffer.append("==========================================" + lineSep);
        this.log.fine(CLASS_NAME, "dumpVersion", stringBuffer.toString());
    }

    public void dumpSystemProperties() {
        Properties properties = System.getProperties();
        this.log.fine(CLASS_NAME, "dumpSystemProperties", Debug.dumpProperties(properties, "SystemProperties").toString());
    }

    public void dumpClientState() {
        Properties properties = null;
        if (this.comms != null && this.comms.getClientState() != null) {
            properties = this.comms.getClientState().getDebug();
            this.log.fine(CLASS_NAME, "dumpClientState", Debug.dumpProperties(properties, this.clientID + " : ClientState").toString());
        }
    }

    public void dumpClientComms() {
        Properties properties = null;
        if (this.comms != null) {
            properties = this.comms.getDebug();
            this.log.fine(CLASS_NAME, "dumpClientComms", Debug.dumpProperties(properties, this.clientID + " : ClientComms").toString());
        }
    }

    public void dumpConOptions() {
        Properties properties = null;
        if (this.comms != null) {
            properties = this.comms.getConOptions().getDebug();
            this.log.fine(CLASS_NAME, "dumpConOptions", Debug.dumpProperties(properties, this.clientID + " : Connect Options").toString());
        }
    }

    public static String dumpProperties(Properties properties, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<?> enumeration = properties.propertyNames();
        stringBuffer.append(lineSep + separator + " " + string + " " + separator + lineSep);
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            stringBuffer.append(Debug.left(string2, 28, ' ') + ":  " + properties.get(string2) + lineSep);
        }
        stringBuffer.append("==========================================" + lineSep);
        return stringBuffer.toString();
    }

    public static String left(String string, int n, char c) {
        if (string.length() >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        int n2 = n - string.length();
        while (--n2 >= 0) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

