/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.internal.FileLock;
import org.eclipse.paho.client.mqttv3.internal.MqttPersistentData;
import org.eclipse.paho.client.mqttv3.persist.PersistanceFileFilter;
import org.eclipse.paho.client.mqttv3.persist.PersistanceFileNameFilter;

public class MqttDefaultFilePersistence
implements MqttClientPersistence {
    private static final String MESSAGE_FILE_EXTENSION = ".msg";
    private static final String MESSAGE_BACKUP_FILE_EXTENSION = ".bup";
    private static final String LOCK_FILENAME = ".lck";
    private File dataDir;
    private File clientDir = null;
    private FileLock fileLock = null;
    private static FilenameFilter FILENAME_FILTER;

    private static FilenameFilter getFilenameFilter() {
        if (FILENAME_FILTER == null) {
            FILENAME_FILTER = new PersistanceFileNameFilter(MESSAGE_FILE_EXTENSION);
        }
        return FILENAME_FILTER;
    }

    public MqttDefaultFilePersistence() {
        this(System.getProperty("user.dir"));
    }

    public MqttDefaultFilePersistence(String string) {
        this.dataDir = new File(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(String string, String string2) throws MqttPersistenceException {
        char c;
        int n;
        if (this.dataDir.exists() && !this.dataDir.isDirectory()) {
            throw new MqttPersistenceException();
        }
        if (!this.dataDir.exists() && !this.dataDir.mkdirs()) {
            throw new MqttPersistenceException();
        }
        if (!this.dataDir.canWrite()) {
            throw new MqttPersistenceException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (!this.isSafeChar(c)) continue;
            stringBuffer.append(c);
        }
        stringBuffer.append("-");
        for (n = 0; n < string2.length(); ++n) {
            c = string2.charAt(n);
            if (!this.isSafeChar(c)) continue;
            stringBuffer.append(c);
        }
        MqttDefaultFilePersistence mqttDefaultFilePersistence = this;
        synchronized (mqttDefaultFilePersistence) {
            if (this.clientDir == null) {
                String string3 = stringBuffer.toString();
                this.clientDir = new File(this.dataDir, string3);
                if (!this.clientDir.exists()) {
                    this.clientDir.mkdir();
                }
            }
            try {
                if (this.fileLock != null) {
                    this.fileLock.release();
                }
                this.fileLock = new FileLock(this.clientDir, LOCK_FILENAME);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.restoreBackups(this.clientDir);
        }
    }

    private void checkIsOpen() throws MqttPersistenceException {
        if (this.clientDir == null) {
            throw new MqttPersistenceException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws MqttPersistenceException {
        MqttDefaultFilePersistence mqttDefaultFilePersistence = this;
        synchronized (mqttDefaultFilePersistence) {
            if (this.fileLock != null) {
                this.fileLock.release();
            }
            if (this.getFiles().length == 0) {
                this.clientDir.delete();
            }
            this.clientDir = null;
        }
    }

    @Override
    public void put(String string, MqttPersistable mqttPersistable) throws MqttPersistenceException {
        boolean bl;
        this.checkIsOpen();
        File file = new File(this.clientDir, string + MESSAGE_FILE_EXTENSION);
        File file2 = new File(this.clientDir, string + MESSAGE_FILE_EXTENSION + MESSAGE_BACKUP_FILE_EXTENSION);
        if (file.exists() && !(bl = file.renameTo(file2))) {
            file2.delete();
            file.renameTo(file2);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(mqttPersistable.getHeaderBytes(), mqttPersistable.getHeaderOffset(), mqttPersistable.getHeaderLength());
            if (mqttPersistable.getPayloadBytes() != null) {
                fileOutputStream.write(mqttPersistable.getPayloadBytes(), mqttPersistable.getPayloadOffset(), mqttPersistable.getPayloadLength());
            }
            fileOutputStream.getFD().sync();
            fileOutputStream.close();
            if (file2.exists()) {
                file2.delete();
            }
        }
        catch (IOException iOException) {
            throw new MqttPersistenceException(iOException);
        }
        finally {
            boolean bl2;
            if (file2.exists() && !(bl2 = file2.renameTo(file))) {
                file.delete();
                file2.renameTo(file);
            }
        }
    }

    @Override
    public MqttPersistable get(String string) throws MqttPersistenceException {
        MqttPersistentData mqttPersistentData;
        this.checkIsOpen();
        try {
            File file = new File(this.clientDir, string + MESSAGE_FILE_EXTENSION);
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = fileInputStream.available();
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; i += fileInputStream.read(byArray, i, n - i)) {
            }
            fileInputStream.close();
            mqttPersistentData = new MqttPersistentData(string, byArray, 0, byArray.length, null, 0, 0);
        }
        catch (IOException iOException) {
            throw new MqttPersistenceException(iOException);
        }
        return mqttPersistentData;
    }

    @Override
    public void remove(String string) throws MqttPersistenceException {
        this.checkIsOpen();
        File file = new File(this.clientDir, string + MESSAGE_FILE_EXTENSION);
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public Enumeration<String> keys() throws MqttPersistenceException {
        this.checkIsOpen();
        File[] fileArray = this.getFiles();
        Vector<String> vector = new Vector<String>(fileArray.length);
        for (File file : fileArray) {
            String string = file.getName();
            String string2 = string.substring(0, string.length() - MESSAGE_FILE_EXTENSION.length());
            vector.addElement(string2);
        }
        return vector.elements();
    }

    private File[] getFiles() throws MqttPersistenceException {
        this.checkIsOpen();
        File[] fileArray = this.clientDir.listFiles(MqttDefaultFilePersistence.getFilenameFilter());
        if (fileArray == null) {
            throw new MqttPersistenceException();
        }
        return fileArray;
    }

    private boolean isSafeChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-';
    }

    private void restoreBackups(File file) throws MqttPersistenceException {
        File[] fileArray = file.listFiles(new PersistanceFileFilter(MESSAGE_BACKUP_FILE_EXTENSION));
        if (fileArray == null) {
            throw new MqttPersistenceException();
        }
        for (File file2 : fileArray) {
            File file3 = new File(file, file2.getName().substring(0, file2.getName().length() - MESSAGE_BACKUP_FILE_EXTENSION.length()));
            boolean bl = file2.renameTo(file3);
            if (bl) continue;
            file3.delete();
            file2.renameTo(file3);
        }
    }

    @Override
    public boolean containsKey(String string) throws MqttPersistenceException {
        this.checkIsOpen();
        File file = new File(this.clientDir, string + MESSAGE_FILE_EXTENSION);
        return file.exists();
    }

    @Override
    public void clear() throws MqttPersistenceException {
        File[] fileArray;
        this.checkIsOpen();
        for (File file : fileArray = this.getFiles()) {
            file.delete();
        }
        this.clientDir.delete();
    }
}

