/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.MemoryHandler;
import org.eclipse.paho.client.mqttv3.logging.Logger;

public class JSR47Logger
implements Logger {
    private java.util.logging.Logger julLogger = null;
    private ResourceBundle logMessageCatalog = null;
    private ResourceBundle traceMessageCatalog = null;
    private String catalogID = null;
    private String resourceName = null;
    private String loggerName = null;

    @Override
    public void initialise(ResourceBundle resourceBundle, String string, String string2) {
        this.traceMessageCatalog = this.logMessageCatalog;
        this.resourceName = string2;
        this.loggerName = string;
        this.julLogger = java.util.logging.Logger.getLogger(this.loggerName);
        this.logMessageCatalog = resourceBundle;
        this.traceMessageCatalog = resourceBundle;
        this.catalogID = this.logMessageCatalog.getString("0");
    }

    @Override
    public void setResourceName(String string) {
        this.resourceName = string;
    }

    @Override
    public boolean isLoggable(int n) {
        return this.julLogger.isLoggable(this.mapJULLevel(n));
    }

    @Override
    public void severe(String string, String string2, String string3) {
        this.log(1, string, string2, string3, null, null);
    }

    @Override
    public void severe(String string, String string2, String string3, Object[] objectArray) {
        this.log(1, string, string2, string3, objectArray, null);
    }

    @Override
    public void severe(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.log(1, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void warning(String string, String string2, String string3) {
        this.log(2, string, string2, string3, null, null);
    }

    @Override
    public void warning(String string, String string2, String string3, Object[] objectArray) {
        this.log(2, string, string2, string3, objectArray, null);
    }

    @Override
    public void warning(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.log(2, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void info(String string, String string2, String string3) {
        this.log(3, string, string2, string3, null, null);
    }

    @Override
    public void info(String string, String string2, String string3, Object[] objectArray) {
        this.log(3, string, string2, string3, objectArray, null);
    }

    @Override
    public void info(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.log(3, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void config(String string, String string2, String string3) {
        this.log(4, string, string2, string3, null, null);
    }

    @Override
    public void config(String string, String string2, String string3, Object[] objectArray) {
        this.log(4, string, string2, string3, objectArray, null);
    }

    @Override
    public void config(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.log(4, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void log(int n, String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        Level level = this.mapJULLevel(n);
        if (this.julLogger.isLoggable(level)) {
            this.logToJsr47(level, string, string2, this.catalogID, this.logMessageCatalog, string3, objectArray, throwable);
        }
    }

    @Override
    public void fine(String string, String string2, String string3) {
        this.trace(5, string, string2, string3, null, null);
    }

    @Override
    public void fine(String string, String string2, String string3, Object[] objectArray) {
        this.trace(5, string, string2, string3, objectArray, null);
    }

    @Override
    public void fine(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.trace(5, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void finer(String string, String string2, String string3) {
        this.trace(6, string, string2, string3, null, null);
    }

    @Override
    public void finer(String string, String string2, String string3, Object[] objectArray) {
        this.trace(6, string, string2, string3, objectArray, null);
    }

    @Override
    public void finer(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.trace(6, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void finest(String string, String string2, String string3) {
        this.trace(7, string, string2, string3, null, null);
    }

    @Override
    public void finest(String string, String string2, String string3, Object[] objectArray) {
        this.trace(7, string, string2, string3, objectArray, null);
    }

    @Override
    public void finest(String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        this.trace(7, string, string2, string3, objectArray, throwable);
    }

    @Override
    public void trace(int n, String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        Level level = this.mapJULLevel(n);
        boolean bl = this.julLogger.isLoggable(level);
        if (bl) {
            this.logToJsr47(level, string, string2, this.catalogID, this.traceMessageCatalog, string3, objectArray, throwable);
        }
    }

    private String getResourceMessage(ResourceBundle resourceBundle, String string) {
        String string2;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        return string2;
    }

    private void logToJsr47(Level level, String string, String string2, String string3, ResourceBundle resourceBundle, String string4, Object[] objectArray, Throwable throwable) {
        String string5 = string4;
        if (!string4.contains("=====")) {
            string5 = MessageFormat.format(this.getResourceMessage(resourceBundle, string4), objectArray);
        }
        LogRecord logRecord = new LogRecord(level, this.resourceName + ": " + string5);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setLoggerName(this.loggerName);
        if (null != throwable) {
            logRecord.setThrown(throwable);
        }
        this.julLogger.log(logRecord);
    }

    private Level mapJULLevel(int n) {
        Level level = null;
        switch (n) {
            case 1: {
                level = Level.SEVERE;
                break;
            }
            case 2: {
                level = Level.WARNING;
                break;
            }
            case 3: {
                level = Level.INFO;
                break;
            }
            case 4: {
                level = Level.CONFIG;
                break;
            }
            case 5: {
                level = Level.FINE;
                break;
            }
            case 6: {
                level = Level.FINER;
                break;
            }
            case 7: {
                level = Level.FINEST;
                break;
            }
        }
        return level;
    }

    @Override
    public String formatMessage(String string, Object[] objectArray) {
        String string2;
        try {
            string2 = this.logMessageCatalog.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        return string2;
    }

    @Override
    public void dumpTrace() {
        JSR47Logger.dumpMemoryTrace47(this.julLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dumpMemoryTrace47(java.util.logging.Logger logger) {
        MemoryHandler memoryHandler = null;
        if (logger != null) {
            Handler[] handlerArray;
            for (Handler handler : handlerArray = logger.getHandlers()) {
                if (!(handler instanceof MemoryHandler)) continue;
                Handler handler2 = handler;
                synchronized (handler2) {
                    memoryHandler = (MemoryHandler)handler;
                    memoryHandler.push();
                    return;
                }
            }
            JSR47Logger.dumpMemoryTrace47(logger.getParent());
        }
    }
}

