/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.wire.CountingInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingReq;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingResp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRec;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRel;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSuback;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MultiByteArrayInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MultiByteInteger;

public abstract class MqttWireMessage {
    public static final byte MESSAGE_TYPE_CONNECT = 1;
    public static final byte MESSAGE_TYPE_CONNACK = 2;
    public static final byte MESSAGE_TYPE_PUBLISH = 3;
    public static final byte MESSAGE_TYPE_PUBACK = 4;
    public static final byte MESSAGE_TYPE_PUBREC = 5;
    public static final byte MESSAGE_TYPE_PUBREL = 6;
    public static final byte MESSAGE_TYPE_PUBCOMP = 7;
    public static final byte MESSAGE_TYPE_SUBSCRIBE = 8;
    public static final byte MESSAGE_TYPE_SUBACK = 9;
    public static final byte MESSAGE_TYPE_UNSUBSCRIBE = 10;
    public static final byte MESSAGE_TYPE_UNSUBACK = 11;
    public static final byte MESSAGE_TYPE_PINGREQ = 12;
    public static final byte MESSAGE_TYPE_PINGRESP = 13;
    public static final byte MESSAGE_TYPE_DISCONNECT = 14;
    protected static final Charset STRING_ENCODING = StandardCharsets.UTF_8;
    private static final String[] PACKET_NAMES = new String[]{"reserved", "CONNECT", "CONNACK", "PUBLISH", "PUBACK", "PUBREC", "PUBREL", "PUBCOMP", "SUBSCRIBE", "SUBACK", "UNSUBSCRIBE", "UNSUBACK", "PINGREQ", "PINGRESP", "DISCONNECT"};
    private static final long FOUR_BYTE_INT_MAX = 0xFFFFFFFFL;
    private static final int VARIABLE_BYTE_INT_MAX = 0xFFFFFFF;
    private byte type;
    protected int msgId;
    protected boolean duplicate = false;
    private MqttToken token;

    public MqttWireMessage(byte by) {
        this.type = by;
        this.msgId = 0;
    }

    protected abstract byte getMessageInfo();

    public byte[] getPayload() throws MqttException {
        return new byte[0];
    }

    public byte getType() {
        return this.type;
    }

    public int getMessageId() {
        return this.msgId;
    }

    public void setMessageId(int n) {
        this.msgId = n;
    }

    public String getKey() {
        return Integer.toString(this.getMessageId());
    }

    public byte[] getHeader() throws MqttException {
        try {
            int n = (this.getType() & 0xF) << 4 ^ this.getMessageInfo() & 0xF;
            byte[] byArray = this.getVariableHeader();
            int n2 = byArray.length + this.getPayload().length;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(n);
            dataOutputStream.write(MqttWireMessage.encodeMBI(n2));
            dataOutputStream.write(byArray);
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MqttException(iOException);
        }
    }

    protected abstract byte[] getVariableHeader() throws MqttException;

    public boolean isMessageIdRequired() {
        return true;
    }

    public static MqttWireMessage createWireMessage(MqttPersistable mqttPersistable) throws MqttException {
        byte[] byArray = mqttPersistable.getPayloadBytes();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        MultiByteArrayInputStream multiByteArrayInputStream = new MultiByteArrayInputStream(mqttPersistable.getHeaderBytes(), mqttPersistable.getHeaderOffset(), mqttPersistable.getHeaderLength(), byArray, mqttPersistable.getPayloadOffset(), mqttPersistable.getPayloadLength());
        return MqttWireMessage.createWireMessage(multiByteArrayInputStream);
    }

    public static MqttWireMessage createWireMessage(byte[] byArray) throws MqttException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return MqttWireMessage.createWireMessage(byteArrayInputStream);
    }

    private static MqttWireMessage createWireMessage(InputStream inputStream) throws MqttException {
        try {
            MqttWireMessage mqttWireMessage;
            CountingInputStream countingInputStream = new CountingInputStream(inputStream);
            DataInputStream dataInputStream = new DataInputStream(countingInputStream);
            int n = dataInputStream.readUnsignedByte();
            byte by = (byte)(n >> 4);
            byte by2 = (byte)(n &= 0xF);
            long l = MqttWireMessage.readMBI(dataInputStream).getValue();
            long l2 = (long)countingInputStream.getCounter() + l;
            long l3 = l2 - (long)countingInputStream.getCounter();
            byte[] byArray = new byte[]{};
            if (l3 > 0L) {
                byArray = new byte[(int)l3];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            if (by == 1) {
                mqttWireMessage = new MqttConnect(by2, byArray);
            } else if (by == 3) {
                mqttWireMessage = new MqttPublish(by2, byArray);
            } else if (by == 4) {
                mqttWireMessage = new MqttPubAck(by2, byArray);
            } else if (by == 7) {
                mqttWireMessage = new MqttPubComp(by2, byArray);
            } else if (by == 2) {
                mqttWireMessage = new MqttConnack(by2, byArray);
            } else if (by == 12) {
                mqttWireMessage = new MqttPingReq(by2, byArray);
            } else if (by == 13) {
                mqttWireMessage = new MqttPingResp(by2, byArray);
            } else if (by == 8) {
                mqttWireMessage = new MqttSubscribe(by2, byArray);
            } else if (by == 9) {
                mqttWireMessage = new MqttSuback(by2, byArray);
            } else if (by == 10) {
                mqttWireMessage = new MqttUnsubscribe(by2, byArray);
            } else if (by == 11) {
                mqttWireMessage = new MqttUnsubAck(by2, byArray);
            } else if (by == 6) {
                mqttWireMessage = new MqttPubRel(by2, byArray);
            } else if (by == 5) {
                mqttWireMessage = new MqttPubRec(by2, byArray);
            } else if (by == 14) {
                mqttWireMessage = new MqttDisconnect(by2, byArray);
            } else {
                throw ExceptionHelper.createMqttException(6);
            }
            return mqttWireMessage;
        }
        catch (IOException iOException) {
            throw new MqttException(iOException);
        }
    }

    public static byte[] encodeMBI(long l) {
        MqttWireMessage.validateVariableByteInt((int)l);
        int n = 0;
        long l2 = l;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            byte by = (byte)(l2 % 128L);
            if ((l2 /= 128L) > 0L) {
                by = (byte)(by | 0x80);
            }
            byteArrayOutputStream.write(by);
        } while (l2 > 0L && ++n < 4);
        return byteArrayOutputStream.toByteArray();
    }

    public static MultiByteInteger readMBI(DataInputStream dataInputStream) throws IOException {
        byte by;
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        do {
            by = dataInputStream.readByte();
            ++n3;
            n += (by & 0x7F) * n2;
            n2 *= 128;
        } while ((by & 0x80) != 0);
        if (n < 0 || n > 0xFFFFFFF) {
            throw new IOException("This property must be a number between 0 and 268435455. Read value was: " + n);
        }
        return new MultiByteInteger(n, n3);
    }

    protected byte[] encodeMessageId() throws MqttException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeShort(this.msgId);
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MqttException(iOException);
        }
    }

    public boolean isRetryable() {
        return false;
    }

    public void setDuplicate(boolean bl) {
        this.duplicate = bl;
    }

    public static void encodeUTF8(DataOutputStream dataOutputStream, String string) throws MqttException {
        MqttWireMessage.validateUTF8String(string);
        try {
            byte[] byArray = string.getBytes(STRING_ENCODING);
            byte by = (byte)(byArray.length >>> 8 & 0xFF);
            byte by2 = (byte)(byArray.length >>> 0 & 0xFF);
            dataOutputStream.write(by);
            dataOutputStream.write(by2);
            dataOutputStream.write(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MqttException(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new MqttException(iOException);
        }
    }

    public static String decodeUTF8(DataInputStream dataInputStream) throws MqttException {
        try {
            int n = dataInputStream.readUnsignedShort();
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            String string = new String(byArray, STRING_ENCODING);
            MqttWireMessage.validateUTF8String(string);
            return string;
        }
        catch (IOException iOException) {
            throw new MqttException(iOException);
        }
    }

    private static void validateUTF8String(String string) throws IllegalArgumentException {
        for (int i = 0; i < string.length(); ++i) {
            boolean bl = false;
            char c = string.charAt(i);
            if (Character.isHighSurrogate(c)) {
                if (++i == string.length()) {
                    bl = true;
                } else {
                    char c2 = string.charAt(i);
                    if (Character.isLowSurrogate(c2)) {
                        bl = true;
                    } else {
                        int n = (c & 0x3FF) << 10 | c2 & 0x3FF;
                        if ((n & 0xFFFF) == 65535 || (n & 0xFFFF) == 65534) {
                            bl = true;
                        }
                    }
                }
            } else if (Character.isISOControl(c) || Character.isLowSurrogate(c)) {
                bl = true;
            } else if (c >= '\ufdd0' && (c == '\ufffe' || c >= '\ufdd0' || c <= '\ufddf')) {
                bl = true;
            }
            if (!bl) continue;
            throw new IllegalArgumentException(String.format("Invalid UTF-8 char: [%x]", c));
        }
    }

    public static void validateVariableByteInt(int n) throws IllegalArgumentException {
        if (n >= 0 && n <= 0xFFFFFFF) {
            return;
        }
        throw new IllegalArgumentException("This property must be a number between 0 and 268435455");
    }

    public MqttToken getToken() {
        return this.token;
    }

    public void setToken(MqttToken mqttToken) {
        this.token = mqttToken;
    }

    public String toString() {
        return PACKET_NAMES[this.type];
    }
}

