/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class MqttSubscribe
extends MqttWireMessage {
    private String[] names;
    private int[] qos;
    private int count;

    public MqttSubscribe(byte by, byte[] byArray) throws IOException {
        super((byte)8);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.msgId = dataInputStream.readUnsignedShort();
        this.count = 0;
        this.names = new String[10];
        this.qos = new int[10];
        boolean bl = false;
        while (!bl) {
            try {
                this.names[this.count] = MqttSubscribe.decodeUTF8(dataInputStream);
                this.qos[this.count++] = dataInputStream.readByte();
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        dataInputStream.close();
    }

    public MqttSubscribe(String[] stringArray, int[] nArray) {
        super((byte)8);
        if (stringArray == null || nArray == null) {
            throw new IllegalArgumentException();
        }
        this.names = (String[])stringArray.clone();
        this.qos = (int[])nArray.clone();
        if (this.names.length != this.qos.length) {
            throw new IllegalArgumentException();
        }
        this.count = stringArray.length;
        for (int n : nArray) {
            MqttMessage.validateQos(n);
        }
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" names:[");
        for (n = 0; n < this.count; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("\"").append(this.names[n]).append("\"");
        }
        stringBuffer.append("] qos:[");
        for (n = 0; n < this.count; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.qos[n]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    protected byte getMessageInfo() {
        return (byte)(2 | (this.duplicate ? 8 : 0));
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeShort(this.msgId);
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MqttException(iOException);
        }
    }

    @Override
    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (int i = 0; i < this.names.length; ++i) {
                MqttSubscribe.encodeUTF8(dataOutputStream, this.names[i]);
                dataOutputStream.writeByte(this.qos[i]);
            }
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MqttException(iOException);
        }
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

