/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class MqttOutputStream
extends OutputStream {
    private static final String CLASS_NAME = MqttOutputStream.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private ClientState clientState = null;
    private BufferedOutputStream out;

    public MqttOutputStream(ClientState clientState, OutputStream outputStream) {
        this.clientState = clientState;
        this.out = new BufferedOutputStream(outputStream);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
        this.clientState.notifySentBytes(byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.clientState.notifySentBytes(n2);
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void write(MqttWireMessage mqttWireMessage) throws IOException, MqttException {
        byte[] byArray = mqttWireMessage.getHeader();
        byte[] byArray2 = mqttWireMessage.getPayload();
        this.out.write(byArray, 0, byArray.length);
        this.clientState.notifySentBytes(byArray.length);
        int n = 1024;
        for (int i = 0; i < byArray2.length; i += n) {
            int n2 = Math.min(n, byArray2.length - i);
            this.out.write(byArray2, i, n2);
            this.clientState.notifySentBytes(n2);
        }
        this.log.fine(CLASS_NAME, "write", "529", new Object[]{mqttWireMessage});
    }
}

