/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class MqttInputStream
extends InputStream {
    private final String CLASS_NAME = MqttInputStream.class.getName();
    private final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", this.CLASS_NAME);
    private ClientState clientState = null;
    private DataInputStream in;
    private ByteArrayOutputStream bais;
    private int remLen;
    private int packetLen;
    private byte[] packet;

    public MqttInputStream(ClientState clientState, InputStream inputStream) {
        this.clientState = clientState;
        this.in = new DataInputStream(inputStream);
        this.bais = new ByteArrayOutputStream();
        this.remLen = -1;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public MqttWireMessage readMqttWireMessage() throws IOException, MqttException {
        MqttWireMessage mqttWireMessage = null;
        try {
            if (this.remLen < 0) {
                this.bais.reset();
                byte by = this.in.readByte();
                this.clientState.notifyReceivedBytes(1);
                byte by2 = (byte)(by >>> 4 & 0xF);
                if (by2 < 1 || by2 > 14) {
                    throw ExceptionHelper.createMqttException(32108);
                }
                this.remLen = MqttWireMessage.readMBI(this.in).getValue();
                this.bais.write(by);
                this.bais.write(MqttWireMessage.encodeMBI(this.remLen));
                this.packet = new byte[this.bais.size() + this.remLen];
                this.packetLen = 0;
            }
            if (this.remLen >= 0) {
                this.readFully();
                this.remLen = -1;
                byte[] byArray = this.bais.toByteArray();
                System.arraycopy(byArray, 0, this.packet, 0, byArray.length);
                mqttWireMessage = MqttWireMessage.createWireMessage(this.packet);
                this.log.fine(this.CLASS_NAME, "readMqttWireMessage", "301", new Object[]{mqttWireMessage});
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        return mqttWireMessage;
    }

    private void readFully() throws IOException {
        int n;
        int n2 = this.bais.size() + this.packetLen;
        int n3 = this.remLen - this.packetLen;
        if (n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; i += n) {
            n = -1;
            try {
                n = this.in.read(this.packet, n2 + i, n3 - i);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.packetLen += i;
                throw socketTimeoutException;
            }
            if (n < 0) {
                throw new EOFException();
            }
            this.clientState.notifyReceivedBytes(n);
        }
    }
}

