/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class MqttConnect
extends MqttWireMessage {
    public static final String KEY = "Con";
    private String clientId;
    private boolean cleanSession;
    private MqttMessage willMessage;
    private String userName;
    private char[] password;
    private int keepAliveInterval;
    private String willDestination;
    private int mqttVersion;

    public MqttConnect(byte by, byte[] byArray) throws IOException, MqttException {
        super((byte)1);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        String string = MqttConnect.decodeUTF8(dataInputStream);
        byte by2 = dataInputStream.readByte();
        byte by3 = dataInputStream.readByte();
        this.keepAliveInterval = dataInputStream.readUnsignedShort();
        this.clientId = MqttConnect.decodeUTF8(dataInputStream);
        dataInputStream.close();
    }

    public MqttConnect(String string, int n, boolean bl, int n2, String string2, char[] cArray, MqttMessage mqttMessage, String string3) {
        super((byte)1);
        this.clientId = string;
        this.cleanSession = bl;
        this.keepAliveInterval = n2;
        this.userName = string2;
        if (cArray != null) {
            this.password = (char[])cArray.clone();
        }
        this.willMessage = mqttMessage;
        this.willDestination = string3;
        this.mqttVersion = n;
    }

    @Override
    public String toString() {
        String string = super.toString();
        string = string + " clientId " + this.clientId + " keepAliveInterval " + this.keepAliveInterval;
        return string;
    }

    @Override
    protected byte getMessageInfo() {
        return 0;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (this.mqttVersion == 3) {
                MqttConnect.encodeUTF8(dataOutputStream, "MQIsdp");
            } else if (this.mqttVersion == 4) {
                MqttConnect.encodeUTF8(dataOutputStream, "MQTT");
            }
            dataOutputStream.write(this.mqttVersion);
            int n = 0;
            if (this.cleanSession) {
                n = (byte)(n | 2);
            }
            if (this.willMessage != null) {
                n = (byte)(n | 4);
                n = (byte)(n | this.willMessage.getQos() << 3);
                if (this.willMessage.isRetained()) {
                    n = (byte)(n | 0x20);
                }
            }
            if (this.userName != null) {
                n = (byte)(n | 0x80);
                if (this.password != null) {
                    n = (byte)(n | 0x40);
                }
            }
            dataOutputStream.write(n);
            dataOutputStream.writeShort(this.keepAliveInterval);
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MqttException(iOException);
        }
    }

    @Override
    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            MqttConnect.encodeUTF8(dataOutputStream, this.clientId);
            if (this.willMessage != null) {
                MqttConnect.encodeUTF8(dataOutputStream, this.willDestination);
                dataOutputStream.writeShort(this.willMessage.getPayload().length);
                dataOutputStream.write(this.willMessage.getPayload());
            }
            if (this.userName != null) {
                MqttConnect.encodeUTF8(dataOutputStream, this.userName);
                if (this.password != null) {
                    MqttConnect.encodeUTF8(dataOutputStream, new String(this.password));
                }
            }
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MqttException(iOException);
        }
    }

    @Override
    public boolean isMessageIdRequired() {
        return false;
    }

    @Override
    public String getKey() {
        return KEY;
    }
}

