/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.nio.ByteBuffer;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.SSLNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.websocket.ExtendedByteArrayOutputStream;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketFrame;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketHandshake;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketReceiver;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class WebSocketSecureNetworkModule
extends SSLNetworkModule {
    private static final String CLASS_NAME = WebSocketSecureNetworkModule.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private PipedInputStream pipedInputStream;
    private WebSocketReceiver webSocketReceiver;
    private String uri;
    private String host;
    private int port;
    private Properties customWebSocketHeaders;
    ByteBuffer recievedPayload;
    private ByteArrayOutputStream outputStream = new ExtendedByteArrayOutputStream(this);

    public WebSocketSecureNetworkModule(SSLSocketFactory sSLSocketFactory, String string, String string2, int n, String string3, Properties properties) {
        super(sSLSocketFactory, string2, n, string3);
        this.uri = string;
        this.host = string2;
        this.port = n;
        this.customWebSocketHeaders = properties;
        this.pipedInputStream = new PipedInputStream();
        this.log.setResourceName(string3);
    }

    @Override
    public void start() throws IOException, MqttException {
        super.start();
        WebSocketHandshake webSocketHandshake = new WebSocketHandshake(super.getInputStream(), super.getOutputStream(), this.uri, this.host, this.port, this.customWebSocketHeaders);
        webSocketHandshake.execute();
        this.webSocketReceiver = new WebSocketReceiver(this.getSocketInputStream(), this.pipedInputStream);
        this.webSocketReceiver.start("WssSocketReceiver");
    }

    OutputStream getSocketOutputStream() throws IOException {
        return super.getOutputStream();
    }

    InputStream getSocketInputStream() throws IOException {
        return super.getInputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.pipedInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    @Override
    public void stop() throws IOException {
        WebSocketFrame webSocketFrame = new WebSocketFrame(8, true, "1000".getBytes());
        byte[] byArray = webSocketFrame.encodeFrame();
        this.getSocketOutputStream().write(byArray);
        this.getSocketOutputStream().flush();
        if (this.webSocketReceiver != null) {
            this.webSocketReceiver.stop();
        }
        super.stop();
    }

    @Override
    public String getServerURI() {
        return "wss://" + this.host + ":" + this.port;
    }
}

