/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.SecureRandom;

public class WebSocketFrame {
    public static final int frameLengthOverhead = 6;
    private byte opcode;
    private boolean fin;
    private byte[] payload;
    private boolean closeFlag = false;

    public byte getOpcode() {
        return this.opcode;
    }

    public boolean isFin() {
        return this.fin;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public boolean isCloseFlag() {
        return this.closeFlag;
    }

    public WebSocketFrame(byte by, boolean bl, byte[] byArray) {
        this.opcode = by;
        this.fin = bl;
        if (byArray != null) {
            this.payload = (byte[])byArray.clone();
        }
    }

    public WebSocketFrame(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byte by = byteBuffer.get();
        this.setFinAndOpCode(by);
        by = byteBuffer.get();
        boolean bl = (by & 0x80) != 0;
        int n = 0x7F & by;
        int n2 = 0;
        if (n == 127) {
            n2 = 8;
        } else if (n == 126) {
            n2 = 2;
        }
        while (--n2 > 0) {
            by = byteBuffer.get();
            n |= (by & 0xFF) << 8 * n2;
        }
        byte[] byArray2 = null;
        if (bl) {
            byArray2 = new byte[4];
            byteBuffer.get(byArray2, 0, 4);
        }
        this.payload = new byte[n];
        byteBuffer.get(this.payload, 0, n);
        if (bl) {
            for (int i = 0; i < this.payload.length; ++i) {
                int n3 = i;
                this.payload[n3] = (byte)(this.payload[n3] ^ byArray2[i % 4]);
            }
        }
    }

    private void setFinAndOpCode(byte by) {
        this.fin = (by & 0x80) != 0;
        this.opcode = (byte)(by & 0xF);
    }

    public WebSocketFrame(InputStream inputStream) throws IOException {
        byte by = (byte)inputStream.read();
        this.setFinAndOpCode(by);
        if (this.opcode == 2) {
            byte by2 = (byte)inputStream.read();
            boolean bl = (by2 & 0x80) != 0;
            int n = 0x7F & by2;
            int n2 = 0;
            if (n == 127) {
                n2 = 8;
            } else if (n == 126) {
                n2 = 2;
            }
            if (n2 > 0) {
                n = 0;
            }
            while (--n2 >= 0) {
                by2 = (byte)inputStream.read();
                n |= (by2 & 0xFF) << 8 * n2;
            }
            byte[] byArray = null;
            if (bl) {
                byArray = new byte[4];
                inputStream.read(byArray, 0, 4);
            }
            this.payload = new byte[n];
            int n3 = 0;
            int n4 = n;
            int n5 = 0;
            while (n3 != n) {
                n5 = inputStream.read(this.payload, n3, n4);
                n3 += n5;
                n4 -= n5;
            }
            if (bl) {
                for (int i = 0; i < this.payload.length; ++i) {
                    int n6 = i;
                    this.payload[n6] = (byte)(this.payload[n6] ^ byArray[i % 4]);
                }
            }
            return;
        }
        if (this.opcode != 8) {
            throw new IOException("Invalid Frame: Opcode: " + this.opcode);
        }
        this.closeFlag = true;
    }

    public byte[] encodeFrame() {
        int n = this.payload.length + 6;
        if (this.payload.length > 65535) {
            n += 8;
        } else if (this.payload.length >= 126) {
            n += 2;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        WebSocketFrame.appendFinAndOpCode(byteBuffer, this.opcode, this.fin);
        byte[] byArray = WebSocketFrame.generateMaskingKey();
        WebSocketFrame.appendLengthAndMask(byteBuffer, this.payload.length, byArray);
        for (int i = 0; i < this.payload.length; ++i) {
            int n2 = i;
            byte by = (byte)(this.payload[n2] ^ byArray[i % 4]);
            this.payload[n2] = by;
            byteBuffer.put(by);
        }
        byteBuffer.flip();
        return byteBuffer.array();
    }

    public static void appendLengthAndMask(ByteBuffer byteBuffer, int n, byte[] byArray) {
        if (byArray != null) {
            WebSocketFrame.appendLength(byteBuffer, n, true);
            byteBuffer.put(byArray);
        } else {
            WebSocketFrame.appendLength(byteBuffer, n, false);
        }
    }

    private static void appendLength(ByteBuffer byteBuffer, int n, boolean bl) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        int n3 = n2 = bl ? -128 : 0;
        if (n > 65535) {
            byteBuffer.put((byte)(n2 | 0x7F));
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)(n >> 24 & 0xFF));
            byteBuffer.put((byte)(n >> 16 & 0xFF));
            byteBuffer.put((byte)(n >> 8 & 0xFF));
            byteBuffer.put((byte)(n & 0xFF));
        } else if (n >= 126) {
            byteBuffer.put((byte)(n2 | 0x7E));
            byteBuffer.put((byte)(n >> 8));
            byteBuffer.put((byte)(n & 0xFF));
        } else {
            byteBuffer.put((byte)(n2 | n));
        }
    }

    public static void appendFinAndOpCode(ByteBuffer byteBuffer, byte by, boolean bl) {
        byte by2 = 0;
        if (bl) {
            by2 = (byte)(by2 | 0x80);
        }
        by2 = (byte)(by2 | by & 0xF);
        byteBuffer.put(by2);
    }

    public static byte[] generateMaskingKey() {
        SecureRandom secureRandom = new SecureRandom();
        int n = secureRandom.nextInt(255);
        int n2 = secureRandom.nextInt(255);
        int n3 = secureRandom.nextInt(255);
        int n4 = secureRandom.nextInt(255);
        return new byte[]{(byte)n, (byte)n2, (byte)n3, (byte)n4};
    }
}

