/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSuback;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class Token {
    private static final String CLASS_NAME = Token.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private volatile boolean completed = false;
    private boolean pendingComplete = false;
    private boolean sent = false;
    private final Object responseLock = new Object();
    private final Object sentLock = new Object();
    protected MqttMessage message = null;
    private MqttWireMessage response = null;
    private MqttException exception = null;
    private String[] topics = null;
    private String key;
    private IMqttAsyncClient client = null;
    private IMqttActionListener callback = null;
    private Object userContext = null;
    private int messageID = 0;
    private boolean notified = false;

    public Token(String string) {
        this.log.setResourceName(string);
    }

    public int getMessageID() {
        return this.messageID;
    }

    public void setMessageID(int n) {
        this.messageID = n;
    }

    public boolean checkResult() throws MqttException {
        if (this.getException() != null) {
            throw this.getException();
        }
        return true;
    }

    public MqttException getException() {
        return this.exception;
    }

    public boolean isComplete() {
        return this.completed;
    }

    protected boolean isCompletePending() {
        return this.pendingComplete;
    }

    protected boolean isInUse() {
        return this.getClient() != null && !this.isComplete();
    }

    public void setActionCallback(IMqttActionListener iMqttActionListener) {
        this.callback = iMqttActionListener;
    }

    public IMqttActionListener getActionCallback() {
        return this.callback;
    }

    public void waitForCompletion() throws MqttException {
        this.waitForCompletion(-1L);
    }

    public void waitForCompletion(long l) throws MqttException {
        this.log.fine(CLASS_NAME, "waitForCompletion", "407", new Object[]{this.getKey(), l, this});
        MqttWireMessage mqttWireMessage = this.waitForResponse(l);
        if (mqttWireMessage == null && !this.completed) {
            this.log.fine(CLASS_NAME, "waitForCompletion", "406", new Object[]{this.getKey(), this});
            this.exception = new MqttException(32000);
            throw this.exception;
        }
        this.checkResult();
    }

    protected MqttWireMessage waitForResponse() throws MqttException {
        return this.waitForResponse(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MqttWireMessage waitForResponse(long l) throws MqttException {
        Object object = this.responseLock;
        synchronized (object) {
            this.log.fine(CLASS_NAME, "waitForResponse", "400", new Object[]{this.getKey(), l, this.sent, this.completed, this.exception == null ? "false" : "true", this.response, this}, this.exception);
            while (!this.completed) {
                if (this.exception == null) {
                    try {
                        this.log.fine(CLASS_NAME, "waitForResponse", "408", new Object[]{this.getKey(), l});
                        if (l <= 0L) {
                            this.responseLock.wait();
                        } else {
                            this.responseLock.wait(l);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.exception = new MqttException(interruptedException);
                    }
                }
                if (this.completed) continue;
                if (this.exception != null) {
                    this.log.fine(CLASS_NAME, "waitForResponse", "401", null, this.exception);
                    throw this.exception;
                }
                if (l <= 0L) continue;
            }
        }
        this.log.fine(CLASS_NAME, "waitForResponse", "402", new Object[]{this.getKey(), this.response});
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markComplete(MqttWireMessage mqttWireMessage, MqttException mqttException) {
        this.log.fine(CLASS_NAME, "markComplete", "404", new Object[]{this.getKey(), mqttWireMessage, mqttException});
        Object object = this.responseLock;
        synchronized (object) {
            if (mqttWireMessage instanceof MqttAck) {
                this.message = null;
            }
            this.pendingComplete = true;
            this.response = mqttWireMessage;
            this.exception = mqttException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyComplete() {
        this.log.fine(CLASS_NAME, "notifyComplete", "404", new Object[]{this.getKey(), this.response, this.exception});
        Object object = this.responseLock;
        synchronized (object) {
            if (this.exception == null && this.pendingComplete) {
                this.completed = true;
                this.pendingComplete = false;
            } else {
                this.pendingComplete = false;
            }
            this.responseLock.notifyAll();
        }
        object = this.sentLock;
        synchronized (object) {
            this.sent = true;
            this.sentLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilSent() throws MqttException {
        Object object = this.sentLock;
        synchronized (object) {
            Object object2 = this.responseLock;
            synchronized (object2) {
                if (this.exception != null) {
                    throw this.exception;
                }
            }
            while (!this.sent) {
                try {
                    this.log.fine(CLASS_NAME, "waitUntilSent", "409", new Object[]{this.getKey()});
                    this.sentLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.sent) {
                if (this.exception == null) {
                    throw ExceptionHelper.createMqttException(6);
                }
                throw this.exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySent() {
        this.log.fine(CLASS_NAME, "notifySent", "403", new Object[]{this.getKey()});
        Object object = this.responseLock;
        synchronized (object) {
            this.response = null;
            this.completed = false;
        }
        object = this.sentLock;
        synchronized (object) {
            this.sent = true;
            this.sentLock.notifyAll();
        }
    }

    public IMqttAsyncClient getClient() {
        return this.client;
    }

    protected void setClient(IMqttAsyncClient iMqttAsyncClient) {
        this.client = iMqttAsyncClient;
    }

    public void reset() throws MqttException {
        if (this.isInUse()) {
            throw new MqttException(32201);
        }
        this.log.fine(CLASS_NAME, "reset", "410", new Object[]{this.getKey()});
        this.client = null;
        this.completed = false;
        this.response = null;
        this.sent = false;
        this.exception = null;
        this.userContext = null;
    }

    public MqttMessage getMessage() {
        return this.message;
    }

    public MqttWireMessage getWireMessage() {
        return this.response;
    }

    public void setMessage(MqttMessage mqttMessage) {
        this.message = mqttMessage;
    }

    public String[] getTopics() {
        return this.topics;
    }

    public void setTopics(String[] stringArray) {
        this.topics = (String[])stringArray.clone();
    }

    public Object getUserContext() {
        return this.userContext;
    }

    public void setUserContext(Object object) {
        this.userContext = object;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(MqttException mqttException) {
        Object object = this.responseLock;
        synchronized (object) {
            this.exception = mqttException;
        }
    }

    public boolean isNotified() {
        return this.notified;
    }

    public void setNotified(boolean bl) {
        this.notified = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("key=").append(this.getKey());
        stringBuffer.append(" ,topics=");
        if (this.getTopics() != null) {
            for (int i = 0; i < this.getTopics().length; ++i) {
                stringBuffer.append(this.getTopics()[i]).append(", ");
            }
        }
        stringBuffer.append(" ,usercontext=").append(this.getUserContext());
        stringBuffer.append(" ,isComplete=").append(this.isComplete());
        stringBuffer.append(" ,isNotified=").append(this.isNotified());
        stringBuffer.append(" ,exception=").append(this.getException());
        stringBuffer.append(" ,actioncallback=").append(this.getActionCallback());
        return stringBuffer.toString();
    }

    public int[] getGrantedQos() {
        int[] nArray = new int[]{};
        if (this.response instanceof MqttSuback) {
            nArray = ((MqttSuback)this.response).getGrantedQos();
        }
        return nArray;
    }

    public boolean getSessionPresent() {
        boolean bl = false;
        if (this.response instanceof MqttConnack) {
            bl = ((MqttConnack)this.response).getSessionPresent();
        }
        return bl;
    }

    public MqttWireMessage getResponse() {
        return this.response;
    }
}

