/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.TCPNetworkModule;
import org.eclipse.paho.client.mqttv3.spi.NetworkModuleFactory;

public class TCPNetworkModuleFactory
implements NetworkModuleFactory {
    @Override
    public Set<String> getSupportedUriSchemes() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("tcp")));
    }

    @Override
    public void validateURI(URI uRI) throws IllegalArgumentException {
        String string = uRI.getPath();
        if (string != null && !string.isEmpty()) {
            throw new IllegalArgumentException("URI path must be empty \"" + uRI.toString() + "\"");
        }
    }

    @Override
    public NetworkModule createNetworkModule(URI uRI, MqttConnectOptions mqttConnectOptions, String string) throws MqttException {
        String string2;
        String string3 = uRI.getHost();
        int n = uRI.getPort();
        if (n == -1) {
            n = 1883;
        }
        if ((string2 = uRI.getPath()) != null && !string2.isEmpty()) {
            throw new IllegalArgumentException(uRI.toString());
        }
        SocketFactory socketFactory = mqttConnectOptions.getSocketFactory();
        if (socketFactory == null) {
            socketFactory = SocketFactory.getDefault();
        } else if (socketFactory instanceof SSLSocketFactory) {
            throw ExceptionHelper.createMqttException(32105);
        }
        TCPNetworkModule tCPNetworkModule = new TCPNetworkModule(socketFactory, string3, n, string);
        tCPNetworkModule.setConnectTimeout(mqttConnectOptions.getConnectionTimeout());
        return tCPNetworkModule;
    }
}

