/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.SSLNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.security.SSLSocketFactoryFactory;
import org.eclipse.paho.client.mqttv3.spi.NetworkModuleFactory;

public class SSLNetworkModuleFactory
implements NetworkModuleFactory {
    @Override
    public Set<String> getSupportedUriSchemes() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ssl")));
    }

    @Override
    public void validateURI(URI uRI) throws IllegalArgumentException {
        String string = uRI.getPath();
        if (string != null && !string.isEmpty()) {
            throw new IllegalArgumentException(uRI.toString());
        }
    }

    @Override
    public NetworkModule createNetworkModule(URI uRI, MqttConnectOptions mqttConnectOptions, String string) throws MqttException {
        String[] stringArray;
        Object object;
        String string2;
        String string3 = uRI.getHost();
        int n = uRI.getPort();
        if (n == -1) {
            n = 8883;
        }
        if ((string2 = uRI.getPath()) != null && !string2.isEmpty()) {
            throw new IllegalArgumentException(uRI.toString());
        }
        SocketFactory socketFactory = mqttConnectOptions.getSocketFactory();
        SSLSocketFactoryFactory sSLSocketFactoryFactory = null;
        if (socketFactory == null) {
            sSLSocketFactoryFactory = new SSLSocketFactoryFactory();
            object = mqttConnectOptions.getSSLProperties();
            if (null != object) {
                sSLSocketFactoryFactory.initialize((Properties)object, null);
            }
            socketFactory = sSLSocketFactoryFactory.createSocketFactory(null);
        } else if (!(socketFactory instanceof SSLSocketFactory)) {
            throw ExceptionHelper.createMqttException(32105);
        }
        object = new SSLNetworkModule((SSLSocketFactory)socketFactory, string3, n, string);
        ((SSLNetworkModule)object).setSSLhandshakeTimeout(mqttConnectOptions.getConnectionTimeout());
        ((SSLNetworkModule)object).setSSLHostnameVerifier(mqttConnectOptions.getSSLHostnameVerifier());
        ((SSLNetworkModule)object).setHttpsHostnameVerificationEnabled(mqttConnectOptions.isHttpsHostnameVerificationEnabled());
        if (sSLSocketFactoryFactory != null && (stringArray = sSLSocketFactoryFactory.getEnabledCipherSuites(null)) != null) {
            ((SSLNetworkModule)object).setEnabledCiphers(stringArray);
        }
        return object;
    }
}

