/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.TCPNetworkModule;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class SSLNetworkModule
extends TCPNetworkModule {
    private static final String CLASS_NAME = SSLNetworkModule.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private String[] enabledCiphers;
    private int handshakeTimeoutSecs;
    private HostnameVerifier hostnameVerifier;
    private boolean httpsHostnameVerificationEnabled = false;
    private String host;
    private int port;

    public SSLNetworkModule(SSLSocketFactory sSLSocketFactory, String string, int n, String string2) {
        super(sSLSocketFactory, string, n, string2);
        this.host = string;
        this.port = n;
        this.log.setResourceName(string2);
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    public void setEnabledCiphers(String[] stringArray) {
        if (stringArray != null) {
            this.enabledCiphers = (String[])stringArray.clone();
        }
        if (this.socket != null && this.enabledCiphers != null) {
            if (this.log.isLoggable(5)) {
                String string = "";
                for (int i = 0; i < this.enabledCiphers.length; ++i) {
                    if (i > 0) {
                        string = string + ",";
                    }
                    string = string + this.enabledCiphers[i];
                }
                this.log.fine(CLASS_NAME, "setEnabledCiphers", "260", new Object[]{string});
            }
            ((SSLSocket)this.socket).setEnabledCipherSuites(this.enabledCiphers);
        }
    }

    public void setSSLhandshakeTimeout(int n) {
        super.setConnectTimeout(n);
        this.handshakeTimeoutSecs = n;
    }

    public HostnameVerifier getSSLHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setSSLHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public boolean isHttpsHostnameVerificationEnabled() {
        return this.httpsHostnameVerificationEnabled;
    }

    public void setHttpsHostnameVerificationEnabled(boolean bl) {
        this.httpsHostnameVerificationEnabled = bl;
    }

    @Override
    public void start() throws IOException, MqttException {
        Object object;
        super.start();
        this.setEnabledCiphers(this.enabledCiphers);
        int n = this.socket.getSoTimeout();
        this.socket.setSoTimeout(this.handshakeTimeoutSecs * 1000);
        try {
            object = new SSLParameters();
            ArrayList<SNIServerName> arrayList = new ArrayList<SNIServerName>(1);
            arrayList.add(new SNIHostName(this.host));
            ((SSLParameters)object).setServerNames(arrayList);
            ((SSLSocket)this.socket).setSSLParameters((SSLParameters)object);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (this.httpsHostnameVerificationEnabled) {
            try {
                object = new SSLParameters();
                ((SSLParameters)object).setEndpointIdentificationAlgorithm("HTTPS");
                ((SSLSocket)this.socket).setSSLParameters((SSLParameters)object);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        ((SSLSocket)this.socket).startHandshake();
        if (this.hostnameVerifier != null && !this.httpsHostnameVerificationEnabled && !this.hostnameVerifier.verify(this.host, (SSLSession)(object = ((SSLSocket)this.socket).getSession()))) {
            object.invalidate();
            this.socket.close();
            throw new SSLPeerUnverifiedException("Host: " + this.host + ", Peer Host: " + object.getPeerHost());
        }
        this.socket.setSoTimeout(n);
    }

    @Override
    public String getServerURI() {
        return "ssl://" + this.host + ":" + this.port;
    }
}

