/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;
import org.eclipse.paho.client.mqttv3.spi.NetworkModuleFactory;

public class NetworkModuleService {
    private static Logger LOG = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", NetworkModuleService.class.getSimpleName());
    private static final ServiceLoader<NetworkModuleFactory> FACTORY_SERVICE_LOADER = ServiceLoader.load(NetworkModuleFactory.class, NetworkModuleService.class.getClassLoader());
    private static final Pattern AUTHORITY_PATTERN = Pattern.compile("((.+)@)?([^:]*)(:(\\d+))?");
    private static final int AUTH_GROUP_USERINFO = 2;
    private static final int AUTH_GROUP_HOST = 3;
    private static final int AUTH_GROUP_PORT = 5;

    private NetworkModuleService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateURI(String string) throws IllegalArgumentException {
        try {
            URI uRI = new URI(string);
            String string2 = uRI.getScheme();
            if (string2 == null || string2.isEmpty()) {
                throw new IllegalArgumentException("missing scheme in broker URI: " + string);
            }
            string2 = string2.toLowerCase();
            ServiceLoader<NetworkModuleFactory> serviceLoader = FACTORY_SERVICE_LOADER;
            synchronized (serviceLoader) {
                for (NetworkModuleFactory networkModuleFactory : FACTORY_SERVICE_LOADER) {
                    if (!networkModuleFactory.getSupportedUriSchemes().contains(string2)) continue;
                    networkModuleFactory.validateURI(uRI);
                    return;
                }
            }
            throw new IllegalArgumentException("no NetworkModule installed for scheme \"" + string2 + "\" of URI \"" + string + "\"");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Can't parse string to URI \"" + string + "\"", uRISyntaxException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkModule createInstance(String string, MqttConnectOptions mqttConnectOptions, String string2) throws MqttException, IllegalArgumentException {
        try {
            URI uRI = new URI(string);
            NetworkModuleService.applyRFC3986AuthorityPatch(uRI);
            String string3 = uRI.getScheme().toLowerCase();
            ServiceLoader<NetworkModuleFactory> serviceLoader = FACTORY_SERVICE_LOADER;
            synchronized (serviceLoader) {
                for (NetworkModuleFactory networkModuleFactory : FACTORY_SERVICE_LOADER) {
                    if (!networkModuleFactory.getSupportedUriSchemes().contains(string3)) continue;
                    return networkModuleFactory.createNetworkModule(uRI, mqttConnectOptions, string2);
                }
            }
            throw new IllegalArgumentException(uRI.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(string, uRISyntaxException);
        }
    }

    public static void applyRFC3986AuthorityPatch(URI uRI) {
        if (uRI == null || uRI.getHost() != null || uRI.getAuthority() == null || uRI.getAuthority().isEmpty()) {
            return;
        }
        Matcher matcher = AUTHORITY_PATTERN.matcher(uRI.getAuthority());
        if (matcher.find()) {
            NetworkModuleService.setURIField(uRI, "userInfo", matcher.group(2));
            NetworkModuleService.setURIField(uRI, "host", matcher.group(3));
            String string = matcher.group(5);
            NetworkModuleService.setURIField(uRI, "port", string != null ? Integer.parseInt(string) : -1);
        }
    }

    private static void setURIField(URI uRI, String string, Object object) {
        try {
            Field field = URI.class.getDeclaredField(string);
            field.setAccessible(true);
            field.set(uRI, object);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            LOG.warning(NetworkModuleService.class.getName(), "setURIField", "115", new Object[]{uRI.toString()}, exception);
        }
    }
}

