/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;

public class ConnectActionListener
implements IMqttActionListener {
    private MqttClientPersistence persistence;
    private MqttAsyncClient client;
    private ClientComms comms;
    private MqttConnectOptions options;
    private MqttToken userToken;
    private Object userContext;
    private IMqttActionListener userCallback;
    private int originalMqttVersion;
    private MqttCallbackExtended mqttCallbackExtended;
    private boolean reconnect;

    public ConnectActionListener(MqttAsyncClient mqttAsyncClient, MqttClientPersistence mqttClientPersistence, ClientComms clientComms, MqttConnectOptions mqttConnectOptions, MqttToken mqttToken, Object object, IMqttActionListener iMqttActionListener, boolean bl) {
        this.persistence = mqttClientPersistence;
        this.client = mqttAsyncClient;
        this.comms = clientComms;
        this.options = mqttConnectOptions;
        this.userToken = mqttToken;
        this.userContext = object;
        this.userCallback = iMqttActionListener;
        this.originalMqttVersion = mqttConnectOptions.getMqttVersion();
        this.reconnect = bl;
    }

    @Override
    public void onSuccess(IMqttToken iMqttToken) {
        if (this.originalMqttVersion == 0) {
            this.options.setMqttVersion(0);
        }
        this.userToken.internalTok.markComplete(iMqttToken.getResponse(), null);
        this.userToken.internalTok.notifyComplete();
        this.userToken.internalTok.setClient(this.client);
        this.comms.notifyConnect();
        if (this.userCallback != null) {
            this.userToken.setUserContext(this.userContext);
            this.userCallback.onSuccess(this.userToken);
        }
        if (this.mqttCallbackExtended != null) {
            String string = this.comms.getNetworkModules()[this.comms.getNetworkModuleIndex()].getServerURI();
            this.mqttCallbackExtended.connectComplete(this.reconnect, string);
        }
    }

    @Override
    public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
        int n = this.comms.getNetworkModules().length;
        int n2 = this.comms.getNetworkModuleIndex();
        if (n2 + 1 < n || this.originalMqttVersion == 0 && this.options.getMqttVersion() == 4) {
            if (this.originalMqttVersion == 0) {
                if (this.options.getMqttVersion() == 4) {
                    this.options.setMqttVersion(3);
                } else {
                    this.options.setMqttVersion(4);
                    this.comms.setNetworkModuleIndex(n2 + 1);
                }
            } else {
                this.comms.setNetworkModuleIndex(n2 + 1);
            }
            try {
                this.connect();
            }
            catch (MqttPersistenceException mqttPersistenceException) {
                this.onFailure(iMqttToken, mqttPersistenceException);
            }
        } else {
            if (this.originalMqttVersion == 0) {
                this.options.setMqttVersion(0);
            }
            MqttException mqttException = throwable instanceof MqttException ? (MqttException)throwable : new MqttException(throwable);
            this.userToken.internalTok.markComplete(null, mqttException);
            this.userToken.internalTok.notifyComplete();
            this.userToken.internalTok.setClient(this.client);
            if (this.userCallback != null) {
                this.userToken.setUserContext(this.userContext);
                this.userCallback.onFailure(this.userToken, throwable);
            }
        }
    }

    public void connect() throws MqttPersistenceException {
        MqttToken mqttToken = new MqttToken(this.client.getClientId());
        mqttToken.setActionCallback(this);
        mqttToken.setUserContext(this);
        this.persistence.open(this.client.getClientId(), this.client.getServerURI());
        if (this.options.isCleanSession()) {
            this.persistence.clear();
        }
        if (this.options.getMqttVersion() == 0) {
            this.options.setMqttVersion(4);
        }
        try {
            this.comms.connect(this.options, mqttToken);
        }
        catch (MqttException mqttException) {
            this.onFailure(mqttToken, mqttException);
        }
    }

    public void setMqttCallbackExtended(MqttCallbackExtended mqttCallbackExtended) {
        this.mqttCallbackExtended = mqttCallbackExtended;
    }
}

