/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsTokenStore {
    private static final String CLASS_NAME = CommsTokenStore.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private final Hashtable tokens;
    private String logContext;
    private MqttException closedResponse = null;

    public CommsTokenStore(String string) {
        this.log.setResourceName(string);
        this.tokens = new Hashtable();
        this.logContext = string;
        this.log.fine(CLASS_NAME, "<Init>", "308");
    }

    public MqttToken getToken(MqttWireMessage mqttWireMessage) {
        String string = mqttWireMessage.getKey();
        return (MqttToken)this.tokens.get(string);
    }

    public MqttToken getToken(String string) {
        return (MqttToken)this.tokens.get(string);
    }

    public MqttToken removeToken(MqttWireMessage mqttWireMessage) {
        if (mqttWireMessage != null) {
            return this.removeToken(mqttWireMessage.getKey());
        }
        return null;
    }

    public MqttToken removeToken(String string) {
        this.log.fine(CLASS_NAME, "removeToken", "306", new Object[]{string});
        if (null != string) {
            return (MqttToken)this.tokens.remove(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MqttDeliveryToken restoreToken(MqttPublish mqttPublish) {
        MqttDeliveryToken mqttDeliveryToken;
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            String string = Integer.toString(mqttPublish.getMessageId());
            if (this.tokens.containsKey(string)) {
                mqttDeliveryToken = (MqttDeliveryToken)this.tokens.get(string);
                this.log.fine(CLASS_NAME, "restoreToken", "302", new Object[]{string, mqttPublish, mqttDeliveryToken});
            } else {
                mqttDeliveryToken = new MqttDeliveryToken(this.logContext);
                mqttDeliveryToken.internalTok.setKey(string);
                this.tokens.put(string, mqttDeliveryToken);
                this.log.fine(CLASS_NAME, "restoreToken", "303", new Object[]{string, mqttPublish, mqttDeliveryToken});
            }
        }
        return mqttDeliveryToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveToken(MqttToken mqttToken, MqttWireMessage mqttWireMessage) throws MqttException {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            if (this.closedResponse != null) {
                throw this.closedResponse;
            }
            String string = mqttWireMessage.getKey();
            this.log.fine(CLASS_NAME, "saveToken", "300", new Object[]{string, mqttWireMessage});
            this.saveToken(mqttToken, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveToken(MqttToken mqttToken, String string) {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(CLASS_NAME, "saveToken", "307", new Object[]{string, mqttToken.toString()});
            mqttToken.internalTok.setKey(string);
            this.tokens.put(string, mqttToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quiesce(MqttException mqttException) {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(CLASS_NAME, "quiesce", "309", new Object[]{mqttException});
            this.closedResponse = mqttException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(CLASS_NAME, "open", "310");
            this.closedResponse = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttDeliveryToken[] getOutstandingDelTokens() {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(CLASS_NAME, "getOutstandingDelTokens", "311");
            Vector<MqttToken> vector = new Vector<MqttToken>();
            Enumeration enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                MqttToken mqttToken = (MqttToken)enumeration.nextElement();
                if (mqttToken == null || !(mqttToken instanceof MqttDeliveryToken) || mqttToken.internalTok.isNotified()) continue;
                vector.addElement(mqttToken);
            }
            MqttDeliveryToken[] mqttDeliveryTokenArray = new MqttDeliveryToken[vector.size()];
            return vector.toArray(mqttDeliveryTokenArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getOutstandingTokens() {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.log.fine(CLASS_NAME, "getOutstandingTokens", "312");
            Vector<MqttToken> vector = new Vector<MqttToken>();
            Enumeration enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                MqttToken mqttToken = (MqttToken)enumeration.nextElement();
                if (mqttToken == null) continue;
                vector.addElement(mqttToken);
            }
            return vector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.log.fine(CLASS_NAME, "clear", "305", new Object[]{this.tokens.size()});
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            this.tokens.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            return this.tokens.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string = System.getProperty("line.separator", "\n");
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable hashtable = this.tokens;
        synchronized (hashtable) {
            Enumeration enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                MqttToken mqttToken = (MqttToken)enumeration.nextElement();
                stringBuffer.append("{" + mqttToken.internalTok + "}" + string);
            }
            return stringBuffer.toString();
        }
    }
}

