/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsCallback
implements Runnable {
    private static final String CLASS_NAME = CommsCallback.class.getName();
    private final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private static final int INBOUND_QUEUE_SIZE = 10;
    private MqttCallback mqttCallback;
    private MqttCallbackExtended reconnectInternalCallback;
    private Hashtable<String, IMqttMessageListener> callbacks;
    private ClientComms clientComms;
    private final Vector<MqttWireMessage> messageQueue;
    private final Vector<MqttToken> completeQueue;
    private State current_state = State.STOPPED;
    private State target_state = State.STOPPED;
    private final Object lifecycle = new Object();
    private Thread callbackThread;
    private String threadName;
    private Future<?> callbackFuture;
    private final Object workAvailable = new Object();
    private final Object spaceAvailable = new Object();
    private ClientState clientState;
    private boolean manualAcks = false;

    CommsCallback(ClientComms clientComms) {
        this.clientComms = clientComms;
        this.messageQueue = new Vector(10);
        this.completeQueue = new Vector(10);
        this.callbacks = new Hashtable();
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String string, ExecutorService executorService) {
        this.threadName = string;
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.current_state == State.STOPPED) {
                this.messageQueue.clear();
                this.completeQueue.clear();
                this.target_state = State.RUNNING;
                if (executorService == null) {
                    new Thread(this).start();
                } else {
                    this.callbackFuture = executorService.submit(this);
                }
            }
        }
        while (!this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.callbackFuture != null) {
                this.callbackFuture.cancel(true);
            }
        }
        if (this.isRunning()) {
            this.log.fine(CLASS_NAME, "stop", "700");
            object = this.lifecycle;
            synchronized (object) {
                this.target_state = State.STOPPED;
            }
            if (!Thread.currentThread().equals(this.callbackThread)) {
                object = this.workAvailable;
                synchronized (object) {
                    this.log.fine(CLASS_NAME, "stop", "701");
                    this.workAvailable.notifyAll();
                }
                while (this.isRunning()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.clientState.notifyQueueLock();
                }
            }
            this.log.fine(CLASS_NAME, "stop", "703");
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    public void setReconnectCallback(MqttCallbackExtended mqttCallbackExtended) {
        this.reconnectInternalCallback = mqttCallbackExtended;
    }

    public void setManualAcks(boolean bl) {
        this.manualAcks = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.callbackThread = Thread.currentThread();
        this.callbackThread.setName(this.threadName);
        Object object = this.lifecycle;
        synchronized (object) {
            this.current_state = State.RUNNING;
        }
        while (this.isRunning()) {
            try {
                try {
                    object = this.workAvailable;
                    synchronized (object) {
                        if (this.isRunning() && this.messageQueue.isEmpty() && this.completeQueue.isEmpty()) {
                            this.log.fine(CLASS_NAME, "run", "704");
                            this.workAvailable.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isRunning()) {
                    object = null;
                    Object object2 = this.completeQueue;
                    synchronized (object2) {
                        if (!this.completeQueue.isEmpty()) {
                            object = this.completeQueue.elementAt(0);
                            this.completeQueue.removeElementAt(0);
                        }
                    }
                    if (null != object) {
                        this.handleActionComplete((MqttToken)object);
                    }
                    object2 = null;
                    Vector<MqttWireMessage> vector = this.messageQueue;
                    synchronized (vector) {
                        if (!this.messageQueue.isEmpty()) {
                            object2 = (MqttPublish)this.messageQueue.elementAt(0);
                            this.messageQueue.removeElementAt(0);
                        }
                    }
                    if (null != object2) {
                        this.handleMessage((MqttPublish)object2);
                    }
                }
                if (!this.isQuiescing()) continue;
                this.clientState.checkQuiesceLock();
            }
            catch (Throwable throwable) {
                this.log.fine(CLASS_NAME, "run", "714", null, throwable);
                this.clientComms.shutdownConnection(null, new MqttException(throwable));
            }
            finally {
                object = this.spaceAvailable;
                synchronized (object) {
                    this.log.fine(CLASS_NAME, "run", "706");
                    this.spaceAvailable.notifyAll();
                }
            }
        }
        object = this.lifecycle;
        synchronized (object) {
            this.current_state = State.STOPPED;
        }
        this.callbackThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActionComplete(MqttToken mqttToken) throws MqttException {
        MqttToken mqttToken2 = mqttToken;
        synchronized (mqttToken2) {
            this.log.fine(CLASS_NAME, "handleActionComplete", "705", new Object[]{mqttToken.internalTok.getKey()});
            if (mqttToken.isComplete()) {
                this.clientState.notifyComplete(mqttToken);
            }
            mqttToken.internalTok.notifyComplete();
            if (!mqttToken.internalTok.isNotified()) {
                if (this.mqttCallback != null && mqttToken instanceof MqttDeliveryToken && mqttToken.isComplete()) {
                    this.mqttCallback.deliveryComplete((MqttDeliveryToken)mqttToken);
                }
                this.fireActionEvent(mqttToken);
            }
            if (mqttToken.isComplete() && mqttToken instanceof MqttDeliveryToken) {
                mqttToken.internalTok.setNotified(true);
            }
        }
    }

    public void connectionLost(MqttException mqttException) {
        try {
            if (this.mqttCallback != null && mqttException != null) {
                this.log.fine(CLASS_NAME, "connectionLost", "708", new Object[]{mqttException});
                this.mqttCallback.connectionLost(mqttException);
            }
            if (this.reconnectInternalCallback != null && mqttException != null) {
                this.reconnectInternalCallback.connectionLost(mqttException);
            }
        }
        catch (Throwable throwable) {
            this.log.fine(CLASS_NAME, "connectionLost", "720", new Object[]{throwable});
        }
    }

    public void fireActionEvent(MqttToken mqttToken) {
        IMqttActionListener iMqttActionListener;
        if (mqttToken != null && (iMqttActionListener = mqttToken.getActionCallback()) != null) {
            if (mqttToken.getException() == null) {
                this.log.fine(CLASS_NAME, "fireActionEvent", "716", new Object[]{mqttToken.internalTok.getKey()});
                iMqttActionListener.onSuccess(mqttToken);
            } else {
                this.log.fine(CLASS_NAME, "fireActionEvent", "716", new Object[]{mqttToken.internalTok.getKey()});
                iMqttActionListener.onFailure(mqttToken, mqttToken.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(MqttPublish mqttPublish) {
        if (this.mqttCallback != null || this.callbacks.size() > 0) {
            Object object = this.spaceAvailable;
            synchronized (object) {
                while (this.isRunning() && !this.isQuiescing() && this.messageQueue.size() >= 10) {
                    try {
                        this.log.fine(CLASS_NAME, "messageArrived", "709");
                        this.spaceAvailable.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.isQuiescing()) {
                this.messageQueue.addElement(mqttPublish);
                object = this.workAvailable;
                synchronized (object) {
                    this.log.fine(CLASS_NAME, "messageArrived", "710");
                    this.workAvailable.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce() {
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.current_state == State.RUNNING) {
                this.current_state = State.QUIESCING;
            }
        }
        object = this.spaceAvailable;
        synchronized (object) {
            this.log.fine(CLASS_NAME, "quiesce", "711");
            this.spaceAvailable.notifyAll();
        }
    }

    public boolean isQuiesced() {
        return this.isQuiescing() && this.completeQueue.size() == 0 && this.messageQueue.size() == 0;
    }

    private void handleMessage(MqttPublish mqttPublish) throws MqttException, Exception {
        String string = mqttPublish.getTopicName();
        this.log.fine(CLASS_NAME, "handleMessage", "713", new Object[]{mqttPublish.getMessageId(), string});
        this.deliverMessage(string, mqttPublish.getMessageId(), mqttPublish.getMessage());
        if (!this.manualAcks) {
            if (mqttPublish.getMessage().getQos() == 1) {
                this.clientComms.internalSend(new MqttPubAck(mqttPublish), new MqttToken(this.clientComms.getClient().getClientId()));
            } else if (mqttPublish.getMessage().getQos() == 2) {
                this.clientComms.deliveryComplete(mqttPublish);
                MqttPubComp mqttPubComp = new MqttPubComp(mqttPublish);
                this.clientComms.internalSend(mqttPubComp, new MqttToken(this.clientComms.getClient().getClientId()));
            }
        }
    }

    public void messageArrivedComplete(int n, int n2) throws MqttException {
        if (n2 == 1) {
            this.clientComms.internalSend(new MqttPubAck(n), new MqttToken(this.clientComms.getClient().getClientId()));
        } else if (n2 == 2) {
            this.clientComms.deliveryComplete(n);
            MqttPubComp mqttPubComp = new MqttPubComp(n);
            this.clientComms.internalSend(mqttPubComp, new MqttToken(this.clientComms.getClient().getClientId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncOperationComplete(MqttToken mqttToken) {
        if (this.isRunning()) {
            this.completeQueue.addElement(mqttToken);
            Object object = this.workAvailable;
            synchronized (object) {
                this.log.fine(CLASS_NAME, "asyncOperationComplete", "715", new Object[]{mqttToken.internalTok.getKey()});
                this.workAvailable.notifyAll();
            }
        }
        try {
            this.handleActionComplete(mqttToken);
        }
        catch (Throwable throwable) {
            this.log.fine(CLASS_NAME, "asyncOperationComplete", "719", null, throwable);
            this.clientComms.shutdownConnection(null, new MqttException(throwable));
        }
    }

    protected Thread getThread() {
        return this.callbackThread;
    }

    public void setMessageListener(String string, IMqttMessageListener iMqttMessageListener) {
        this.callbacks.put(string, iMqttMessageListener);
    }

    public void removeMessageListener(String string) {
        this.callbacks.remove(string);
    }

    public void removeMessageListeners() {
        this.callbacks.clear();
    }

    protected boolean deliverMessage(String string, int n, MqttMessage mqttMessage) throws Exception {
        boolean bl = false;
        Enumeration<String> enumeration = this.callbacks.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            IMqttMessageListener iMqttMessageListener = this.callbacks.get(string2);
            if (iMqttMessageListener == null || !MqttTopic.isMatched(string2, string)) continue;
            mqttMessage.setId(n);
            iMqttMessageListener.messageArrived(string, mqttMessage);
            bl = true;
        }
        if (this.mqttCallback != null && !bl) {
            mqttMessage.setId(n);
            this.mqttCallback.messageArrived(string, mqttMessage);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        boolean bl;
        Object object = this.lifecycle;
        synchronized (object) {
            bl = (this.current_state == State.RUNNING || this.current_state == State.QUIESCING) && this.target_state == State.RUNNING;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQuiescing() {
        boolean bl;
        Object object = this.lifecycle;
        synchronized (object) {
            bl = this.current_state == State.QUIESCING;
        }
        return bl;
    }

    private static enum State {
        STOPPED,
        RUNNING,
        QUIESCING;

    }
}

