/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.NetworkModuleService;
import org.eclipse.paho.client.mqttv3.util.Debug;

public class MqttConnectOptions {
    public static final int KEEP_ALIVE_INTERVAL_DEFAULT = 60;
    public static final int CONNECTION_TIMEOUT_DEFAULT = 30;
    public static final int MAX_INFLIGHT_DEFAULT = 10;
    public static final boolean CLEAN_SESSION_DEFAULT = true;
    public static final int MQTT_VERSION_DEFAULT = 0;
    public static final int MQTT_VERSION_3_1 = 3;
    public static final int MQTT_VERSION_3_1_1 = 4;
    private int keepAliveInterval = 60;
    private int maxInflight = 10;
    private String willDestination = null;
    private MqttMessage willMessage = null;
    private String userName;
    private char[] password;
    private SocketFactory socketFactory;
    private Properties sslClientProps = null;
    private boolean httpsHostnameVerificationEnabled = true;
    private HostnameVerifier sslHostnameVerifier = null;
    private boolean cleanSession = true;
    private int connectionTimeout = 30;
    private String[] serverURIs = null;
    private int mqttVersion = 0;
    private boolean automaticReconnect = false;
    private int maxReconnectDelay = 128000;
    private Properties customWebSocketHeaders = null;
    private int executorServiceTimeout = 1;

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] cArray) {
        this.password = (char[])cArray.clone();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public int getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(int n) {
        this.maxReconnectDelay = n;
    }

    public void setWill(MqttTopic mqttTopic, byte[] byArray, int n, boolean bl) {
        String string = mqttTopic.getName();
        this.validateWill(string, byArray);
        this.setWill(string, new MqttMessage(byArray), n, bl);
    }

    public void setWill(String string, byte[] byArray, int n, boolean bl) {
        this.validateWill(string, byArray);
        this.setWill(string, new MqttMessage(byArray), n, bl);
    }

    private void validateWill(String string, Object object) {
        if (string == null || object == null) {
            throw new IllegalArgumentException();
        }
        MqttTopic.validate(string, false);
    }

    protected void setWill(String string, MqttMessage mqttMessage, int n, boolean bl) {
        this.willDestination = string;
        this.willMessage = mqttMessage;
        this.willMessage.setQos(n);
        this.willMessage.setRetained(bl);
        this.willMessage.setMutable(false);
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public int getMqttVersion() {
        return this.mqttVersion;
    }

    public void setKeepAliveInterval(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.keepAliveInterval = n;
    }

    public int getMaxInflight() {
        return this.maxInflight;
    }

    public void setMaxInflight(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.maxInflight = n;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.connectionTimeout = n;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public String getWillDestination() {
        return this.willDestination;
    }

    public MqttMessage getWillMessage() {
        return this.willMessage;
    }

    public Properties getSSLProperties() {
        return this.sslClientProps;
    }

    public void setSSLProperties(Properties properties) {
        this.sslClientProps = properties;
    }

    public boolean isHttpsHostnameVerificationEnabled() {
        return this.httpsHostnameVerificationEnabled;
    }

    public void setHttpsHostnameVerificationEnabled(boolean bl) {
        this.httpsHostnameVerificationEnabled = bl;
    }

    public HostnameVerifier getSSLHostnameVerifier() {
        return this.sslHostnameVerifier;
    }

    public void setSSLHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.sslHostnameVerifier = hostnameVerifier;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public void setCleanSession(boolean bl) {
        this.cleanSession = bl;
    }

    public String[] getServerURIs() {
        return this.serverURIs;
    }

    public void setServerURIs(String[] stringArray) {
        for (String string : stringArray) {
            NetworkModuleService.validateURI(string);
        }
        this.serverURIs = (String[])stringArray.clone();
    }

    public void setMqttVersion(int n) throws IllegalArgumentException {
        if (n != 0 && n != 3 && n != 4) {
            throw new IllegalArgumentException("An incorrect version was used \"" + n + "\". Acceptable version options are " + 0 + ", " + 3 + " and " + 4 + ".");
        }
        this.mqttVersion = n;
    }

    public boolean isAutomaticReconnect() {
        return this.automaticReconnect;
    }

    public void setAutomaticReconnect(boolean bl) {
        this.automaticReconnect = bl;
    }

    public int getExecutorServiceTimeout() {
        return this.executorServiceTimeout;
    }

    public void setExecutorServiceTimeout(int n) {
        this.executorServiceTimeout = n;
    }

    public Properties getDebug() {
        Properties properties = new Properties();
        properties.put("MqttVersion", (Object)this.getMqttVersion());
        properties.put("CleanSession", (Object)this.isCleanSession());
        properties.put("ConTimeout", (Object)this.getConnectionTimeout());
        properties.put("KeepAliveInterval", (Object)this.getKeepAliveInterval());
        properties.put("UserName", this.getUserName() == null ? "null" : this.getUserName());
        properties.put("WillDestination", this.getWillDestination() == null ? "null" : this.getWillDestination());
        if (this.getSocketFactory() == null) {
            properties.put("SocketFactory", "null");
        } else {
            properties.put("SocketFactory", this.getSocketFactory());
        }
        if (this.getSSLProperties() == null) {
            properties.put("SSLProperties", "null");
        } else {
            properties.put("SSLProperties", this.getSSLProperties());
        }
        return properties;
    }

    public void setCustomWebSocketHeaders(Properties properties) {
        this.customWebSocketHeaders = properties;
    }

    public Properties getCustomWebSocketHeaders() {
        return this.customWebSocketHeaders;
    }

    public String toString() {
        return Debug.dumpProperties(this.getDebug(), "Connection options");
    }
}

