/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.TimerPingSender;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ConnectActionListener;
import org.eclipse.paho.client.mqttv3.internal.DisconnectedMessageBuffer;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.HighResolutionTimer;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.NetworkModuleService;
import org.eclipse.paho.client.mqttv3.internal.SystemHighResolutionTimer;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubscribe;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.eclipse.paho.client.mqttv3.util.Debug;

public class MqttAsyncClient
implements IMqttAsyncClient {
    private static final String CLASS_NAME = MqttAsyncClient.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private static final String CLIENT_ID_PREFIX = "paho";
    private static final long QUIESCE_TIMEOUT = 30000L;
    private static final long DISCONNECT_TIMEOUT = 10000L;
    private static final char MIN_HIGH_SURROGATE = '\ud800';
    private static final char MAX_HIGH_SURROGATE = '\udbff';
    private String clientId;
    private String serverURI;
    protected ClientComms comms;
    private Hashtable topics;
    private MqttClientPersistence persistence;
    private MqttCallback mqttCallback;
    private MqttConnectOptions connOpts;
    private Object userContext;
    private Timer reconnectTimer;
    private static int reconnectDelay = 1000;
    private boolean reconnecting = false;
    private static final Object clientLock = new Object();
    private ScheduledExecutorService executorService;

    public MqttAsyncClient(String string, String string2) throws MqttException {
        this(string, string2, new MqttDefaultFilePersistence());
    }

    public MqttAsyncClient(String string, String string2, MqttClientPersistence mqttClientPersistence) throws MqttException {
        this(string, string2, mqttClientPersistence, new TimerPingSender());
    }

    public MqttAsyncClient(String string, String string2, MqttClientPersistence mqttClientPersistence, MqttPingSender mqttPingSender) throws MqttException {
        this(string, string2, mqttClientPersistence, mqttPingSender, null);
    }

    public MqttAsyncClient(String string, String string2, MqttClientPersistence mqttClientPersistence, MqttPingSender mqttPingSender, ScheduledExecutorService scheduledExecutorService) throws MqttException {
        this(string, string2, mqttClientPersistence, mqttPingSender, scheduledExecutorService, null);
    }

    public MqttAsyncClient(String string, String string2, MqttClientPersistence mqttClientPersistence, MqttPingSender mqttPingSender, ScheduledExecutorService scheduledExecutorService, HighResolutionTimer highResolutionTimer) throws MqttException {
        this.log.setResourceName(string2);
        if (string2 == null) {
            throw new IllegalArgumentException("Null clientId");
        }
        int n = 0;
        for (int i = 0; i < string2.length() - 1; ++i) {
            if (MqttAsyncClient.Character_isHighSurrogate(string2.charAt(i))) {
                ++i;
            }
            ++n;
        }
        if (n > 65535) {
            throw new IllegalArgumentException("ClientId longer than 65535 characters");
        }
        NetworkModuleService.validateURI(string);
        this.serverURI = string;
        this.clientId = string2;
        this.persistence = mqttClientPersistence;
        if (this.persistence == null) {
            this.persistence = new MemoryPersistence();
        }
        if (highResolutionTimer == null) {
            highResolutionTimer = new SystemHighResolutionTimer();
        }
        this.executorService = scheduledExecutorService;
        this.log.fine(CLASS_NAME, "MqttAsyncClient", "101", new Object[]{string2, string, mqttClientPersistence});
        this.persistence.open(string2, string);
        this.comms = new ClientComms(this, this.persistence, mqttPingSender, this.executorService, highResolutionTimer);
        this.persistence.close();
        this.topics = new Hashtable();
    }

    protected static boolean Character_isHighSurrogate(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    protected NetworkModule[] createNetworkModules(String string, MqttConnectOptions mqttConnectOptions) throws MqttException, MqttSecurityException {
        this.log.fine(CLASS_NAME, "createNetworkModules", "116", new Object[]{string});
        NetworkModule[] networkModuleArray = null;
        String[] stringArray = mqttConnectOptions.getServerURIs();
        String[] stringArray2 = null;
        stringArray2 = stringArray == null ? new String[]{string} : (stringArray.length == 0 ? new String[]{string} : stringArray);
        networkModuleArray = new NetworkModule[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            networkModuleArray[i] = this.createNetworkModule(stringArray2[i], mqttConnectOptions);
        }
        this.log.fine(CLASS_NAME, "createNetworkModules", "108");
        return networkModuleArray;
    }

    private NetworkModule createNetworkModule(String string, MqttConnectOptions mqttConnectOptions) throws MqttException, MqttSecurityException {
        this.log.fine(CLASS_NAME, "createNetworkModule", "115", new Object[]{string});
        NetworkModule networkModule = NetworkModuleService.createInstance(string, mqttConnectOptions, this.clientId);
        return networkModule;
    }

    private String getHostName(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            n = string.indexOf(47);
        }
        if (n == -1) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    @Override
    public IMqttToken connect(Object object, IMqttActionListener iMqttActionListener) throws MqttException, MqttSecurityException {
        return this.connect(new MqttConnectOptions(), object, iMqttActionListener);
    }

    @Override
    public IMqttToken connect() throws MqttException, MqttSecurityException {
        return this.connect(null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions mqttConnectOptions) throws MqttException, MqttSecurityException {
        return this.connect(mqttConnectOptions, null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions mqttConnectOptions, Object object, IMqttActionListener iMqttActionListener) throws MqttException, MqttSecurityException {
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        if (mqttConnectOptions == null) {
            mqttConnectOptions = new MqttConnectOptions();
        }
        this.connOpts = mqttConnectOptions;
        this.userContext = object;
        boolean bl = mqttConnectOptions.isAutomaticReconnect();
        this.log.fine(CLASS_NAME, "connect", "103", new Object[]{mqttConnectOptions.isCleanSession(), mqttConnectOptions.getConnectionTimeout(), mqttConnectOptions.getKeepAliveInterval(), mqttConnectOptions.getUserName(), null == mqttConnectOptions.getPassword() ? "[null]" : "[notnull]", null == mqttConnectOptions.getWillMessage() ? "[null]" : "[notnull]", object, iMqttActionListener});
        this.comms.setNetworkModules(this.createNetworkModules(this.serverURI, mqttConnectOptions));
        this.comms.setReconnectCallback(new MqttReconnectCallback(bl));
        MqttToken mqttToken = new MqttToken(this.getClientId());
        ConnectActionListener connectActionListener = new ConnectActionListener(this, this.persistence, this.comms, mqttConnectOptions, mqttToken, object, iMqttActionListener, this.reconnecting);
        mqttToken.setActionCallback(connectActionListener);
        mqttToken.setUserContext(this);
        if (this.mqttCallback instanceof MqttCallbackExtended) {
            connectActionListener.setMqttCallbackExtended((MqttCallbackExtended)this.mqttCallback);
        }
        this.comms.setNetworkModuleIndex(0);
        connectActionListener.connect();
        return mqttToken;
    }

    @Override
    public IMqttToken disconnect(Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        return this.disconnect(30000L, object, iMqttActionListener);
    }

    @Override
    public IMqttToken disconnect() throws MqttException {
        return this.disconnect(null, null);
    }

    @Override
    public IMqttToken disconnect(long l) throws MqttException {
        return this.disconnect(l, null, null);
    }

    @Override
    public IMqttToken disconnect(long l, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        this.log.fine(CLASS_NAME, "disconnect", "104", new Object[]{l, object, iMqttActionListener});
        MqttToken mqttToken = new MqttToken(this.getClientId());
        mqttToken.setActionCallback(iMqttActionListener);
        mqttToken.setUserContext(object);
        MqttDisconnect mqttDisconnect = new MqttDisconnect();
        try {
            this.comms.disconnect(mqttDisconnect, l, mqttToken);
        }
        catch (MqttException mqttException) {
            this.log.fine(CLASS_NAME, "disconnect", "105", null, mqttException);
            throw mqttException;
        }
        this.log.fine(CLASS_NAME, "disconnect", "108");
        return mqttToken;
    }

    @Override
    public void disconnectForcibly() throws MqttException {
        this.disconnectForcibly(30000L, 10000L);
    }

    @Override
    public void disconnectForcibly(long l) throws MqttException {
        this.disconnectForcibly(30000L, l);
    }

    @Override
    public void disconnectForcibly(long l, long l2) throws MqttException {
        this.comms.disconnectForcibly(l, l2);
    }

    public void disconnectForcibly(long l, long l2, boolean bl) throws MqttException {
        this.comms.disconnectForcibly(l, l2, bl);
    }

    @Override
    public boolean isConnected() {
        return this.comms.isConnected();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    public String getCurrentServerURI() {
        return this.comms.getNetworkModules()[this.comms.getNetworkModuleIndex()].getServerURI();
    }

    protected MqttTopic getTopic(String string) {
        MqttTopic.validate(string, false);
        MqttTopic mqttTopic = (MqttTopic)this.topics.get(string);
        if (mqttTopic == null) {
            mqttTopic = new MqttTopic(string, this.comms);
            this.topics.put(string, mqttTopic);
        }
        return mqttTopic;
    }

    public IMqttToken checkPing(Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        this.log.fine(CLASS_NAME, "ping", "117");
        MqttToken mqttToken = this.comms.checkForActivity(iMqttActionListener);
        this.log.fine(CLASS_NAME, "ping", "118");
        return mqttToken;
    }

    @Override
    public IMqttToken subscribe(String string, int n, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        return this.subscribe(new String[]{string}, new int[]{n}, object, iMqttActionListener);
    }

    @Override
    public IMqttToken subscribe(String string, int n) throws MqttException {
        return this.subscribe(new String[]{string}, new int[]{n}, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] stringArray, int[] nArray) throws MqttException {
        return this.subscribe(stringArray, nArray, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] stringArray, int[] nArray, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        if (stringArray.length != nArray.length) {
            throw new IllegalArgumentException();
        }
        for (String string : stringArray) {
            MqttTopic.validate(string, true);
            this.comms.removeMessageListener(string);
        }
        return this.subscribeBase(stringArray, nArray, object, iMqttActionListener);
    }

    private IMqttToken subscribeBase(String[] stringArray, int[] nArray, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        Object object2;
        if (this.log.isLoggable(5)) {
            object2 = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    ((StringBuffer)object2).append(", ");
                }
                ((StringBuffer)object2).append("topic=").append(stringArray[i]).append(" qos=").append(nArray[i]);
            }
            this.log.fine(CLASS_NAME, "subscribe", "106", new Object[]{((StringBuffer)object2).toString(), object, iMqttActionListener});
        }
        object2 = new MqttToken(this.getClientId());
        ((MqttToken)object2).setActionCallback(iMqttActionListener);
        ((MqttToken)object2).setUserContext(object);
        ((MqttToken)object2).internalTok.setTopics(stringArray);
        MqttSubscribe mqttSubscribe = new MqttSubscribe(stringArray, nArray);
        this.comms.sendNoWait(mqttSubscribe, (MqttToken)object2);
        this.log.fine(CLASS_NAME, "subscribe", "109");
        return object2;
    }

    @Override
    public IMqttToken subscribe(String string, int n, Object object, IMqttActionListener iMqttActionListener, IMqttMessageListener iMqttMessageListener) throws MqttException {
        return this.subscribe(new String[]{string}, new int[]{n}, object, iMqttActionListener, new IMqttMessageListener[]{iMqttMessageListener});
    }

    @Override
    public IMqttToken subscribe(String string, int n, IMqttMessageListener iMqttMessageListener) throws MqttException {
        return this.subscribe(new String[]{string}, new int[]{n}, null, null, new IMqttMessageListener[]{iMqttMessageListener});
    }

    @Override
    public IMqttToken subscribe(String[] stringArray, int[] nArray, IMqttMessageListener[] iMqttMessageListenerArray) throws MqttException {
        return this.subscribe(stringArray, nArray, null, null, iMqttMessageListenerArray);
    }

    @Override
    public IMqttToken subscribe(String[] stringArray, int[] nArray, Object object, IMqttActionListener iMqttActionListener, IMqttMessageListener[] iMqttMessageListenerArray) throws MqttException {
        if (iMqttMessageListenerArray != null && iMqttMessageListenerArray.length != nArray.length || nArray.length != stringArray.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            MqttTopic.validate(stringArray[i], true);
            if (iMqttMessageListenerArray == null || iMqttMessageListenerArray[i] == null) {
                this.comms.removeMessageListener(stringArray[i]);
                continue;
            }
            this.comms.setMessageListener(stringArray[i], iMqttMessageListenerArray[i]);
        }
        IMqttToken iMqttToken = null;
        try {
            iMqttToken = this.subscribeBase(stringArray, nArray, object, iMqttActionListener);
        }
        catch (Exception exception) {
            for (String string : stringArray) {
                this.comms.removeMessageListener(string);
            }
            throw exception;
        }
        return iMqttToken;
    }

    @Override
    public IMqttToken unsubscribe(String string, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        return this.unsubscribe(new String[]{string}, object, iMqttActionListener);
    }

    @Override
    public IMqttToken unsubscribe(String string) throws MqttException {
        return this.unsubscribe(new String[]{string}, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] stringArray) throws MqttException {
        return this.unsubscribe(stringArray, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] stringArray, Object object, IMqttActionListener iMqttActionListener) throws MqttException {
        Object object2;
        if (this.log.isLoggable(5)) {
            object2 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    object2 = (String)object2 + ", ";
                }
                object2 = (String)object2 + stringArray[i];
            }
            this.log.fine(CLASS_NAME, "unsubscribe", "107", new Object[]{object2, object, iMqttActionListener});
        }
        for (String string : stringArray) {
            MqttTopic.validate(string, true);
        }
        for (String string : stringArray) {
            this.comms.removeMessageListener(string);
        }
        object2 = new MqttToken(this.getClientId());
        ((MqttToken)object2).setActionCallback(iMqttActionListener);
        ((MqttToken)object2).setUserContext(object);
        ((MqttToken)object2).internalTok.setTopics(stringArray);
        MqttUnsubscribe mqttUnsubscribe = new MqttUnsubscribe(stringArray);
        this.comms.sendNoWait(mqttUnsubscribe, (MqttToken)object2);
        this.log.fine(CLASS_NAME, "unsubscribe", "110");
        return object2;
    }

    @Override
    public boolean removeMessage(IMqttDeliveryToken iMqttDeliveryToken) throws MqttException {
        return this.comms.removeMessage(iMqttDeliveryToken);
    }

    @Override
    public void setCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
        this.comms.setCallback(mqttCallback);
    }

    @Override
    public void setManualAcks(boolean bl) {
        this.comms.setManualAcks(bl);
    }

    @Override
    public void messageArrivedComplete(int n, int n2) throws MqttException {
        this.comms.messageArrivedComplete(n, n2);
    }

    public static String generateClientId() {
        return CLIENT_ID_PREFIX + System.nanoTime();
    }

    @Override
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.comms.getPendingDeliveryTokens();
    }

    @Override
    public IMqttDeliveryToken publish(String string, byte[] byArray, int n, boolean bl, Object object, IMqttActionListener iMqttActionListener) throws MqttException, MqttPersistenceException {
        MqttMessage mqttMessage = new MqttMessage(byArray);
        mqttMessage.setQos(n);
        mqttMessage.setRetained(bl);
        return this.publish(string, mqttMessage, object, iMqttActionListener);
    }

    @Override
    public IMqttDeliveryToken publish(String string, byte[] byArray, int n, boolean bl) throws MqttException, MqttPersistenceException {
        return this.publish(string, byArray, n, bl, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String string, MqttMessage mqttMessage) throws MqttException, MqttPersistenceException {
        return this.publish(string, mqttMessage, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String string, MqttMessage mqttMessage, Object object, IMqttActionListener iMqttActionListener) throws MqttException, MqttPersistenceException {
        this.log.fine(CLASS_NAME, "publish", "111", new Object[]{string, object, iMqttActionListener});
        MqttTopic.validate(string, false);
        MqttDeliveryToken mqttDeliveryToken = new MqttDeliveryToken(this.getClientId());
        mqttDeliveryToken.setActionCallback(iMqttActionListener);
        mqttDeliveryToken.setUserContext(object);
        mqttDeliveryToken.setMessage(mqttMessage);
        mqttDeliveryToken.internalTok.setTopics(new String[]{string});
        MqttPublish mqttPublish = new MqttPublish(string, mqttMessage);
        this.comms.sendNoWait(mqttPublish, mqttDeliveryToken);
        this.log.fine(CLASS_NAME, "publish", "112");
        return mqttDeliveryToken;
    }

    @Override
    public void reconnect() throws MqttException {
        this.log.fine(CLASS_NAME, "reconnect", "500", new Object[]{this.clientId});
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        this.stopReconnectCycle();
        this.attemptReconnect();
    }

    private void attemptReconnect() {
        this.log.fine(CLASS_NAME, "attemptReconnect", "500", new Object[]{this.clientId});
        try {
            this.connect(this.connOpts, this.userContext, new MqttReconnectActionListener("attemptReconnect"));
        }
        catch (MqttSecurityException mqttSecurityException) {
            this.log.fine(CLASS_NAME, "attemptReconnect", "804", null, mqttSecurityException);
        }
        catch (MqttException mqttException) {
            this.log.fine(CLASS_NAME, "attemptReconnect", "804", null, mqttException);
        }
    }

    private void startReconnectCycle() {
        String string = "startReconnectCycle";
        this.log.fine(CLASS_NAME, string, "503", new Object[]{this.clientId, (long)reconnectDelay});
        this.reconnectTimer = new Timer("MQTT Reconnect: " + this.clientId);
        this.reconnectTimer.schedule((TimerTask)new ReconnectTask(), reconnectDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReconnectCycle() {
        String string = "stopReconnectCycle";
        this.log.fine(CLASS_NAME, string, "504", new Object[]{this.clientId});
        Object object = clientLock;
        synchronized (object) {
            if (this.connOpts.isAutomaticReconnect()) {
                if (this.reconnectTimer != null) {
                    this.reconnectTimer.cancel();
                    this.reconnectTimer = null;
                }
                reconnectDelay = 1000;
            }
        }
    }

    @Override
    public void setBufferOpts(DisconnectedBufferOptions disconnectedBufferOptions) {
        this.comms.setDisconnectedMessageBuffer(new DisconnectedMessageBuffer(disconnectedBufferOptions));
    }

    @Override
    public int getBufferedMessageCount() {
        return this.comms.getBufferedMessageCount();
    }

    @Override
    public MqttMessage getBufferedMessage(int n) {
        return this.comms.getBufferedMessage(n);
    }

    @Override
    public void deleteBufferedMessage(int n) {
        this.comms.deleteBufferedMessage(n);
    }

    @Override
    public int getInFlightMessageCount() {
        return this.comms.getActualInFlight();
    }

    @Override
    public void close() throws MqttException {
        this.close(false);
    }

    public void close(boolean bl) throws MqttException {
        this.log.fine(CLASS_NAME, "close", "113");
        this.comms.close(bl);
        this.log.fine(CLASS_NAME, "close", "114");
    }

    public Debug getDebug() {
        return new Debug(this.clientId, this.comms);
    }

    class MqttReconnectActionListener
    implements IMqttActionListener {
        final String methodName;

        MqttReconnectActionListener(String string) {
            this.methodName = string;
        }

        @Override
        public void onSuccess(IMqttToken iMqttToken) {
            MqttAsyncClient.this.log.fine(CLASS_NAME, this.methodName, "501", new Object[]{iMqttToken.getClient().getClientId()});
            MqttAsyncClient.this.comms.setRestingState(false);
            MqttAsyncClient.this.stopReconnectCycle();
        }

        @Override
        public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
            MqttAsyncClient.this.log.fine(CLASS_NAME, this.methodName, "502", new Object[]{iMqttToken.getClient().getClientId()});
            if (reconnectDelay < MqttAsyncClient.this.connOpts.getMaxReconnectDelay()) {
                reconnectDelay = reconnectDelay * 2;
            }
            this.rescheduleReconnectCycle(reconnectDelay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rescheduleReconnectCycle(int n) {
            String string = this.methodName + ":rescheduleReconnectCycle";
            MqttAsyncClient.this.log.fine(CLASS_NAME, string, "505", new Object[]{MqttAsyncClient.this.clientId, String.valueOf(reconnectDelay)});
            Object object = clientLock;
            synchronized (object) {
                if (MqttAsyncClient.this.connOpts.isAutomaticReconnect()) {
                    if (MqttAsyncClient.this.reconnectTimer != null) {
                        MqttAsyncClient.this.reconnectTimer.schedule((TimerTask)new ReconnectTask(), n);
                    } else {
                        reconnectDelay = n;
                        MqttAsyncClient.this.startReconnectCycle();
                    }
                }
            }
        }
    }

    class MqttReconnectCallback
    implements MqttCallbackExtended {
        final boolean automaticReconnect;

        MqttReconnectCallback(boolean bl) {
            this.automaticReconnect = bl;
        }

        @Override
        public void connectionLost(Throwable throwable) {
            if (this.automaticReconnect) {
                MqttAsyncClient.this.comms.setRestingState(true);
                MqttAsyncClient.this.reconnecting = true;
                MqttAsyncClient.this.startReconnectCycle();
            }
        }

        @Override
        public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
        }

        @Override
        public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
        }

        @Override
        public void connectComplete(boolean bl, String string) {
        }
    }

    private class ReconnectTask
    extends TimerTask {
        private static final String methodName = "ReconnectTask.run";

        private ReconnectTask() {
        }

        @Override
        public void run() {
            MqttAsyncClient.this.log.fine(CLASS_NAME, methodName, "506");
            MqttAsyncClient.this.attemptReconnect();
        }
    }
}

