/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.server;

import certa.modbus.ModbusPdu;
import certa.modbus.server.AModbusServer;
import certa.modbus.server.RegistersTable;
import certa.modbus.server.RequestProcessor;

public class DefaultRequestProcessor
implements RequestProcessor {
    public final AModbusServer server;

    public DefaultRequestProcessor(AModbusServer aModbusServer) {
        this.server = aModbusServer;
    }

    protected void setException(ModbusPdu modbusPdu, int n) {
        this.server.log.debug("Sending exception {}", (Object)n);
        modbusPdu.setPduSize(2);
        modbusPdu.writeByteToPDU(0, (byte)(modbusPdu.readByteFromPDU(0) | 0x80));
        modbusPdu.writeByteToPDU(1, (byte)n);
    }

    private boolean validRange(ModbusPdu modbusPdu, int n, int n2, RegistersTable registersTable, String string, int n3) {
        if (n2 < 1 || n2 > n3) {
            this.server.log.warn("Invalid {} count ({}). Must be 1..{}", string, n2, n3);
            this.setException(modbusPdu, 3);
            return false;
        }
        int n4 = n + n2 - 1;
        if (!registersTable.isValidAddress(n) || !registersTable.isValidAddress(n4)) {
            this.server.log.warn("Invalid {} range ({} - {}). Can be {} - {}", string, n, n4, registersTable.firstAddress(), registersTable.lastAddress());
            this.setException(modbusPdu, 2);
            return false;
        }
        return true;
    }

    private boolean validPduSize(ModbusPdu modbusPdu, int n) {
        if (modbusPdu.getPduSize() < n) {
            this.server.log.warn("Invalid PDU size ({}). Must be {}", (Object)modbusPdu.getPduSize(), (Object)n);
            modbusPdu.setPduSize(0);
            return false;
        }
        return true;
    }

    private void processReadBits(ModbusPdu modbusPdu, RegistersTable registersTable, String string) {
        int n;
        int n2 = modbusPdu.readInt16FromPDU(1, true);
        int n3 = modbusPdu.readInt16FromPDU(3, true);
        this.server.log.debug("Read {}: addr={}, count={}", string, n2, n3);
        if (!this.validRange(modbusPdu, n2, n3, registersTable, string, 2000)) {
            return;
        }
        int n4 = ModbusPdu.bytesCount(n3);
        modbusPdu.setPduSize(2 + n4);
        modbusPdu.writeByteToPDU(1, (byte)n4);
        for (n = 0; n < n4; ++n) {
            modbusPdu.writeByteToPDU(2 + n, (byte)0);
        }
        for (n = 0; n < n3; ++n) {
            modbusPdu.writeBitToPDU(2, n, registersTable.getBool(n2 + n));
        }
    }

    private void processReadInts(ModbusPdu modbusPdu, RegistersTable registersTable, String string) {
        int n = modbusPdu.readInt16FromPDU(1, true);
        int n2 = modbusPdu.readInt16FromPDU(3, true);
        this.server.log.debug("Read {}: addr={}, count={}", string, n, n2);
        if (!this.validRange(modbusPdu, n, n2, registersTable, string, 125)) {
            return;
        }
        int n3 = n2 * 2;
        modbusPdu.setPduSize(2 + n3);
        modbusPdu.writeByteToPDU(1, (byte)n3);
        for (int i = 0; i < n2; ++i) {
            modbusPdu.writeInt16ToPDU(2 + i * 2, registersTable.getInt(n + i));
        }
    }

    private void processWriteSingleCoil(ModbusPdu modbusPdu) {
        int n = modbusPdu.readInt16FromPDU(1, true);
        int n2 = modbusPdu.readInt16FromPDU(3, true);
        this.server.log.debug("Write single coil {}, value: {}", (Object)n, (Object)n2);
        if (n2 != 0 & n2 != 65280) {
            this.server.log.warn("Invalid write coil value ({}). Must be 0 or 0xFF00 (65280)", (Object)n2);
            this.setException(modbusPdu, 3);
            return;
        }
        if (!this.server.coils.isValidAddress(n)) {
            this.server.log.warn("Invalid write coil address ({})", (Object)n);
            this.setException(modbusPdu, 2);
            return;
        }
        if (this.server.handler == null || !this.server.handler.OnWriteCoil(this.server, n, n2 > 0)) {
            this.server.log.warn("Writing coil {} failed", (Object)n);
            this.setException(modbusPdu, 4);
            return;
        }
        modbusPdu.setPduSize(5);
    }

    private void processWriteSingleHReg(ModbusPdu modbusPdu) {
        int n = modbusPdu.readInt16FromPDU(1, true);
        int n2 = modbusPdu.readInt16FromPDU(3, false);
        this.server.log.debug("Write single register {}, value: {}", (Object)n, (Object)n2);
        if (!this.server.hregs.isValidAddress(n)) {
            this.server.log.warn("Invalid write reg address ({})", (Object)n);
            this.setException(modbusPdu, 2);
            return;
        }
        if (this.server.handler == null || !this.server.handler.OnWriteHReg(this.server, n, n2)) {
            this.server.log.warn("Writing register {} failed", (Object)n);
            this.setException(modbusPdu, 4);
            return;
        }
        modbusPdu.setPduSize(5);
    }

    private void processWriteCoils(ModbusPdu modbusPdu) {
        int n = modbusPdu.readInt16FromPDU(1, true);
        int n2 = modbusPdu.readInt16FromPDU(3, true);
        int n3 = modbusPdu.readByteFromPDU(5, true);
        this.server.log.debug("Write multiple coils: addr={}, count={}", (Object)n, (Object)n2);
        if (!this.validPduSize(modbusPdu, 6 + n3)) {
            return;
        }
        if (!this.validRange(modbusPdu, n, n2, this.server.coils, "coils", 1968)) {
            return;
        }
        int n4 = ModbusPdu.bytesCount(n2);
        if (n3 != n4) {
            this.server.log.warn("Write byte count (N={}) doesn't match coils count ({}). N must be {}", n3, n2, n4);
            this.setException(modbusPdu, 3);
            return;
        }
        boolean bl = this.server.handler == null;
        for (int i = 0; !bl && i < n2; ++i) {
            bl = !this.server.handler.OnWriteCoil(this.server, n + i, modbusPdu.readBitFromPDU(6, i));
        }
        if (bl) {
            this.server.log.warn("Writing coils at {}, count {} failed", (Object)n, (Object)n2);
            this.setException(modbusPdu, 4);
            return;
        }
        modbusPdu.setPduSize(5);
    }

    private void processWriteHRegs(ModbusPdu modbusPdu) {
        int n = modbusPdu.readInt16FromPDU(1, true);
        int n2 = modbusPdu.readInt16FromPDU(3, true);
        int n3 = modbusPdu.readByteFromPDU(5, true);
        this.server.log.debug("Write multiple reg-s: addr={}, count={}", (Object)n, (Object)n2);
        if (!this.validPduSize(modbusPdu, 6 + n3)) {
            return;
        }
        if (!this.validRange(modbusPdu, n, n2, this.server.hregs, "holding reg-s", 123)) {
            return;
        }
        if (n3 != 2 * n2) {
            this.server.log.warn("Write byte count (N={}) doesn't match reg-s count ({}). N must be {}", n3, n2, 2 * n2);
            this.setException(modbusPdu, 3);
            return;
        }
        boolean bl = this.server.handler == null;
        for (int i = 0; !bl && i < n2; ++i) {
            bl = !this.server.handler.OnWriteHReg(this.server, n + i, modbusPdu.readInt16FromPDU(6 + i * 2, false));
        }
        if (bl) {
            this.server.log.warn("Writing reg-s at {}, count {} failed", (Object)n, (Object)n2);
            this.setException(modbusPdu, 4);
            return;
        }
        modbusPdu.setPduSize(5);
    }

    @Override
    public boolean processRequest(ModbusPdu modbusPdu) {
        if (modbusPdu.getPduSize() < 5) {
            this.server.log.error("Invalid PDU size ({} < 5)", (Object)modbusPdu.getPduSize());
            return false;
        }
        int n = modbusPdu.getFunction();
        if (n == 1) {
            this.processReadBits(modbusPdu, this.server.coils, "coils");
        } else if (n == 2) {
            this.processReadBits(modbusPdu, this.server.inputs, "inputs");
        } else if (n == 3) {
            this.processReadInts(modbusPdu, this.server.hregs, "holding reg-s");
        } else if (n == 4) {
            this.processReadInts(modbusPdu, this.server.iregs, "input reg-s");
        } else if (n == 5) {
            this.processWriteSingleCoil(modbusPdu);
        } else if (n == 6) {
            this.processWriteSingleHReg(modbusPdu);
        } else if (n == 15) {
            this.processWriteCoils(modbusPdu);
        } else if (n == 16) {
            this.processWriteHRegs(modbusPdu);
        } else {
            this.server.log.error("Unknown function: {}", (Object)n);
            this.setException(modbusPdu, 1);
        }
        return true;
    }
}

