/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.client;

import certa.modbus.ModbusPdu;
import certa.modbus.client.AbstractRtuTransport;
import certa.modbus.client.ModbusClient;
import com.fazecast.jSerialComm.SerialPort;
import org.slf4j.LoggerFactory;

public class RtuTransportJSerialComm
extends AbstractRtuTransport {
    private final int baudRate;
    private final int dataBits;
    private final int parity;
    private final int stopBits;
    private final SerialPort port;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;

    public RtuTransportJSerialComm(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n5, n6, true, LoggerFactory.getLogger(RtuTransportJSerialComm.class));
        this.port = SerialPort.getCommPort(string);
        this.baudRate = n;
        this.dataBits = n2;
        this.parity = n3;
        this.stopBits = n4 == 1 ? 1 : 3;
    }

    public static String parityStr(int n) {
        return n == 0 ? "N" : (n == 1 ? "O" : (n == 2 ? "E" : "?"));
    }

    @Override
    protected synchronized boolean openPort() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (this.port == null) {
            return false;
        }
        if (!this.port.isOpen()) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Opening port: {}, {}, {}-{}-{}", this.port.getSystemPortName(), this.baudRate, this.dataBits, RtuTransportJSerialComm.parityStr(this.parity), this.stopBits);
            }
            try {
                if (!this.port.openPort()) {
                    this.log.error("openPort() failed");
                    this.close();
                    Thread.sleep(1000L);
                    return false;
                }
                if (!this.port.setComPortTimeouts(272, this.timeout, this.timeout)) {
                    this.log.error("setComPortTimeouts() failed");
                    this.close();
                    return false;
                }
                if (!this.port.setComPortParameters(this.baudRate, this.dataBits, this.stopBits, this.parity, false)) {
                    this.log.error("setComPortParameters() failed");
                    this.close();
                    return false;
                }
            }
            catch (Exception exception) {
                this.close();
                this.log.error("Error opening port {}: {}", (Object)this.port.getSystemPortName(), (Object)exception);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Port opened: {}", (Object)this.port.getSystemPortName());
            }
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.port != null && this.port.isOpen()) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Closing port: {}", (Object)this.port.getSystemPortName());
            }
            try {
                this.port.closePort();
            }
            catch (Exception exception) {
                this.log.error("Error closing port {}: {}", (Object)this.port.getSystemPortName(), (Object)exception);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Port {} closed", (Object)this.port.getSystemPortName());
            }
        }
    }

    @Override
    protected void clearInput() {
        int n = this.port.bytesAvailable();
        while (n > 0) {
            int n2 = this.port.readBytes(this.buffer, Math.max(n, this.buffer.length));
            if (n2 < 0) {
                this.log.warn("readBytes() failed in clearInput()");
                return;
            }
            if (n2 > 0 && this.log.isWarnEnabled()) {
                this.log.warn("Unexpected input: " + ModbusPdu.toHex(this.buffer, 0, n2));
            }
            n = this.port.bytesAvailable();
        }
    }

    @Override
    protected void sendData(int n) {
        int n2 = this.port.writeBytes(this.buffer, n, 0L);
        if (n2 != n) {
            this.log.warn("sendData() failed. {} from {} bytes written", (Object)n2, (Object)n);
        }
    }

    @Override
    protected boolean readToBuffer(int n, int n2, ModbusClient modbusClient) throws InterruptedException {
        int n3 = this.port.readBytes(this.buffer, n2, n);
        if (n3 < n2) {
            if (n3 > 0 && this.log.isTraceEnabled()) {
                this.log.trace("Read (incomplete): " + ModbusPdu.toHex(this.buffer, 0, n + n3));
            }
            this.log.warn("Response from {} timeout ({} bytes, need {})", modbusClient.getServerId(), n + n3, this.expectedBytes);
            return false;
        }
        return true;
    }
}

