/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.client;

import certa.modbus.ModbusPdu;
import certa.modbus.client.ModbusClient;
import certa.modbus.client.ModbusClientTransport;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtuOverMqttTransport
implements ModbusClientTransport,
MqttCallbackExtended {
    static final int PAUSE = 100;
    static final int TIMEOUT = 5000;
    static final int QOS = 0;
    final Logger log = LoggerFactory.getLogger(RtuOverMqttTransport.class);
    private volatile byte[] inputData = null;
    private final String brokerURI;
    private final String clientId;
    private final String login;
    private final String password;
    private final String requestTopic;
    private final String responseTopic;
    private MqttClient mqttClient = null;
    private final MemoryPersistence persistence = new MemoryPersistence();

    public RtuOverMqttTransport(String string, int n, String string2, String string3, String string4, String string5) {
        this.brokerURI = "tcp://" + string + ":" + n;
        this.clientId = string2;
        this.login = string3;
        this.password = string4;
        this.requestTopic = string5 + "/sys/bridge_uart/request";
        this.responseTopic = string5 + "/sys/bridge_uart/response";
    }

    private void openConnection() throws Exception {
        if (this.mqttClient == null) {
            this.mqttClient = new MqttClient(this.brokerURI, this.clientId, this.persistence);
            MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
            mqttConnectOptions.setCleanSession(true);
            mqttConnectOptions.setAutomaticReconnect(true);
            mqttConnectOptions.setUserName(this.login);
            mqttConnectOptions.setPassword(this.password.toCharArray());
            this.log.debug("Connecting to broker: {}", (Object)this.brokerURI);
            this.mqttClient.setCallback(this);
            this.mqttClient.connect(mqttConnectOptions);
            this.log.debug("Subscribing topic {}", (Object)this.responseTopic);
            this.mqttClient.subscribe(this.responseTopic);
        }
    }

    @Override
    public void sendRequest(ModbusClient modbusClient) throws Exception, InterruptedException {
        Thread.sleep(100L);
        this.openConnection();
        int n = modbusClient.getPduSize() + 3;
        byte[] byArray = new byte[n];
        byArray[0] = modbusClient.getServerId();
        modbusClient.readFromPdu(0, modbusClient.getPduSize(), byArray, 1);
        int n2 = ModbusPdu.calcCRC16(byArray, 0, n - 2);
        byArray[n - 2] = ModbusPdu.lowByte(n2);
        byArray[n - 1] = ModbusPdu.highByte(n2);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Write: " + ModbusPdu.toHex(byArray, 0, n));
        }
        this.mqttClient.publish(this.requestTopic, byArray, 0, false);
    }

    protected boolean crcValid(byte[] byArray, int n) {
        int n2;
        int n3 = ModbusPdu.calcCRC16(byArray, 0, n);
        if (n3 == (n2 = ModbusPdu.bytesToInt16(byArray[n], byArray[n + 1], true))) {
            return true;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn("CRC error (calc: {}, in response: {})", (Object)Integer.toHexString(n3), (Object)Integer.toHexString(n2));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitResponse(ModbusClient modbusClient) throws Exception {
        if (this.mqttClient == null) {
            return 1;
        }
        long l = System.currentTimeMillis() + 5000L;
        byte[] byArray = null;
        do {
            RtuOverMqttTransport rtuOverMqttTransport = this;
            synchronized (rtuOverMqttTransport) {
                byArray = this.inputData;
                this.inputData = null;
            }
        } while (byArray == null && System.currentTimeMillis() < l);
        if (byArray == null) {
            return 1;
        }
        int n = modbusClient.getExpectedPduSize() + 3;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Read (size={}): {}", (Object)byArray.length, (Object)ModbusPdu.toHex(byArray, 0, byArray.length));
        }
        if (byArray.length < 5) {
            return 1;
        }
        if (byArray[0] != modbusClient.getServerId()) {
            this.log.warn("waitResponse(): Invalid id: {} (expected: {})", (Object)byArray[0], (Object)modbusClient.getServerId());
            return 3;
        }
        if ((byArray[1] & 0x7F) != modbusClient.getFunction()) {
            this.log.warn("waitResponse(): Invalid function: {} (expected: {})", (Object)byArray[1], (Object)modbusClient.getFunction());
            return 3;
        }
        if ((byArray[1] & 0x80) != 0) {
            n = 5;
            if (this.crcValid(byArray, 3)) {
                this.log.warn("waitResponse(): Modbus exception: {}", (Object)byArray[2]);
                modbusClient.setPduSize(2);
                modbusClient.writeToPdu(byArray, 1, modbusClient.getPduSize(), 0);
                return 2;
            }
            return 3;
        }
        if (byArray.length < n) {
            this.log.warn("waitResponse(): Not enough data (expected: {})", (Object)n);
            return 1;
        }
        if (this.crcValid(byArray, 1 + modbusClient.getExpectedPduSize())) {
            modbusClient.setPduSize(modbusClient.getExpectedPduSize());
            modbusClient.writeToPdu(byArray, 1, modbusClient.getPduSize(), 0);
            return 0;
        }
        return 3;
    }

    @Override
    public void close() {
        if (this.mqttClient != null) {
            try {
                this.mqttClient.disconnect(10000L);
            }
            catch (MqttException mqttException) {
                this.log.error("disconnect() error", mqttException);
            }
            try {
                this.mqttClient.close();
            }
            catch (MqttException mqttException) {
                this.log.error("close() error", mqttException);
            }
            this.mqttClient = null;
        }
    }

    @Override
    public void connectionLost(Throwable throwable) {
        this.log.error("connectionLost", throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
        if (string.equals(this.responseTopic)) {
            RtuOverMqttTransport rtuOverMqttTransport = this;
            synchronized (rtuOverMqttTransport) {
                this.inputData = mqttMessage.getPayload();
            }
        }
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    @Override
    public void connectComplete(boolean bl, String string) {
    }
}

