/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.client;

import certa.modbus.ModbusPdu;
import certa.modbus.client.ModbusClient;
import certa.modbus.client.ModbusClientTransport;
import org.slf4j.Logger;

public abstract class AbstractTcpTransport
implements ModbusClientTransport {
    protected final Logger log;
    protected final int timeout;
    protected final int pause;
    protected final boolean keepConnection;
    protected int transactionId = 0;
    protected final byte[] buffer = new byte[260];
    protected int expectedBytes;

    public AbstractTcpTransport(int n, int n2, boolean bl, Logger logger) {
        this.log = logger;
        this.timeout = n;
        this.pause = n2;
        this.keepConnection = bl;
    }

    protected abstract void openPort() throws Exception;

    protected abstract void clearInput() throws Exception;

    protected abstract void sendData(int var1) throws Exception;

    protected abstract boolean readToBuffer(int var1, int var2, ModbusClient var3) throws Exception;

    @Override
    public void sendRequest(ModbusClient modbusClient) throws Exception {
        if (this.pause > 0) {
            Thread.sleep(this.pause);
        }
        this.openPort();
        this.clearInput();
        ++this.transactionId;
        if (this.transactionId > 65535) {
            this.transactionId = 1;
        }
        this.buffer[0] = ModbusPdu.highByte(this.transactionId);
        this.buffer[1] = ModbusPdu.lowByte(this.transactionId);
        this.buffer[2] = 0;
        this.buffer[3] = 0;
        int n = modbusClient.getPduSize() + 1;
        this.buffer[4] = ModbusPdu.highByte(n);
        this.buffer[5] = ModbusPdu.lowByte(n);
        this.buffer[6] = modbusClient.getServerId();
        modbusClient.readFromPdu(0, modbusClient.getPduSize(), this.buffer, 7);
        n = modbusClient.getPduSize() + 7;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Write: " + ModbusPdu.toHex(this.buffer, 0, n));
        }
        this.sendData(n);
    }

    protected void logData(String string, int n, int n2) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Read ({}): {}", (Object)string, (Object)ModbusPdu.toHex(this.buffer, n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitResponse(ModbusClient modbusClient) throws Exception {
        this.openPort();
        boolean bl = !this.keepConnection;
        try {
            this.expectedBytes = modbusClient.getExpectedPduSize() + 7;
            if (!this.readToBuffer(0, 8, modbusClient)) {
                int n = 1;
                return n;
            }
            int n = ModbusPdu.bytesToInt16(this.buffer[1], this.buffer[0], true);
            if (n != this.transactionId) {
                this.logData("bad transaction", 0, 8);
                this.log.warn("waitResponse(): Invalid transaction id: {} (expected: {})", (Object)n, (Object)this.transactionId);
                bl = true;
                int n2 = 3;
                return n2;
            }
            if (this.buffer[6] != modbusClient.getServerId()) {
                this.logData("bad id", 0, 8);
                this.log.warn("waitResponse(): Invalid server id: {} (expected: {})", (Object)this.buffer[6], (Object)modbusClient.getServerId());
                int n3 = 3;
                return n3;
            }
            if ((this.buffer[7] & 0x7F) != modbusClient.getFunction()) {
                this.logData("bad function", 0, 8);
                this.log.warn("waitResponse(): Invalid function: {} (expected: {})", (Object)this.buffer[7], (Object)modbusClient.getFunction());
                int n4 = 3;
                return n4;
            }
            if ((this.buffer[7] & 0x80) != 0) {
                this.expectedBytes = 9;
                if (!this.readToBuffer(8, 1, modbusClient)) {
                    int n5 = 1;
                    return n5;
                }
                this.logData("exception", 0, this.expectedBytes);
                modbusClient.setPduSize(2);
                modbusClient.writeToPdu(this.buffer, 7, 2, 0);
                int n6 = 2;
                return n6;
            }
            int n7 = modbusClient.getExpectedPduSize();
            if (!this.readToBuffer(8, n7 - 1, modbusClient)) {
                int n8 = 1;
                return n8;
            }
            this.logData("normal", 0, this.expectedBytes);
            modbusClient.setPduSize(n7);
            modbusClient.writeToPdu(this.buffer, 7, n7, 0);
            int n9 = 0;
            return n9;
        }
        finally {
            if (bl) {
                this.close();
            }
        }
    }
}

