/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.client;

import certa.modbus.ModbusPdu;
import certa.modbus.client.ModbusClient;
import certa.modbus.client.ModbusClientTransport;
import org.slf4j.Logger;

public abstract class AbstractRtuTransport
implements ModbusClientTransport {
    protected final Logger log;
    protected final int timeout;
    protected final int pause;
    protected final boolean keepConnection;
    protected final byte[] buffer = new byte[256];
    protected int expectedBytes;

    public AbstractRtuTransport(int n, int n2, boolean bl, Logger logger) {
        this.log = logger;
        this.timeout = n;
        this.pause = n2;
        this.keepConnection = bl;
    }

    protected abstract boolean openPort() throws Exception;

    protected abstract void clearInput() throws Exception;

    protected abstract void sendData(int var1) throws Exception;

    protected abstract boolean readToBuffer(int var1, int var2, ModbusClient var3) throws Exception;

    @Override
    public void sendRequest(ModbusClient modbusClient) throws Exception {
        if (this.pause > 0) {
            Thread.sleep(this.pause);
        }
        if (!this.openPort()) {
            return;
        }
        this.clearInput();
        this.buffer[0] = modbusClient.getServerId();
        modbusClient.readFromPdu(0, modbusClient.getPduSize(), this.buffer, 1);
        int n = modbusClient.getPduSize() + 1;
        int n2 = ModbusPdu.calcCRC16(this.buffer, 0, n);
        this.buffer[n] = ModbusPdu.lowByte(n2);
        this.buffer[n + 1] = ModbusPdu.highByte(n2);
        n += 2;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Write: " + ModbusPdu.toHex(this.buffer, 0, n));
        }
        this.sendData(n);
    }

    protected void logData(String string, int n, int n2) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Read ({}): {}", (Object)string, (Object)ModbusPdu.toHex(this.buffer, n, n2));
        }
    }

    protected boolean crcValid(int n) {
        int n2;
        int n3 = ModbusPdu.calcCRC16(this.buffer, 0, n);
        if (n3 == (n2 = ModbusPdu.bytesToInt16(this.buffer[n], this.buffer[n + 1], true))) {
            return true;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn("CRC error (calc: {}, in response: {})", (Object)Integer.toHexString(n3), (Object)Integer.toHexString(n2));
        }
        return false;
    }

    @Override
    public int waitResponse(ModbusClient modbusClient) throws Exception {
        if (!this.openPort()) {
            return 1;
        }
        try {
            this.expectedBytes = modbusClient.getExpectedPduSize() + 3;
            if (!this.readToBuffer(0, 1, modbusClient)) {
                int n = 1;
                return n;
            }
            if (this.buffer[0] != modbusClient.getServerId()) {
                this.logData("bad id", 0, 1);
                this.log.warn("waitResponse(): Invalid id: {} (expected: {})", (Object)this.buffer[0], (Object)modbusClient.getServerId());
                int n = 3;
                return n;
            }
            if (!this.readToBuffer(1, 1, modbusClient)) {
                int n = 1;
                return n;
            }
            if ((this.buffer[1] & 0x7F) != modbusClient.getFunction()) {
                this.logData("bad function", 0, 2);
                this.log.warn("waitResponse(): Invalid function: {} (expected: {})", (Object)this.buffer[1], (Object)modbusClient.getFunction());
                int n = 3;
                return n;
            }
            if ((this.buffer[1] & 0x80) != 0) {
                this.expectedBytes = 5;
                if (!this.readToBuffer(2, 3, modbusClient)) {
                    int n = 1;
                    return n;
                }
                if (this.crcValid(3)) {
                    this.logData("exception", 0, this.expectedBytes);
                    modbusClient.setPduSize(2);
                    modbusClient.writeToPdu(this.buffer, 1, modbusClient.getPduSize(), 0);
                    int n = 2;
                    return n;
                }
                this.logData("bad crc (exception)", 0, this.expectedBytes);
                int n = 3;
                return n;
            }
            if (!this.readToBuffer(2, modbusClient.getExpectedPduSize() + 1, modbusClient)) {
                int n = 1;
                return n;
            }
            if (this.crcValid(1 + modbusClient.getExpectedPduSize())) {
                this.logData("normal", 0, this.expectedBytes);
                modbusClient.setPduSize(modbusClient.getExpectedPduSize());
                modbusClient.writeToPdu(this.buffer, 1, modbusClient.getPduSize(), 0);
                int n = 0;
                return n;
            }
            this.logData("bad crc", 0, this.expectedBytes);
            int n = 3;
            return n;
        }
        finally {
            if (!this.keepConnection) {
                this.close();
            }
        }
    }
}

