/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;

public class MemoryPersistence
implements MqttClientPersistence {
    private Hashtable<String, MqttPersistable> data;

    @Override
    public void close() throws MqttPersistenceException {
        if (this.data != null) {
            this.data.clear();
        }
    }

    @Override
    public Enumeration<String> keys() throws MqttPersistenceException {
        this.checkIsOpen();
        return this.data.keys();
    }

    @Override
    public MqttPersistable get(String string) throws MqttPersistenceException {
        this.checkIsOpen();
        return this.data.get(string);
    }

    @Override
    public void open(String string, String string2) throws MqttPersistenceException {
        this.data = new Hashtable();
    }

    @Override
    public void put(String string, MqttPersistable mqttPersistable) throws MqttPersistenceException {
        this.checkIsOpen();
        this.data.put(string, mqttPersistable);
    }

    @Override
    public void remove(String string) throws MqttPersistenceException {
        this.checkIsOpen();
        this.data.remove(string);
    }

    @Override
    public void clear() throws MqttPersistenceException {
        this.checkIsOpen();
        this.data.clear();
    }

    @Override
    public boolean containsKey(String string) throws MqttPersistenceException {
        this.checkIsOpen();
        return this.data.containsKey(string);
    }

    private void checkIsOpen() throws MqttPersistenceException {
        if (this.data == null) {
            throw new MqttPersistenceException();
        }
    }
}

