/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SimpleLogFormatter
extends Formatter {
    private static final String LS = System.getProperty("line.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord logRecord) {
        Appendable appendable;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(logRecord.getLevel().getName()).append("\t");
        stringBuffer.append(MessageFormat.format("{0, date, yy-MM-dd} {0, time, kk:mm:ss.SSSS} ", new Date(logRecord.getMillis())) + "\t");
        String string = logRecord.getSourceClassName();
        String string2 = "";
        if (string != null) {
            int n = string.length();
            if (n > 20) {
                string2 = logRecord.getSourceClassName().substring(n - 19);
            } else {
                object = new char[]{' '};
                appendable = new StringBuffer().append(string);
                string2 = ((StringBuffer)appendable).append((char[])object, 0, 1).toString();
            }
        }
        stringBuffer.append(string2).append("\t").append(" ");
        stringBuffer.append(SimpleLogFormatter.left(logRecord.getSourceMethodName(), 23, ' ')).append("\t");
        stringBuffer.append(logRecord.getThreadID()).append("\t");
        stringBuffer.append(this.formatMessage(logRecord)).append(LS);
        if (null != logRecord.getThrown()) {
            stringBuffer.append("Throwable occurred: ");
            Throwable throwable = logRecord.getThrown();
            object = null;
            try {
                appendable = new StringWriter();
                object = new PrintWriter((Writer)appendable);
                throwable.printStackTrace((PrintWriter)object);
                stringBuffer.append(((StringWriter)appendable).toString());
            }
            finally {
                if (object != null) {
                    try {
                        ((PrintWriter)object).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String left(String string, int n, char c) {
        if (string.length() >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        int n2 = n - string.length();
        while (--n2 >= 0) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

