/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.logging;

import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.paho.client.mqttv3.logging.JSR47Logger;
import org.eclipse.paho.client.mqttv3.logging.Logger;

public class LoggerFactory {
    public static final String MQTT_CLIENT_MSG_CAT = "org.eclipse.paho.client.mqttv3.internal.nls.logcat";
    private static final String CLASS_NAME = LoggerFactory.class.getName();
    private static String overrideloggerClassName = null;
    private static String jsr47LoggerClassName = JSR47Logger.class.getName();

    public static Logger getLogger(String string, String string2) {
        String string3 = overrideloggerClassName;
        Logger logger = null;
        if (string3 == null) {
            string3 = jsr47LoggerClassName;
        }
        if (null == (logger = LoggerFactory.getLogger(string3, ResourceBundle.getBundle(string), string2, null))) {
            throw new MissingResourceException("Error locating the logging class", CLASS_NAME, string2);
        }
        return logger;
    }

    private static Logger getLogger(String string, ResourceBundle resourceBundle, String string2, String string3) {
        Logger logger = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        if (null != clazz) {
            try {
                logger = (Logger)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                return null;
            }
            catch (SecurityException securityException) {
                return null;
            }
            logger.initialise(resourceBundle, string2, string3);
        }
        return logger;
    }

    public static String getLoggingProperty(String string) {
        String string2 = null;
        try {
            Class<?> clazz = Class.forName("java.util.logging.LogManager");
            Method method = clazz.getMethod("getLogManager", new Class[0]);
            Object object = method.invoke(null, null);
            Method method2 = clazz.getMethod("getProperty", String.class);
            string2 = (String)method2.invoke(object, string);
        }
        catch (Exception exception) {
            string2 = null;
        }
        return string2;
    }

    public static void setLogger(String string) {
        overrideloggerClassName = string;
    }
}

