/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class MqttUnsubscribe
extends MqttWireMessage {
    private String[] names;
    private int count;

    public MqttUnsubscribe(String[] stringArray) {
        super((byte)10);
        if (stringArray != null) {
            this.names = (String[])stringArray.clone();
        }
    }

    public MqttUnsubscribe(byte by, byte[] byArray) throws IOException {
        super((byte)10);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.msgId = dataInputStream.readUnsignedShort();
        this.count = 0;
        this.names = new String[10];
        boolean bl = false;
        while (!bl) {
            try {
                this.names[this.count] = MqttUnsubscribe.decodeUTF8(dataInputStream);
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        dataInputStream.close();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" names:[");
        for (int i = 0; i < this.count; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("\"" + this.names[i] + "\"");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    protected byte getMessageInfo() {
        return (byte)(2 | (this.duplicate ? 8 : 0));
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeShort(this.msgId);
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MqttException(iOException);
        }
    }

    @Override
    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (String string : this.names) {
                MqttUnsubscribe.encodeUTF8(dataOutputStream, string);
            }
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MqttException(iOException);
        }
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

