/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;

public class MqttSuback
extends MqttAck {
    private int[] grantedQos;

    public MqttSuback(byte by, byte[] byArray) throws IOException {
        super((byte)9);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.msgId = dataInputStream.readUnsignedShort();
        int n = 0;
        this.grantedQos = new int[byArray.length - 2];
        int n2 = dataInputStream.read();
        while (n2 != -1) {
            this.grantedQos[n] = n2;
            ++n;
            n2 = dataInputStream.read();
        }
        dataInputStream.close();
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        return new byte[0];
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append(" granted Qos");
        for (int n : this.grantedQos) {
            stringBuffer.append(" ").append(n);
        }
        return stringBuffer.toString();
    }

    public int[] getGrantedQos() {
        return this.grantedQos;
    }
}

