/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.CountingInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPersistableWireMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttReceivedMessage;

public class MqttPublish
extends MqttPersistableWireMessage {
    private MqttMessage message;
    private String topicName;
    private byte[] encodedPayload = null;

    public MqttPublish(String string, MqttMessage mqttMessage) {
        super((byte)3);
        this.topicName = string;
        this.message = mqttMessage;
    }

    public MqttPublish(byte by, byte[] byArray) throws MqttException, IOException {
        super((byte)3);
        this.message = new MqttReceivedMessage();
        this.message.setQos(by >> 1 & 3);
        if ((by & 1) == 1) {
            this.message.setRetained(true);
        }
        if ((by & 8) == 8) {
            ((MqttReceivedMessage)this.message).setDuplicate(true);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CountingInputStream countingInputStream = new CountingInputStream(byteArrayInputStream);
        DataInputStream dataInputStream = new DataInputStream(countingInputStream);
        this.topicName = MqttPublish.decodeUTF8(dataInputStream);
        if (this.message.getQos() > 0) {
            this.msgId = dataInputStream.readUnsignedShort();
        }
        byte[] byArray2 = new byte[byArray.length - countingInputStream.getCounter()];
        dataInputStream.readFully(byArray2);
        dataInputStream.close();
        this.message.setPayload(byArray2);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.message.getPayload();
        int n = Math.min(byArray.length, 20);
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            String string = Integer.toHexString(by);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuffer.append(string);
        }
        String string = null;
        try {
            string = new String(byArray, 0, n, "UTF-8");
        }
        catch (Exception exception) {
            string = "?";
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(super.toString());
        stringBuffer2.append(" qos:").append(this.message.getQos());
        if (this.message.getQos() > 0) {
            stringBuffer2.append(" msgId:").append(this.msgId);
        }
        stringBuffer2.append(" retained:").append(this.message.isRetained());
        stringBuffer2.append(" dup:").append(this.duplicate);
        stringBuffer2.append(" topic:\"").append(this.topicName).append("\"");
        stringBuffer2.append(" payload:[hex:").append(stringBuffer);
        stringBuffer2.append(" utf8:\"").append(string).append("\"");
        stringBuffer2.append(" length:").append(byArray.length).append("]");
        return stringBuffer2.toString();
    }

    @Override
    protected byte getMessageInfo() {
        byte by = (byte)(this.message.getQos() << 1);
        if (this.message.isRetained()) {
            by = (byte)(by | 1);
        }
        if (this.message.isDuplicate() || this.duplicate) {
            by = (byte)(by | 8);
        }
        return by;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public MqttMessage getMessage() {
        return this.message;
    }

    protected static byte[] encodePayload(MqttMessage mqttMessage) {
        return mqttMessage.getPayload();
    }

    @Override
    public byte[] getPayload() throws MqttException {
        if (this.encodedPayload == null) {
            this.encodedPayload = MqttPublish.encodePayload(this.message);
        }
        return this.encodedPayload;
    }

    @Override
    public int getPayloadLength() {
        int n = 0;
        try {
            n = this.getPayload().length;
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public void setMessageId(int n) {
        super.setMessageId(n);
        if (this.message instanceof MqttReceivedMessage) {
            ((MqttReceivedMessage)this.message).setMessageId(n);
        }
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            MqttPublish.encodeUTF8(dataOutputStream, this.topicName);
            if (this.message.getQos() > 0) {
                dataOutputStream.writeShort(this.msgId);
            }
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MqttException(iOException);
        }
    }

    @Override
    public boolean isMessageIdRequired() {
        return true;
    }
}

