/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.SocketTimeoutException;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketFrame;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class WebSocketReceiver
implements Runnable {
    private static final String CLASS_NAME = WebSocketReceiver.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private boolean running = false;
    private boolean stopping = false;
    private final Object lifecycle = new Object();
    private InputStream input;
    private Thread receiverThread = null;
    private volatile boolean receiving;
    private PipedOutputStream pipedOutputStream;

    public WebSocketReceiver(InputStream inputStream, PipedInputStream pipedInputStream) throws IOException {
        this.input = inputStream;
        this.pipedOutputStream = new PipedOutputStream();
        pipedInputStream.connect(this.pipedOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String string) {
        this.log.fine(CLASS_NAME, "start", "855");
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.receiverThread = new Thread((Runnable)this, string);
                this.receiverThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopping = true;
        boolean bl = false;
        Object object = this.lifecycle;
        synchronized (object) {
            this.log.fine(CLASS_NAME, "stop", "850");
            if (this.running) {
                this.running = false;
                this.receiving = false;
                bl = true;
                this.closeOutputStream();
            }
        }
        if (bl && !Thread.currentThread().equals(this.receiverThread) && this.receiverThread != null) {
            try {
                this.receiverThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.receiverThread = null;
        this.log.fine(CLASS_NAME, "stop", "851");
    }

    @Override
    public void run() {
        while (this.running && this.input != null) {
            try {
                this.log.fine(CLASS_NAME, "run", "852");
                this.receiving = this.input.available() > 0;
                WebSocketFrame webSocketFrame = new WebSocketFrame(this.input);
                if (!webSocketFrame.isCloseFlag()) {
                    for (int i = 0; i < webSocketFrame.getPayload().length; ++i) {
                        this.pipedOutputStream.write(webSocketFrame.getPayload()[i]);
                    }
                    this.pipedOutputStream.flush();
                } else if (!this.stopping) {
                    throw new IOException("Server sent a WebSocket Frame with the Stop OpCode");
                }
                this.receiving = false;
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException iOException) {
                this.stop();
            }
        }
    }

    private void closeOutputStream() {
        try {
            this.pipedOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isReceiving() {
        return this.receiving;
    }
}

