/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.websocket;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketNetworkModule;
import org.eclipse.paho.client.mqttv3.spi.NetworkModuleFactory;

public class WebSocketNetworkModuleFactory
implements NetworkModuleFactory {
    @Override
    public Set<String> getSupportedUriSchemes() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ws")));
    }

    @Override
    public void validateURI(URI uRI) throws IllegalArgumentException {
    }

    @Override
    public NetworkModule createNetworkModule(URI uRI, MqttConnectOptions mqttConnectOptions, String string) throws MqttException {
        SocketFactory socketFactory;
        String string2 = uRI.getHost();
        int n = uRI.getPort();
        if (n == -1) {
            n = 80;
        }
        if ((socketFactory = mqttConnectOptions.getSocketFactory()) == null) {
            socketFactory = SocketFactory.getDefault();
        } else if (socketFactory instanceof SSLSocketFactory) {
            throw ExceptionHelper.createMqttException(32105);
        }
        WebSocketNetworkModule webSocketNetworkModule = new WebSocketNetworkModule(socketFactory, uRI.toString(), string2, n, string, mqttConnectOptions.getCustomWebSocketHeaders());
        webSocketNetworkModule.setConnectTimeout(mqttConnectOptions.getConnectionTimeout());
        return webSocketNetworkModule;
    }
}

