/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.websocket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.paho.client.mqttv3.internal.websocket.Base64;
import org.eclipse.paho.client.mqttv3.internal.websocket.HandshakeFailedException;

public class WebSocketHandshake {
    private static final String ACCEPT_SALT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final String SHA1_PROTOCOL = "SHA1";
    private static final String HTTP_HEADER_SEC_WEBSOCKET_ACCEPT = "sec-websocket-accept";
    private static final String HTTP_HEADER_UPGRADE = "upgrade";
    private static final String HTTP_HEADER_UPGRADE_WEBSOCKET = "websocket";
    private static final String EMPTY = "";
    private static final String LINE_SEPARATOR = "\r\n";
    private static final String HTTP_HEADER_CONNECTION = "connection";
    private static final String HTTP_HEADER_CONNECTION_VALUE = "upgrade";
    private static final String HTTP_HEADER_SEC_WEBSOCKET_PROTOCOL = "sec-websocket-protocol";
    InputStream input;
    OutputStream output;
    String uri;
    String host;
    int port;
    Properties customWebSocketHeaders;

    public WebSocketHandshake(InputStream inputStream, OutputStream outputStream, String string, String string2, int n, Properties properties) {
        this.input = inputStream;
        this.output = outputStream;
        this.uri = string;
        this.host = string2;
        this.port = n;
        this.customWebSocketHeaders = properties;
    }

    public void execute() throws IOException {
        byte[] byArray = new byte[16];
        System.arraycopy(UUID.randomUUID().toString().getBytes(), 0, byArray, 0, 16);
        String string = Base64.encodeBytes(byArray);
        this.sendHandshakeRequest(string);
        this.receiveHandshakeResponse(string);
    }

    private void sendHandshakeRequest(String string) throws IOException {
        try {
            Object object;
            String string2 = "/mqtt";
            URI uRI = new URI(this.uri);
            if (uRI.getRawPath() != null && !uRI.getRawPath().isEmpty()) {
                string2 = uRI.getRawPath();
                if (uRI.getRawQuery() != null && !uRI.getRawQuery().isEmpty()) {
                    string2 = string2 + "?" + uRI.getRawQuery();
                }
            }
            PrintWriter printWriter = new PrintWriter(this.output);
            printWriter.print("GET " + string2 + " HTTP/1.1" + LINE_SEPARATOR);
            if (this.port != 80) {
                printWriter.print("Host: " + this.host + ":" + this.port + LINE_SEPARATOR);
            } else {
                printWriter.print("Host: " + this.host + LINE_SEPARATOR);
            }
            printWriter.print("Upgrade: websocket\r\n");
            printWriter.print("Connection: Upgrade\r\n");
            printWriter.print("Sec-WebSocket-Key: " + string + LINE_SEPARATOR);
            printWriter.print("Sec-WebSocket-Protocol: mqtt\r\n");
            printWriter.print("Sec-WebSocket-Version: 13\r\n");
            if (this.customWebSocketHeaders != null) {
                object = this.customWebSocketHeaders.keySet();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    String string4 = this.customWebSocketHeaders.getProperty(string3);
                    printWriter.print(string3 + ": " + string4 + LINE_SEPARATOR);
                }
            }
            if ((object = uRI.getUserInfo()) != null) {
                printWriter.print("Authorization: Basic " + Base64.encode((String)object) + LINE_SEPARATOR);
            }
            printWriter.print(LINE_SEPARATOR);
            printWriter.flush();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException.getMessage());
        }
    }

    private void receiveHandshakeResponse(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.input));
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = bufferedReader.readLine();
        if (string2 == null) {
            throw new IOException("WebSocket Response header: Invalid response from Server, It may not support WebSockets.");
        }
        while (!string2.equals(EMPTY)) {
            arrayList.add(string2);
            string2 = bufferedReader.readLine();
        }
        Map<String, String> map = this.getHeaders(arrayList);
        String string3 = map.get(HTTP_HEADER_CONNECTION);
        if (string3 == null || string3.equalsIgnoreCase("upgrade")) {
            throw new IOException("WebSocket Response header: Incorrect connection header");
        }
        String string4 = map.get("upgrade");
        if (string4 == null || !string4.toLowerCase().contains(HTTP_HEADER_UPGRADE_WEBSOCKET)) {
            throw new IOException("WebSocket Response header: Incorrect upgrade.");
        }
        String string5 = map.get(HTTP_HEADER_SEC_WEBSOCKET_PROTOCOL);
        if (string5 == null) {
            throw new IOException("WebSocket Response header: empty sec-websocket-protocol");
        }
        if (!map.containsKey(HTTP_HEADER_SEC_WEBSOCKET_ACCEPT)) {
            throw new IOException("WebSocket Response header: Missing Sec-WebSocket-Accept");
        }
        try {
            this.verifyWebSocketKey(string, map.get(HTTP_HEADER_SEC_WEBSOCKET_ACCEPT));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException.getMessage());
        }
        catch (HandshakeFailedException handshakeFailedException) {
            throw new IOException("WebSocket Response header: Incorrect Sec-WebSocket-Key");
        }
    }

    private Map<String, String> getHeaders(ArrayList<String> arrayList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 1; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            String[] stringArray = string.split(":");
            hashMap.put(stringArray[0].toLowerCase(), stringArray[1]);
        }
        return hashMap;
    }

    private void verifyWebSocketKey(String string, String string2) throws NoSuchAlgorithmException, HandshakeFailedException {
        byte[] byArray = this.sha1(string + ACCEPT_SALT);
        String string3 = Base64.encodeBytes(byArray).trim();
        if (!string3.equals(string2.trim())) {
            throw new HandshakeFailedException();
        }
    }

    private byte[] sha1(String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(SHA1_PROTOCOL);
        byte[] byArray = messageDigest.digest(string.getBytes());
        return byArray;
    }
}

