/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketFrame;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketSecureNetworkModule;

class ExtendedByteArrayOutputStream
extends ByteArrayOutputStream {
    final WebSocketNetworkModule webSocketNetworkModule;
    final WebSocketSecureNetworkModule webSocketSecureNetworkModule;

    ExtendedByteArrayOutputStream(WebSocketNetworkModule webSocketNetworkModule) {
        this.webSocketNetworkModule = webSocketNetworkModule;
        this.webSocketSecureNetworkModule = null;
    }

    ExtendedByteArrayOutputStream(WebSocketSecureNetworkModule webSocketSecureNetworkModule) {
        this.webSocketNetworkModule = null;
        this.webSocketSecureNetworkModule = webSocketSecureNetworkModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        ByteBuffer byteBuffer;
        Object object = this;
        synchronized (object) {
            byteBuffer = ByteBuffer.wrap(this.toByteArray());
            this.reset();
        }
        object = new WebSocketFrame(2, true, byteBuffer.array());
        byte[] byArray = ((WebSocketFrame)object).encodeFrame();
        this.getSocketOutputStream().write(byArray);
        this.getSocketOutputStream().flush();
    }

    OutputStream getSocketOutputStream() throws IOException {
        if (this.webSocketNetworkModule != null) {
            return this.webSocketNetworkModule.getSocketOutputStream();
        }
        if (this.webSocketSecureNetworkModule != null) {
            return this.webSocketSecureNetworkModule.getSocketOutputStream();
        }
        return null;
    }
}

