/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.security;

public class SimpleBase64Encoder {
    private static final String PWDCHARS_STRING = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final char[] PWDCHARS_ARRAY = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    public static String encode(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        StringBuffer stringBuffer = new StringBuffer((n2 + 2) / 3 * 4);
        int n3 = 0;
        for (n = n2; n >= 3; n -= 3) {
            stringBuffer.append(SimpleBase64Encoder.to64((byArray[n3] & 0xFF) << 16 | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3 + 2] & 0xFF, 4));
            n3 += 3;
        }
        if (n == 2) {
            stringBuffer.append(SimpleBase64Encoder.to64((byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF, 3));
        }
        if (n == 1) {
            stringBuffer.append(SimpleBase64Encoder.to64(byArray[n3] & 0xFF, 2));
        }
        return stringBuffer.toString();
    }

    public static byte[] decode(String string) {
        int n;
        long l;
        byte[] byArray = string.getBytes();
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 * 3 / 4];
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        while (n4 >= 4) {
            l = SimpleBase64Encoder.from64(byArray, n3, 4);
            n4 -= 4;
            n3 += 4;
            for (n = 2; n >= 0; --n) {
                byArray2[n5 + n] = (byte)(l & 0xFFL);
                l >>= 8;
            }
            n5 += 3;
        }
        if (n4 == 3) {
            l = SimpleBase64Encoder.from64(byArray, n3, 3);
            for (n = 1; n >= 0; --n) {
                byArray2[n5 + n] = (byte)(l & 0xFFL);
                l >>= 8;
            }
        }
        if (n4 == 2) {
            l = SimpleBase64Encoder.from64(byArray, n3, 2);
            byArray2[n5] = (byte)(l & 0xFFL);
        }
        return byArray2;
    }

    private static final String to64(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        while (n > 0) {
            --n;
            stringBuffer.append(PWDCHARS_ARRAY[(int)(l & 0x3FL)]);
            l >>= 6;
        }
        return stringBuffer.toString();
    }

    private static final long from64(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = 0;
        while (n2 > 0) {
            byte by;
            --n2;
            long l2 = 0L;
            if ((by = byArray[n++]) == 47) {
                l2 = 1L;
            }
            if (by >= 48 && by <= 57) {
                l2 = 2 + by - 48;
            }
            if (by >= 65 && by <= 90) {
                l2 = 12 + by - 65;
            }
            if (by >= 97 && by <= 122) {
                l2 = 38 + by - 97;
            }
            l += l2 << n3;
            n3 += 6;
        }
        return l;
    }
}

