/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.security;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.internal.security.SimpleBase64Encoder;
import org.eclipse.paho.client.mqttv3.logging.Logger;

public class SSLSocketFactoryFactory {
    private static final String CLASS_NAME = "org.eclipse.paho.client.mqttv3.internal.security.SSLSocketFactoryFactory";
    public static final String SSLPROTOCOL = "com.ibm.ssl.protocol";
    public static final String JSSEPROVIDER = "com.ibm.ssl.contextProvider";
    public static final String KEYSTORE = "com.ibm.ssl.keyStore";
    public static final String KEYSTOREPWD = "com.ibm.ssl.keyStorePassword";
    public static final String KEYSTORETYPE = "com.ibm.ssl.keyStoreType";
    public static final String KEYSTOREPROVIDER = "com.ibm.ssl.keyStoreProvider";
    public static final String KEYSTOREMGR = "com.ibm.ssl.keyManager";
    public static final String TRUSTSTORE = "com.ibm.ssl.trustStore";
    public static final String TRUSTSTOREPWD = "com.ibm.ssl.trustStorePassword";
    public static final String TRUSTSTORETYPE = "com.ibm.ssl.trustStoreType";
    public static final String TRUSTSTOREPROVIDER = "com.ibm.ssl.trustStoreProvider";
    public static final String TRUSTSTOREMGR = "com.ibm.ssl.trustManager";
    public static final String CIPHERSUITES = "com.ibm.ssl.enabledCipherSuites";
    public static final String CLIENTAUTH = "com.ibm.ssl.clientAuthentication";
    public static final String SYSKEYSTORE = "javax.net.ssl.keyStore";
    public static final String SYSKEYSTORETYPE = "javax.net.ssl.keyStoreType";
    public static final String SYSKEYSTOREPWD = "javax.net.ssl.keyStorePassword";
    public static final String SYSTRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String SYSTRUSTSTORETYPE = "javax.net.ssl.trustStoreType";
    public static final String SYSTRUSTSTOREPWD = "javax.net.ssl.trustStorePassword";
    public static final String SYSKEYMGRALGO = "ssl.KeyManagerFactory.algorithm";
    public static final String SYSTRUSTMGRALGO = "ssl.TrustManagerFactory.algorithm";
    public static final String DEFAULT_PROTOCOL = "TLS";
    private static final String[] propertyKeys = new String[]{"com.ibm.ssl.protocol", "com.ibm.ssl.contextProvider", "com.ibm.ssl.keyStore", "com.ibm.ssl.keyStorePassword", "com.ibm.ssl.keyStoreType", "com.ibm.ssl.keyStoreProvider", "com.ibm.ssl.keyManager", "com.ibm.ssl.trustStore", "com.ibm.ssl.trustStorePassword", "com.ibm.ssl.trustStoreType", "com.ibm.ssl.trustStoreProvider", "com.ibm.ssl.trustManager", "com.ibm.ssl.enabledCipherSuites", "com.ibm.ssl.clientAuthentication"};
    private Hashtable configs = new Hashtable();
    private Properties defaultProperties;
    private static final byte[] key = new byte[]{-99, -89, -39, -128, 5, -72, -119, -100};
    private static final String xorTag = "{xor}";
    private Logger logger = null;

    public static boolean isSupportedOnJVM() throws LinkageError, ExceptionInInitializerError {
        String string = "javax.net.ssl.SSLServerSocketFactory";
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public SSLSocketFactoryFactory() {
    }

    public SSLSocketFactoryFactory(Logger logger) {
        this();
        this.logger = logger;
    }

    private boolean keyValid(String string) {
        int n;
        for (n = 0; n < propertyKeys.length && !propertyKeys[n].equals(string); ++n) {
        }
        return n < propertyKeys.length;
    }

    private void checkPropertyKeys(Properties properties) throws IllegalArgumentException {
        Set<Object> set = properties.keySet();
        for (String string : set) {
            if (this.keyValid(string)) continue;
            throw new IllegalArgumentException(string + " is not a valid IBM SSL property key.");
        }
    }

    public static char[] toChar(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = new char[byArray.length / 2];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            cArray[n2++] = (char)((byArray[n++] & 0xFF) + ((byArray[n++] & 0xFF) << 8));
        }
        return cArray;
    }

    public static byte[] toByte(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            byArray[n++] = (byte)(cArray[n2] & 0xFF);
            byArray[n++] = (byte)(cArray[n2++] >> 8 & 0xFF);
        }
        return byArray;
    }

    public static String obfuscate(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        byte[] byArray = SSLSocketFactoryFactory.toByte(cArray);
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)((byArray[i] ^ key[i % key.length]) & 0xFF);
        }
        String string = xorTag + new String(SimpleBase64Encoder.encode(byArray));
        return string;
    }

    public static char[] deObfuscate(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = SimpleBase64Encoder.decode(string.substring(xorTag.length()));
        }
        catch (Exception exception) {
            return null;
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)((byArray[i] ^ key[i % key.length]) & 0xFF);
        }
        return SSLSocketFactoryFactory.toChar(byArray);
    }

    public static String packCipherSuites(String[] stringArray) {
        String string = null;
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(',');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String[] unpackCipherSuites(String string) {
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf(44);
        int n2 = 0;
        while (n > -1) {
            vector.add(string.substring(n2, n));
            n2 = n + 1;
            n = string.indexOf(44, n2);
        }
        vector.add(string.substring(n2));
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    private void convertPassword(Properties properties) {
        String string;
        String string2 = properties.getProperty(KEYSTOREPWD);
        if (string2 != null && !string2.startsWith(xorTag)) {
            string = SSLSocketFactoryFactory.obfuscate(string2.toCharArray());
            properties.put(KEYSTOREPWD, string);
        }
        if ((string2 = properties.getProperty(TRUSTSTOREPWD)) != null && !string2.startsWith(xorTag)) {
            string = SSLSocketFactoryFactory.obfuscate(string2.toCharArray());
            properties.put(TRUSTSTOREPWD, string);
        }
    }

    public void initialize(Properties properties, String string) throws IllegalArgumentException {
        this.checkPropertyKeys(properties);
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        this.convertPassword(properties2);
        if (string != null) {
            this.configs.put(string, properties2);
        } else {
            this.defaultProperties = properties2;
        }
    }

    public void merge(Properties properties, String string) throws IllegalArgumentException {
        this.checkPropertyKeys(properties);
        Properties properties2 = this.defaultProperties;
        if (string != null) {
            properties2 = (Properties)this.configs.get(string);
        }
        if (properties2 == null) {
            properties2 = new Properties();
        }
        this.convertPassword(properties);
        properties2.putAll((Map<?, ?>)properties);
        if (string != null) {
            this.configs.put(string, properties2);
        } else {
            this.defaultProperties = properties2;
        }
    }

    public boolean remove(String string) {
        boolean bl = false;
        if (string != null) {
            bl = this.configs.remove(string) != null;
        } else if (null != this.defaultProperties) {
            bl = true;
            this.defaultProperties = null;
        }
        return bl;
    }

    public Properties getConfiguration(String string) {
        return string == null ? this.defaultProperties : this.configs.get(string);
    }

    private String getProperty(String string, String string2, String string3) {
        String string4 = null;
        string4 = this.getPropertyFromConfig(string, string2);
        if (string4 != null) {
            return string4;
        }
        if (string3 != null) {
            string4 = System.getProperty(string3);
        }
        return string4;
    }

    private String getPropertyFromConfig(String string, String string2) {
        String string3 = null;
        Properties properties = null;
        if (string != null) {
            properties = (Properties)this.configs.get(string);
        }
        if (properties != null && (string3 = properties.getProperty(string2)) != null) {
            return string3;
        }
        properties = this.defaultProperties;
        if (properties != null && (string3 = properties.getProperty(string2)) != null) {
            return string3;
        }
        return string3;
    }

    public String getSSLProtocol(String string) {
        return this.getProperty(string, SSLPROTOCOL, null);
    }

    public String getJSSEProvider(String string) {
        return this.getProperty(string, JSSEPROVIDER, null);
    }

    public String getKeyStore(String string) {
        String string2 = KEYSTORE;
        String string3 = SYSKEYSTORE;
        String string4 = null;
        string4 = this.getPropertyFromConfig(string, string2);
        if (string4 != null) {
            return string4;
        }
        if (string3 != null) {
            string4 = System.getProperty(string3);
        }
        return string4;
    }

    public char[] getKeyStorePassword(String string) {
        String string2 = this.getProperty(string, KEYSTOREPWD, SYSKEYSTOREPWD);
        char[] cArray = null;
        if (string2 != null) {
            cArray = string2.startsWith(xorTag) ? SSLSocketFactoryFactory.deObfuscate(string2) : string2.toCharArray();
        }
        return cArray;
    }

    public String getKeyStoreType(String string) {
        return this.getProperty(string, KEYSTORETYPE, SYSKEYSTORETYPE);
    }

    public String getKeyStoreProvider(String string) {
        return this.getProperty(string, KEYSTOREPROVIDER, null);
    }

    public String getKeyManager(String string) {
        return this.getProperty(string, KEYSTOREMGR, SYSKEYMGRALGO);
    }

    public String getTrustStore(String string) {
        String string2 = this.getProperty(string, TRUSTSTORE, SYSTRUSTSTORE);
        try {
            String string3 = URLDecoder.decode(string2, StandardCharsets.UTF_8.name());
            return string3;
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public char[] getTrustStorePassword(String string) {
        String string2 = this.getProperty(string, TRUSTSTOREPWD, SYSTRUSTSTOREPWD);
        char[] cArray = null;
        if (string2 != null) {
            cArray = string2.startsWith(xorTag) ? SSLSocketFactoryFactory.deObfuscate(string2) : string2.toCharArray();
        }
        return cArray;
    }

    public String getTrustStoreType(String string) {
        return this.getProperty(string, TRUSTSTORETYPE, null);
    }

    public String getTrustStoreProvider(String string) {
        return this.getProperty(string, TRUSTSTOREPROVIDER, null);
    }

    public String getTrustManager(String string) {
        return this.getProperty(string, TRUSTSTOREMGR, SYSTRUSTMGRALGO);
    }

    public String[] getEnabledCipherSuites(String string) {
        String string2 = this.getProperty(string, CIPHERSUITES, null);
        String[] stringArray = SSLSocketFactoryFactory.unpackCipherSuites(string2);
        return stringArray;
    }

    public boolean getClientAuthentication(String string) {
        String string2 = this.getProperty(string, CLIENTAUTH, null);
        boolean bl = false;
        if (string2 != null) {
            bl = Boolean.valueOf(string2);
        }
        return bl;
    }

    private SSLContext getSSLContext(String string) throws MqttSecurityException {
        SSLContext sSLContext = null;
        String string2 = this.getSSLProtocol(string);
        if (string2 == null) {
            string2 = DEFAULT_PROTOCOL;
        }
        if (this.logger != null) {
            this.logger.fine(CLASS_NAME, "getSSLContext", "12000", new Object[]{string != null ? string : "null (broker defaults)", string2});
        }
        String string3 = this.getJSSEProvider(string);
        try {
            String string4;
            Object object;
            TrustManager[] trustManagerArray;
            Object object2;
            Object object3;
            Object object4;
            sSLContext = string3 == null ? SSLContext.getInstance(string2) : SSLContext.getInstance(string2, string3);
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, "getSSLContext", "12001", new Object[]{string != null ? string : "null (broker defaults)", sSLContext.getProvider().getName()});
            }
            String string5 = this.getProperty(string, KEYSTORE, null);
            KeyStore keyStore = null;
            KeyManagerFactory keyManagerFactory = null;
            KeyManager[] keyManagerArray = null;
            if (keyStore == null) {
                if (string5 == null) {
                    string5 = this.getProperty(string, KEYSTORE, SYSKEYSTORE);
                }
                if (this.logger != null) {
                    this.logger.fine(CLASS_NAME, "getSSLContext", "12004", new Object[]{string != null ? string : "null (broker defaults)", string5 != null ? string5 : "null"});
                }
                object4 = this.getKeyStorePassword(string);
                if (this.logger != null) {
                    this.logger.fine(CLASS_NAME, "getSSLContext", "12005", new Object[]{string != null ? string : "null (broker defaults)", object4 != null ? SSLSocketFactoryFactory.obfuscate((char[])object4) : "null"});
                }
                if ((object3 = this.getKeyStoreType(string)) == null) {
                    object3 = KeyStore.getDefaultType();
                }
                if (this.logger != null) {
                    this.logger.fine(CLASS_NAME, "getSSLContext", "12006", new Object[]{string != null ? string : "null (broker defaults)", object3 != null ? object3 : "null"});
                }
                object2 = KeyManagerFactory.getDefaultAlgorithm();
                trustManagerArray = this.getKeyStoreProvider(string);
                object = this.getKeyManager(string);
                if (object != null) {
                    object2 = object;
                }
                if (string5 != null && object3 != null && object2 != null) {
                    try {
                        keyStore = KeyStore.getInstance((String)object3);
                        keyStore.load(new FileInputStream(string5), (char[])object4);
                        keyManagerFactory = trustManagerArray != null ? KeyManagerFactory.getInstance((String)object2, (String)trustManagerArray) : KeyManagerFactory.getInstance((String)object2);
                        if (this.logger != null) {
                            this.logger.fine(CLASS_NAME, "getSSLContext", "12010", new Object[]{string != null ? string : "null (broker defaults)", object2 != null ? object2 : "null"});
                            this.logger.fine(CLASS_NAME, "getSSLContext", "12009", new Object[]{string != null ? string : "null (broker defaults)", keyManagerFactory.getProvider().getName()});
                        }
                        keyManagerFactory.init(keyStore, (char[])object4);
                        keyManagerArray = keyManagerFactory.getKeyManagers();
                    }
                    catch (KeyStoreException keyStoreException) {
                        throw new MqttSecurityException(keyStoreException);
                    }
                    catch (CertificateException certificateException) {
                        throw new MqttSecurityException(certificateException);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new MqttSecurityException(fileNotFoundException);
                    }
                    catch (IOException iOException) {
                        throw new MqttSecurityException(iOException);
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                        throw new MqttSecurityException(unrecoverableKeyException);
                    }
                }
            }
            object4 = this.getTrustStore(string);
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, "getSSLContext", "12011", new Object[]{string != null ? string : "null (broker defaults)", object4 != null ? object4 : "null"});
            }
            object3 = null;
            object2 = null;
            trustManagerArray = null;
            object = this.getTrustStorePassword(string);
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, "getSSLContext", "12012", new Object[]{string != null ? string : "null (broker defaults)", object != null ? SSLSocketFactoryFactory.obfuscate(object) : "null"});
            }
            if ((string4 = this.getTrustStoreType(string)) == null) {
                string4 = KeyStore.getDefaultType();
            }
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, "getSSLContext", "12013", new Object[]{string != null ? string : "null (broker defaults)", string4 != null ? string4 : "null"});
            }
            String string6 = TrustManagerFactory.getDefaultAlgorithm();
            String string7 = this.getTrustStoreProvider(string);
            String string8 = this.getTrustManager(string);
            if (string8 != null) {
                string6 = string8;
            }
            if (object4 != null && string4 != null && string6 != null) {
                try {
                    object3 = KeyStore.getInstance(string4);
                    ((KeyStore)object3).load(new FileInputStream((String)object4), (char[])object);
                    object2 = string7 != null ? TrustManagerFactory.getInstance(string6, string7) : TrustManagerFactory.getInstance(string6);
                    if (this.logger != null) {
                        this.logger.fine(CLASS_NAME, "getSSLContext", "12017", new Object[]{string != null ? string : "null (broker defaults)", string6 != null ? string6 : "null"});
                        this.logger.fine(CLASS_NAME, "getSSLContext", "12016", new Object[]{string != null ? string : "null (broker defaults)", ((TrustManagerFactory)object2).getProvider().getName()});
                    }
                    ((TrustManagerFactory)object2).init((KeyStore)object3);
                    trustManagerArray = ((TrustManagerFactory)object2).getTrustManagers();
                }
                catch (KeyStoreException keyStoreException) {
                    throw new MqttSecurityException(keyStoreException);
                }
                catch (CertificateException certificateException) {
                    throw new MqttSecurityException(certificateException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new MqttSecurityException(fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw new MqttSecurityException(iOException);
                }
            }
            sSLContext.init(keyManagerArray, trustManagerArray, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MqttSecurityException(noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new MqttSecurityException(noSuchProviderException);
        }
        catch (KeyManagementException keyManagementException) {
            throw new MqttSecurityException(keyManagementException);
        }
        return sSLContext;
    }

    public SSLSocketFactory createSocketFactory(String string) throws MqttSecurityException {
        SSLContext sSLContext = this.getSSLContext(string);
        if (this.logger != null) {
            this.logger.fine(CLASS_NAME, "createSocketFactory", "12020", new Object[]{string != null ? string : "null (broker defaults)", this.getEnabledCipherSuites(string) != null ? this.getProperty(string, CIPHERSUITES, null) : "null (using platform-enabled cipher suites)"});
        }
        return sSLContext.getSocketFactory();
    }
}

