/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;

public class FileLock {
    private File lockFile;
    private RandomAccessFile file;
    private Object fileLock;

    public FileLock(File file, String string) throws Exception {
        this.lockFile = new File(file, string);
        if (ExceptionHelper.isClassAvailable("java.nio.channels.FileLock")) {
            try {
                this.file = new RandomAccessFile(this.lockFile, "rw");
                Method method = this.file.getClass().getMethod("getChannel", new Class[0]);
                Object object = method.invoke((Object)this.file, new Object[0]);
                method = object.getClass().getMethod("tryLock", new Class[0]);
                this.fileLock = method.invoke(object, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.fileLock = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fileLock = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.fileLock = null;
            }
            if (this.fileLock == null) {
                this.release();
                throw new Exception("Problem obtaining file lock");
            }
        }
    }

    public void release() {
        try {
            if (this.fileLock != null) {
                Method method = this.fileLock.getClass().getMethod("release", new Class[0]);
                method.invoke(this.fileLock, new Object[0]);
                this.fileLock = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.file = null;
        }
        if (this.lockFile != null && this.lockFile.exists()) {
            this.lockFile.delete();
        }
        this.lockFile = null;
    }
}

