/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.ArrayList;
import org.eclipse.paho.client.mqttv3.BufferedMessage;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.IDiscardedBufferMessageCallback;
import org.eclipse.paho.client.mqttv3.internal.IDisconnectedBufferCallback;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class DisconnectedMessageBuffer
implements Runnable {
    private final String CLASS_NAME = DisconnectedMessageBuffer.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", this.CLASS_NAME);
    private DisconnectedBufferOptions bufferOpts;
    private ArrayList<BufferedMessage> buffer;
    private final Object bufLock = new Object();
    private IDisconnectedBufferCallback callback;
    private IDiscardedBufferMessageCallback messageDiscardedCallBack;
    private int mycount = 0;

    public DisconnectedMessageBuffer(DisconnectedBufferOptions disconnectedBufferOptions) {
        this.bufferOpts = disconnectedBufferOptions;
        this.buffer = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMessage(MqttWireMessage mqttWireMessage, MqttToken mqttToken) throws MqttException {
        if (mqttToken != null) {
            mqttWireMessage.setToken(mqttToken);
            mqttToken.internalTok.setMessageID(mqttWireMessage.getMessageId());
        }
        BufferedMessage bufferedMessage = new BufferedMessage(mqttWireMessage, mqttToken);
        Object object = this.bufLock;
        synchronized (object) {
            if (this.buffer.size() < this.bufferOpts.getBufferSize()) {
                this.buffer.add(bufferedMessage);
            } else if (this.bufferOpts.isDeleteOldestMessages()) {
                if (this.messageDiscardedCallBack != null) {
                    BufferedMessage bufferedMessage2 = this.buffer.get(0);
                    this.messageDiscardedCallBack.messageDiscarded(bufferedMessage2.getMessage());
                }
                this.buffer.remove(0);
                this.buffer.add(bufferedMessage);
            } else {
                throw new MqttException(32203);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedMessage getMessage(int n) {
        Object object = this.bufLock;
        synchronized (object) {
            return this.buffer.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessage(int n) {
        Object object = this.bufLock;
        synchronized (object) {
            this.buffer.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() {
        Object object = this.bufLock;
        synchronized (object) {
            return this.buffer.size();
        }
    }

    @Override
    public void run() {
        this.log.fine(this.CLASS_NAME, "run", "516");
        while (this.getMessageCount() > 0) {
            try {
                BufferedMessage bufferedMessage = this.getMessage(0);
                this.callback.publishBufferedMessage(bufferedMessage);
                this.deleteMessage(0);
            }
            catch (MqttException mqttException) {
                if (mqttException.getReasonCode() == 32202) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                this.log.severe(this.CLASS_NAME, "run", "519", new Object[]{mqttException.getReasonCode(), mqttException.getMessage()});
                break;
            }
        }
    }

    public void setPublishCallback(IDisconnectedBufferCallback iDisconnectedBufferCallback) {
        this.callback = iDisconnectedBufferCallback;
    }

    public boolean isPersistBuffer() {
        return this.bufferOpts.isPersistBuffer();
    }

    public void setMessageDiscardedCallBack(IDiscardedBufferMessageCallback iDiscardedBufferMessageCallback) {
        this.messageDiscardedCallBack = iDiscardedBufferMessageCallback;
    }
}

