/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttOutputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsSender
implements Runnable {
    private static final String CLASS_NAME = CommsSender.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private State current_state = State.STOPPED;
    private State target_state = State.STOPPED;
    private final Object lifecycle = new Object();
    private Thread sendThread = null;
    private String threadName;
    private Future<?> senderFuture;
    private ClientState clientState = null;
    private MqttOutputStream out;
    private ClientComms clientComms = null;
    private CommsTokenStore tokenStore = null;

    public CommsSender(ClientComms clientComms, ClientState clientState, CommsTokenStore commsTokenStore, OutputStream outputStream) {
        this.out = new MqttOutputStream(clientState, outputStream);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = commsTokenStore;
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String string, ExecutorService executorService) {
        this.threadName = string;
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.current_state == State.STOPPED && this.target_state == State.STOPPED) {
                this.target_state = State.RUNNING;
                if (executorService == null) {
                    new Thread(this).start();
                } else {
                    this.senderFuture = executorService.submit(this);
                }
            }
        }
        while (!this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.senderFuture != null) {
                this.senderFuture.cancel(true);
            }
            this.log.fine(CLASS_NAME, "stop", "800");
            if (this.isRunning()) {
                this.target_state = State.STOPPED;
                this.clientState.notifyQueueLock();
            }
        }
        while (this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clientState.notifyQueueLock();
        }
        this.log.fine(CLASS_NAME, "stop", "801");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.sendThread = Thread.currentThread();
        this.sendThread.setName(this.threadName);
        MqttWireMessage mqttWireMessage = null;
        Object object = this.lifecycle;
        synchronized (object) {
            this.current_state = State.RUNNING;
        }
        try {
            Object object2 = this.lifecycle;
            synchronized (object2) {
                object = this.target_state;
            }
            while (object == State.RUNNING && this.out != null) {
                block26: {
                    try {
                        mqttWireMessage = this.clientState.get();
                        if (mqttWireMessage != null) {
                            this.log.fine(CLASS_NAME, "run", "802", new Object[]{mqttWireMessage.getKey(), mqttWireMessage});
                            if (mqttWireMessage instanceof MqttAck) {
                                this.out.write(mqttWireMessage);
                                this.out.flush();
                                break block26;
                            }
                            object2 = mqttWireMessage.getToken();
                            if (object2 == null) {
                                object2 = this.tokenStore.getToken(mqttWireMessage);
                            }
                            if (object2 == null) break block26;
                            Object object3 = object2;
                            synchronized (object3) {
                                block27: {
                                    this.out.write(mqttWireMessage);
                                    try {
                                        this.out.flush();
                                    }
                                    catch (IOException iOException) {
                                        if (mqttWireMessage instanceof MqttDisconnect) break block27;
                                        throw iOException;
                                    }
                                }
                                this.clientState.notifySent(mqttWireMessage);
                                break block26;
                            }
                        }
                        this.log.fine(CLASS_NAME, "run", "803");
                        object2 = this.lifecycle;
                        synchronized (object2) {
                            this.target_state = State.STOPPED;
                        }
                    }
                    catch (MqttException mqttException) {
                        this.handleRunException(mqttWireMessage, mqttException);
                    }
                    catch (Exception exception) {
                        this.handleRunException(mqttWireMessage, exception);
                    }
                }
                object2 = this.lifecycle;
                synchronized (object2) {
                    object = this.target_state;
                }
            }
        }
        finally {
            object = this.lifecycle;
            synchronized (object) {
                this.current_state = State.STOPPED;
                this.sendThread = null;
            }
        }
        this.log.fine(CLASS_NAME, "run", "805");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRunException(MqttWireMessage mqttWireMessage, Exception exception) {
        this.log.fine(CLASS_NAME, "handleRunException", "804", null, exception);
        MqttException mqttException = !(exception instanceof MqttException) ? new MqttException(32109, (Throwable)exception) : (MqttException)exception;
        Object object = this.lifecycle;
        synchronized (object) {
            this.target_state = State.STOPPED;
        }
        this.clientComms.shutdownConnection(null, mqttException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        boolean bl;
        Object object = this.lifecycle;
        synchronized (object) {
            bl = this.current_state == State.RUNNING && this.target_state == State.RUNNING;
        }
        return bl;
    }

    private static enum State {
        STOPPED,
        RUNNING,
        STARTING;

    }
}

