/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRec;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsReceiver
implements Runnable {
    private static final String CLASS_NAME = CommsReceiver.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private State current_state = State.STOPPED;
    private State target_state = State.STOPPED;
    private final Object lifecycle = new Object();
    private String threadName;
    private Future<?> receiverFuture;
    private ClientState clientState = null;
    private ClientComms clientComms = null;
    private MqttInputStream in;
    private CommsTokenStore tokenStore = null;
    private Thread recThread = null;

    public CommsReceiver(ClientComms clientComms, ClientState clientState, CommsTokenStore commsTokenStore, InputStream inputStream) {
        this.in = new MqttInputStream(clientState, inputStream);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = commsTokenStore;
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String string, ExecutorService executorService) {
        this.threadName = string;
        this.log.fine(CLASS_NAME, "start", "855");
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.current_state == State.STOPPED && this.target_state == State.STOPPED) {
                this.target_state = State.RUNNING;
                if (executorService == null) {
                    new Thread(this).start();
                } else {
                    this.receiverFuture = executorService.submit(this);
                }
            }
        }
        while (!this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.receiverFuture != null) {
                this.receiverFuture.cancel(true);
            }
            this.log.fine(CLASS_NAME, "stop", "850");
            if (this.isRunning()) {
                this.target_state = State.STOPPED;
            }
        }
        while (this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        this.log.fine(CLASS_NAME, "stop", "851");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.recThread = Thread.currentThread();
        this.recThread.setName(this.threadName);
        MqttToken mqttToken = null;
        Object object = this.lifecycle;
        // MONITORENTER : object
        this.current_state = State.RUNNING;
        // MONITOREXIT : object
        try {
            Object object2 = this.lifecycle;
            // MONITORENTER : object2
            object = this.target_state;
            // MONITOREXIT : object2
            while (object == State.RUNNING && this.in != null) {
                block47: {
                    Object object3;
                    try {
                        this.log.fine(CLASS_NAME, "run", "852");
                        if (this.in.available() > 0) {
                            object2 = this.lifecycle;
                            // MONITORENTER : object2
                            this.current_state = State.RECEIVING;
                            // MONITOREXIT : object2
                        }
                        object2 = this.in.readMqttWireMessage();
                        object3 = this.lifecycle;
                        // MONITORENTER : object3
                        this.current_state = State.RUNNING;
                        // MONITOREXIT : object3
                        if (object2 instanceof MqttAck) {
                            mqttToken = this.tokenStore.getToken((MqttWireMessage)object2);
                            if (mqttToken != null) {
                                object3 = mqttToken;
                                // MONITORENTER : object3
                                this.clientState.notifyReceivedAck((MqttAck)object2);
                                // MONITOREXIT : object3
                                break block47;
                            } else {
                                if (!(object2 instanceof MqttPubRec) && !(object2 instanceof MqttPubComp)) {
                                    if (!(object2 instanceof MqttPubAck)) throw new MqttException(6);
                                }
                                this.log.fine(CLASS_NAME, "run", "857");
                            }
                            break block47;
                        }
                        if (object2 != null) {
                            this.clientState.notifyReceivedMsg((MqttWireMessage)object2);
                        } else if (!this.clientComms.isConnected() && !this.clientComms.isConnecting()) {
                            throw new IOException("Connection is lost.");
                        }
                    }
                    catch (MqttException mqttException) {
                        this.log.fine(CLASS_NAME, "run", "856", null, mqttException);
                        object3 = this.lifecycle;
                        // MONITORENTER : object3
                        this.target_state = State.STOPPED;
                        // MONITOREXIT : object3
                        this.clientComms.shutdownConnection(mqttToken, mqttException);
                    }
                    catch (IOException iOException) {
                        try {
                            this.log.fine(CLASS_NAME, "run", "853");
                            if (this.target_state == State.STOPPED) break block47;
                            object3 = this.lifecycle;
                            // MONITORENTER : object3
                            this.target_state = State.STOPPED;
                            // MONITOREXIT : object3
                            if (!this.clientComms.isDisconnecting()) {
                                this.clientComms.shutdownConnection(mqttToken, new MqttException(32109, (Throwable)iOException));
                            }
                        }
                        catch (Throwable throwable) {
                            Object object4 = this.lifecycle;
                            // MONITORENTER : object4
                            this.current_state = State.RUNNING;
                            // MONITOREXIT : object4
                            throw throwable;
                        }
                    }
                    finally {
                        object2 = this.lifecycle;
                    }
                }
                object2 = this.lifecycle;
                // MONITORENTER : object2
                object = this.target_state;
                // MONITOREXIT : object2
            }
            object = this.lifecycle;
        }
        catch (Throwable throwable) {
            Object object5 = this.lifecycle;
            // MONITORENTER : object5
            this.current_state = State.STOPPED;
            // MONITOREXIT : object5
            throw throwable;
        }
        this.current_state = State.STOPPED;
        // MONITOREXIT : object
        this.recThread = null;
        this.log.fine(CLASS_NAME, "run", "854");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        boolean bl;
        Object object = this.lifecycle;
        synchronized (object) {
            bl = (this.current_state == State.RUNNING || this.current_state == State.RECEIVING) && this.target_state == State.RUNNING;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReceiving() {
        boolean bl;
        Object object = this.lifecycle;
        synchronized (object) {
            bl = this.current_state == State.RECEIVING;
        }
        return bl;
    }

    private static enum State {
        STOPPED,
        RUNNING,
        STARTING,
        RECEIVING;

    }
}

