/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.EOFException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.CommsCallback;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.HighResolutionTimer;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPersistableWireMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingReq;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingResp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRec;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRel;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSuback;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class ClientState {
    private static final String CLASS_NAME = ClientState.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private static final String PERSISTENCE_SENT_PREFIX = "s-";
    private static final String PERSISTENCE_SENT_BUFFERED_PREFIX = "sb-";
    private static final String PERSISTENCE_CONFIRMED_PREFIX = "sc-";
    private static final String PERSISTENCE_RECEIVED_PREFIX = "r-";
    private static final int MIN_MSG_ID = 1;
    private static final int MAX_MSG_ID = 65535;
    private int nextMsgId = 0;
    private Hashtable inUseMsgIds;
    private volatile Vector pendingMessages;
    private volatile Vector pendingFlows;
    private CommsTokenStore tokenStore;
    private ClientComms clientComms = null;
    private CommsCallback callback = null;
    private long keepAliveNanos;
    private boolean cleanSession;
    private MqttClientPersistence persistence;
    private HighResolutionTimer highResolutionTimer;
    private int maxInflight = 0;
    private int actualInFlight = 0;
    private int inFlightPubRels = 0;
    private final Object queueLock = new Object();
    private final Object quiesceLock = new Object();
    private boolean quiescing = false;
    private long lastOutboundActivity = 0L;
    private long lastInboundActivity = 0L;
    private long lastPing = 0L;
    private MqttWireMessage pingCommand;
    private final Object pingOutstandingLock = new Object();
    private int pingOutstanding = 0;
    private boolean connected = false;
    private Hashtable outboundQoS2 = null;
    private Hashtable outboundQoS1 = null;
    private Hashtable outboundQoS0 = null;
    private Hashtable inboundQoS2 = null;
    private MqttPingSender pingSender = null;

    protected ClientState(MqttClientPersistence mqttClientPersistence, CommsTokenStore commsTokenStore, CommsCallback commsCallback, ClientComms clientComms, MqttPingSender mqttPingSender, HighResolutionTimer highResolutionTimer) throws MqttException {
        this.log.setResourceName(clientComms.getClient().getClientId());
        this.log.finer(CLASS_NAME, "<Init>", "");
        this.inUseMsgIds = new Hashtable();
        this.pendingFlows = new Vector();
        this.outboundQoS2 = new Hashtable();
        this.outboundQoS1 = new Hashtable();
        this.outboundQoS0 = new Hashtable();
        this.inboundQoS2 = new Hashtable();
        this.pingCommand = new MqttPingReq();
        this.inFlightPubRels = 0;
        this.actualInFlight = 0;
        this.persistence = mqttClientPersistence;
        this.callback = commsCallback;
        this.tokenStore = commsTokenStore;
        this.clientComms = clientComms;
        this.pingSender = mqttPingSender;
        this.highResolutionTimer = highResolutionTimer;
        this.restoreState();
    }

    protected void setMaxInflight(int n) {
        this.maxInflight = n;
        this.pendingMessages = new Vector(this.maxInflight);
    }

    protected void setKeepAliveSecs(long l) {
        this.keepAliveNanos = TimeUnit.SECONDS.toNanos(l);
    }

    protected long getKeepAlive() {
        return TimeUnit.NANOSECONDS.toMillis(this.keepAliveNanos);
    }

    protected void setCleanSession(boolean bl) {
        this.cleanSession = bl;
    }

    protected boolean getCleanSession() {
        return this.cleanSession;
    }

    private String getSendPersistenceKey(MqttWireMessage mqttWireMessage) {
        return PERSISTENCE_SENT_PREFIX + mqttWireMessage.getMessageId();
    }

    private String getSendPersistenceKey(int n) {
        return PERSISTENCE_SENT_PREFIX + n;
    }

    private String getSendConfirmPersistenceKey(MqttWireMessage mqttWireMessage) {
        return PERSISTENCE_CONFIRMED_PREFIX + mqttWireMessage.getMessageId();
    }

    private String getReceivedPersistenceKey(MqttWireMessage mqttWireMessage) {
        return PERSISTENCE_RECEIVED_PREFIX + mqttWireMessage.getMessageId();
    }

    private String getReceivedPersistenceKey(int n) {
        return PERSISTENCE_RECEIVED_PREFIX + n;
    }

    private String getSendBufferedPersistenceKey(MqttWireMessage mqttWireMessage) {
        return PERSISTENCE_SENT_BUFFERED_PREFIX + mqttWireMessage.getMessageId();
    }

    protected void clearState() throws MqttException {
        this.log.fine(CLASS_NAME, "clearState", ">");
        this.persistence.clear();
        this.inUseMsgIds.clear();
        this.pendingMessages.clear();
        this.pendingFlows.clear();
        this.outboundQoS2.clear();
        this.outboundQoS1.clear();
        this.outboundQoS0.clear();
        this.inboundQoS2.clear();
        this.tokenStore.clear();
    }

    private MqttWireMessage restoreMessage(String string, MqttPersistable mqttPersistable) throws MqttException {
        MqttWireMessage mqttWireMessage = null;
        try {
            mqttWireMessage = MqttWireMessage.createWireMessage(mqttPersistable);
        }
        catch (MqttException mqttException) {
            this.log.fine(CLASS_NAME, "restoreMessage", "602", new Object[]{string}, mqttException);
            if (mqttException.getCause() instanceof EOFException) {
                if (string != null) {
                    this.persistence.remove(string);
                }
            }
            throw mqttException;
        }
        this.log.fine(CLASS_NAME, "restoreMessage", "601", new Object[]{string, mqttWireMessage});
        return mqttWireMessage;
    }

    private void insertInOrder(Vector vector, MqttWireMessage mqttWireMessage) {
        int n = mqttWireMessage.getMessageId();
        for (int i = 0; i < vector.size(); ++i) {
            MqttWireMessage mqttWireMessage2 = (MqttWireMessage)vector.elementAt(i);
            int n2 = mqttWireMessage2.getMessageId();
            if (n2 <= n) continue;
            vector.insertElementAt(mqttWireMessage, i);
            return;
        }
        vector.addElement(mqttWireMessage);
    }

    private Vector reOrder(Vector vector) {
        int n;
        int n2;
        int n3;
        Vector vector2 = new Vector();
        if (vector.size() == 0) {
            return vector2;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < vector.size(); ++n3) {
            n2 = ((MqttWireMessage)vector.elementAt(n3)).getMessageId();
            if (n2 - n4 > n5) {
                n5 = n2 - n4;
                n6 = n3;
            }
            n4 = n2;
        }
        n2 = n4;
        n3 = ((MqttWireMessage)vector.elementAt(0)).getMessageId();
        if (65535 - n2 + n3 > n5) {
            n6 = 0;
        }
        for (n = n6; n < vector.size(); ++n) {
            vector2.addElement(vector.elementAt(n));
        }
        for (n = 0; n < n6; ++n) {
            vector2.addElement(vector.elementAt(n));
        }
        return vector2;
    }

    protected void restoreState() throws MqttException {
        String string;
        Enumeration enumeration = this.persistence.keys();
        int n = this.nextMsgId;
        Vector<String> vector = new Vector<String>();
        this.log.fine(CLASS_NAME, "restoreState", "600");
        while (enumeration.hasMoreElements()) {
            Object object;
            MqttPersistableWireMessage mqttPersistableWireMessage;
            MqttPersistable mqttPersistable;
            string = (String)enumeration.nextElement();
            MqttWireMessage mqttWireMessage = this.restoreMessage(string, mqttPersistable = this.persistence.get(string));
            if (mqttWireMessage == null) continue;
            if (string.startsWith(PERSISTENCE_RECEIVED_PREFIX)) {
                this.log.fine(CLASS_NAME, "restoreState", "604", new Object[]{string, mqttWireMessage});
                this.inboundQoS2.put(mqttWireMessage.getMessageId(), mqttWireMessage);
                continue;
            }
            if (string.startsWith(PERSISTENCE_SENT_PREFIX)) {
                mqttPersistableWireMessage = (MqttPublish)mqttWireMessage;
                n = Math.max(mqttPersistableWireMessage.getMessageId(), n);
                if (this.persistence.containsKey(this.getSendConfirmPersistenceKey(mqttPersistableWireMessage))) {
                    object = this.persistence.get(this.getSendConfirmPersistenceKey(mqttPersistableWireMessage));
                    MqttPubRel mqttPubRel = (MqttPubRel)this.restoreMessage(string, (MqttPersistable)object);
                    if (mqttPubRel != null) {
                        this.log.fine(CLASS_NAME, "restoreState", "605", new Object[]{string, mqttWireMessage});
                        this.outboundQoS2.put(mqttPubRel.getMessageId(), mqttPubRel);
                    } else {
                        this.log.fine(CLASS_NAME, "restoreState", "606", new Object[]{string, mqttWireMessage});
                    }
                } else {
                    mqttPersistableWireMessage.setDuplicate(true);
                    if (((MqttPublish)mqttPersistableWireMessage).getMessage().getQos() == 2) {
                        this.log.fine(CLASS_NAME, "restoreState", "607", new Object[]{string, mqttWireMessage});
                        this.outboundQoS2.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage);
                    } else {
                        this.log.fine(CLASS_NAME, "restoreState", "608", new Object[]{string, mqttWireMessage});
                        this.outboundQoS1.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage);
                    }
                }
                object = this.tokenStore.restoreToken((MqttPublish)mqttPersistableWireMessage);
                ((MqttDeliveryToken)object).internalTok.setClient(this.clientComms.getClient());
                this.inUseMsgIds.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage.getMessageId());
                continue;
            }
            if (string.startsWith(PERSISTENCE_SENT_BUFFERED_PREFIX)) {
                mqttPersistableWireMessage = (MqttPublish)mqttWireMessage;
                n = Math.max(mqttPersistableWireMessage.getMessageId(), n);
                if (((MqttPublish)mqttPersistableWireMessage).getMessage().getQos() == 2) {
                    this.log.fine(CLASS_NAME, "restoreState", "607", new Object[]{string, mqttWireMessage});
                    this.outboundQoS2.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage);
                } else if (((MqttPublish)mqttPersistableWireMessage).getMessage().getQos() == 1) {
                    this.log.fine(CLASS_NAME, "restoreState", "608", new Object[]{string, mqttWireMessage});
                    this.outboundQoS1.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage);
                } else {
                    this.log.fine(CLASS_NAME, "restoreState", "511", new Object[]{string, mqttWireMessage});
                    this.outboundQoS0.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage);
                    this.persistence.remove(string);
                }
                object = this.tokenStore.restoreToken((MqttPublish)mqttPersistableWireMessage);
                ((MqttDeliveryToken)object).internalTok.setClient(this.clientComms.getClient());
                this.inUseMsgIds.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage.getMessageId());
                continue;
            }
            if (!string.startsWith(PERSISTENCE_CONFIRMED_PREFIX) || this.persistence.containsKey(this.getSendPersistenceKey(mqttPersistableWireMessage = (MqttPubRel)mqttWireMessage))) continue;
            vector.addElement(string);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.log.fine(CLASS_NAME, "restoreState", "609", new Object[]{string});
            this.persistence.remove(string);
        }
        this.nextMsgId = n;
    }

    private void restoreInflightMessages() {
        MqttWireMessage mqttWireMessage;
        Object k;
        this.pendingMessages = new Vector(this.maxInflight);
        this.pendingFlows = new Vector();
        Enumeration enumeration = this.outboundQoS2.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            mqttWireMessage = (MqttWireMessage)this.outboundQoS2.get(k);
            if (mqttWireMessage instanceof MqttPublish) {
                this.log.fine(CLASS_NAME, "restoreInflightMessages", "610", new Object[]{k});
                mqttWireMessage.setDuplicate(true);
                this.insertInOrder(this.pendingMessages, (MqttPublish)mqttWireMessage);
                continue;
            }
            if (!(mqttWireMessage instanceof MqttPubRel)) continue;
            this.log.fine(CLASS_NAME, "restoreInflightMessages", "611", new Object[]{k});
            this.insertInOrder(this.pendingFlows, (MqttPubRel)mqttWireMessage);
        }
        enumeration = this.outboundQoS1.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            mqttWireMessage = (MqttPublish)this.outboundQoS1.get(k);
            mqttWireMessage.setDuplicate(true);
            this.log.fine(CLASS_NAME, "restoreInflightMessages", "612", new Object[]{k});
            this.insertInOrder(this.pendingMessages, mqttWireMessage);
        }
        enumeration = this.outboundQoS0.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            mqttWireMessage = (MqttPublish)this.outboundQoS0.get(k);
            this.log.fine(CLASS_NAME, "restoreInflightMessages", "512", new Object[]{k});
            this.insertInOrder(this.pendingMessages, mqttWireMessage);
        }
        this.pendingFlows = this.reOrder(this.pendingFlows);
        this.pendingMessages = this.reOrder(this.pendingMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MqttWireMessage mqttWireMessage, MqttToken mqttToken) throws MqttException {
        if (mqttWireMessage.isMessageIdRequired() && mqttWireMessage.getMessageId() == 0) {
            if (mqttWireMessage instanceof MqttPublish && ((MqttPublish)mqttWireMessage).getMessage().getQos() != 0) {
                mqttWireMessage.setMessageId(this.getNextMessageId());
            } else if (mqttWireMessage instanceof MqttPubAck || mqttWireMessage instanceof MqttPubRec || mqttWireMessage instanceof MqttPubRel || mqttWireMessage instanceof MqttPubComp || mqttWireMessage instanceof MqttSubscribe || mqttWireMessage instanceof MqttSuback || mqttWireMessage instanceof MqttUnsubscribe || mqttWireMessage instanceof MqttUnsubAck) {
                mqttWireMessage.setMessageId(this.getNextMessageId());
            }
        }
        if (mqttToken != null) {
            mqttWireMessage.setToken(mqttToken);
            try {
                mqttToken.internalTok.setMessageID(mqttWireMessage.getMessageId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mqttWireMessage instanceof MqttPublish) {
            Object object = this.queueLock;
            synchronized (object) {
                if (this.actualInFlight >= this.maxInflight) {
                    this.log.fine(CLASS_NAME, "send", "613", new Object[]{this.actualInFlight});
                    throw new MqttException(32202);
                }
                MqttMessage mqttMessage = ((MqttPublish)mqttWireMessage).getMessage();
                this.log.fine(CLASS_NAME, "send", "628", new Object[]{mqttWireMessage.getMessageId(), mqttMessage.getQos(), mqttWireMessage});
                switch (mqttMessage.getQos()) {
                    case 2: {
                        this.outboundQoS2.put(mqttWireMessage.getMessageId(), mqttWireMessage);
                        this.persistence.put(this.getSendPersistenceKey(mqttWireMessage), (MqttPublish)mqttWireMessage);
                        this.tokenStore.saveToken(mqttToken, mqttWireMessage);
                        break;
                    }
                    case 1: {
                        this.outboundQoS1.put(mqttWireMessage.getMessageId(), mqttWireMessage);
                        this.persistence.put(this.getSendPersistenceKey(mqttWireMessage), (MqttPublish)mqttWireMessage);
                        this.tokenStore.saveToken(mqttToken, mqttWireMessage);
                    }
                }
                this.pendingMessages.addElement(mqttWireMessage);
                this.queueLock.notifyAll();
            }
        }
        this.log.fine(CLASS_NAME, "send", "615", new Object[]{mqttWireMessage.getMessageId(), mqttWireMessage});
        if (mqttWireMessage instanceof MqttConnect) {
            Object object = this.queueLock;
            synchronized (object) {
                this.tokenStore.saveToken(mqttToken, mqttWireMessage);
                this.pendingFlows.insertElementAt(mqttWireMessage, 0);
                this.queueLock.notifyAll();
            }
        }
        if (mqttWireMessage instanceof MqttPingReq) {
            this.pingCommand = mqttWireMessage;
        } else if (mqttWireMessage instanceof MqttPubRel) {
            this.outboundQoS2.put(mqttWireMessage.getMessageId(), mqttWireMessage);
            this.persistence.put(this.getSendConfirmPersistenceKey(mqttWireMessage), (MqttPubRel)mqttWireMessage);
        } else if (mqttWireMessage instanceof MqttPubComp) {
            this.persistence.remove(this.getReceivedPersistenceKey(mqttWireMessage));
        }
        Object object = this.queueLock;
        synchronized (object) {
            if (!(mqttWireMessage instanceof MqttAck)) {
                this.tokenStore.saveToken(mqttToken, mqttWireMessage);
            }
            this.pendingFlows.addElement(mqttWireMessage);
            this.queueLock.notifyAll();
        }
    }

    public void persistBufferedMessage(MqttWireMessage mqttWireMessage) throws MqttException {
        String string = this.getSendBufferedPersistenceKey(mqttWireMessage);
        try {
            mqttWireMessage.setMessageId(this.getNextMessageId());
            string = this.getSendBufferedPersistenceKey(mqttWireMessage);
            try {
                this.persistence.put(string, (MqttPublish)mqttWireMessage);
            }
            catch (MqttPersistenceException mqttPersistenceException) {
                this.log.fine(CLASS_NAME, "persistBufferedMessage", "515");
                this.persistence.open(this.clientComms.getClient().getClientId(), this.clientComms.getClient().getServerURI());
                this.persistence.put(string, (MqttPublish)mqttWireMessage);
            }
            this.log.fine(CLASS_NAME, "persistBufferedMessage", "513", new Object[]{string});
        }
        catch (MqttException mqttException) {
            this.log.warning(CLASS_NAME, "persistBufferedMessage", "514", new Object[]{string});
            throw mqttException;
        }
    }

    public void unPersistBufferedMessage(MqttWireMessage mqttWireMessage) {
        try {
            this.log.fine(CLASS_NAME, "unPersistBufferedMessage", "517", new Object[]{mqttWireMessage.getKey()});
            this.persistence.remove(this.getSendBufferedPersistenceKey(mqttWireMessage));
        }
        catch (MqttPersistenceException mqttPersistenceException) {
            this.log.fine(CLASS_NAME, "unPersistBufferedMessage", "518", new Object[]{mqttWireMessage.getKey()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undo(MqttPublish mqttPublish) throws MqttPersistenceException {
        Object object = this.queueLock;
        synchronized (object) {
            this.log.fine(CLASS_NAME, "undo", "618", new Object[]{mqttPublish.getMessageId(), mqttPublish.getMessage().getQos()});
            if (mqttPublish.getMessage().getQos() == 1) {
                this.outboundQoS1.remove(mqttPublish.getMessageId());
            } else {
                this.outboundQoS2.remove(mqttPublish.getMessageId());
            }
            this.pendingMessages.removeElement(mqttPublish);
            this.persistence.remove(this.getSendPersistenceKey(mqttPublish));
            this.tokenStore.removeToken(mqttPublish);
            if (mqttPublish.getMessage().getQos() > 0) {
                this.releaseMessageId(mqttPublish.getMessageId());
                mqttPublish.setMessageId(0);
            }
            this.checkQuiesceLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeMessage(IMqttDeliveryToken iMqttDeliveryToken) throws MqttException {
        MqttMessage mqttMessage = iMqttDeliveryToken.getMessage();
        int n = iMqttDeliveryToken.getMessageId();
        boolean bl = false;
        Object object = this.queueLock;
        synchronized (object) {
            if (mqttMessage.getQos() == 1 && this.outboundQoS1.remove(n) != null) {
                bl = true;
            }
            if (mqttMessage.getQos() == 2 && this.outboundQoS2.remove(n) != null) {
                bl = true;
            }
            if (this.pendingMessages.removeElement(mqttMessage)) {
                bl = true;
            }
            this.persistence.remove(this.getSendPersistenceKey(n));
            String string = Integer.toString(n);
            this.tokenStore.removeToken(string);
            this.releaseMessageId(n);
            this.decrementInFlight();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttToken checkForActivity(IMqttActionListener iMqttActionListener) throws MqttException {
        this.log.fine(CLASS_NAME, "checkForActivity", "616", new Object[0]);
        Object object = this.quiesceLock;
        synchronized (object) {
            if (this.quiescing) {
                return null;
            }
        }
        object = null;
        long l = TimeUnit.NANOSECONDS.toMillis(this.keepAliveNanos);
        if (this.connected && this.keepAliveNanos > 0L) {
            long l2 = this.highResolutionTimer.nanoTime();
            int n = 100000;
            Object object2 = this.pingOutstandingLock;
            synchronized (object2) {
                if (this.pingOutstanding > 0 && l2 - this.lastInboundActivity >= this.keepAliveNanos + (long)n) {
                    this.log.severe(CLASS_NAME, "checkForActivity", "619", new Object[]{this.keepAliveNanos, this.lastOutboundActivity, this.lastInboundActivity, l2, this.lastPing});
                    throw ExceptionHelper.createMqttException(32000);
                }
                if (this.pingOutstanding == 0 && l2 - this.lastOutboundActivity >= 2L * this.keepAliveNanos) {
                    this.log.severe(CLASS_NAME, "checkForActivity", "642", new Object[]{this.keepAliveNanos, this.lastOutboundActivity, this.lastInboundActivity, l2, this.lastPing});
                    throw ExceptionHelper.createMqttException(32002);
                }
                if (this.pingOutstanding == 0 && l2 - this.lastInboundActivity >= this.keepAliveNanos - (long)n || l2 - this.lastOutboundActivity >= this.keepAliveNanos - (long)n) {
                    this.log.fine(CLASS_NAME, "checkForActivity", "620", new Object[]{this.keepAliveNanos, this.lastOutboundActivity, this.lastInboundActivity});
                    object = new MqttToken(this.clientComms.getClient().getClientId());
                    if (iMqttActionListener != null) {
                        ((MqttToken)object).setActionCallback(iMqttActionListener);
                    }
                    this.tokenStore.saveToken((MqttToken)object, this.pingCommand);
                    this.pendingFlows.insertElementAt(this.pingCommand, 0);
                    l = this.getKeepAlive();
                    this.notifyQueueLock();
                } else {
                    this.log.fine(CLASS_NAME, "checkForActivity", "634", null);
                    long l3 = l2 - this.lastOutboundActivity;
                    long l4 = TimeUnit.NANOSECONDS.toMillis(l3);
                    l = Math.max(1L, this.getKeepAlive() - l4);
                }
            }
            this.log.fine(CLASS_NAME, "checkForActivity", "624", new Object[]{l});
            this.pingSender.schedule(l);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MqttWireMessage get() throws MqttException {
        MqttWireMessage mqttWireMessage = null;
        Object object = this.queueLock;
        synchronized (object) {
            while (mqttWireMessage == null) {
                if (this.pendingMessages.isEmpty() && this.pendingFlows.isEmpty() || this.pendingFlows.isEmpty() && this.actualInFlight >= this.maxInflight) {
                    try {
                        this.log.fine(CLASS_NAME, "get", "644");
                        this.queueLock.wait();
                        this.log.fine(CLASS_NAME, "get", "647");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.pendingFlows == null || !this.connected && (this.pendingFlows.isEmpty() || !((MqttWireMessage)this.pendingFlows.elementAt(0) instanceof MqttConnect))) {
                    this.log.fine(CLASS_NAME, "get", "621");
                    return null;
                }
                if (!this.pendingFlows.isEmpty()) {
                    mqttWireMessage = (MqttWireMessage)this.pendingFlows.remove(0);
                    if (mqttWireMessage instanceof MqttPubRel) {
                        ++this.inFlightPubRels;
                        this.log.fine(CLASS_NAME, "get", "617", new Object[]{this.inFlightPubRels});
                    }
                    this.checkQuiesceLock();
                    continue;
                }
                if (this.pendingMessages.isEmpty()) continue;
                if (this.actualInFlight < this.maxInflight) {
                    mqttWireMessage = (MqttWireMessage)this.pendingMessages.elementAt(0);
                    this.pendingMessages.removeElementAt(0);
                    ++this.actualInFlight;
                    this.log.fine(CLASS_NAME, "get", "623", new Object[]{this.actualInFlight});
                    continue;
                }
                this.log.fine(CLASS_NAME, "get", "622");
            }
        }
        return mqttWireMessage;
    }

    public void setKeepAliveInterval(long l) {
        this.keepAliveNanos = TimeUnit.MILLISECONDS.toNanos(l);
    }

    public void notifySentBytes(int n) {
        if (n > 0) {
            this.lastOutboundActivity = this.highResolutionTimer.nanoTime();
        }
        this.log.fine(CLASS_NAME, "notifySentBytes", "643", new Object[]{n});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySent(MqttWireMessage mqttWireMessage) {
        this.lastOutboundActivity = this.highResolutionTimer.nanoTime();
        this.log.fine(CLASS_NAME, "notifySent", "625", new Object[]{mqttWireMessage.getKey()});
        MqttToken mqttToken = mqttWireMessage.getToken();
        if (mqttToken == null && (mqttToken = this.tokenStore.getToken(mqttWireMessage)) == null) {
            return;
        }
        mqttToken.internalTok.notifySent();
        if (mqttWireMessage instanceof MqttPingReq) {
            Object object = this.pingOutstandingLock;
            synchronized (object) {
                long l = this.highResolutionTimer.nanoTime();
                Object object2 = this.pingOutstandingLock;
                synchronized (object2) {
                    this.lastPing = l;
                    ++this.pingOutstanding;
                }
                this.log.fine(CLASS_NAME, "notifySent", "635", new Object[]{this.pingOutstanding});
            }
        }
        if (mqttWireMessage instanceof MqttPublish && ((MqttPublish)mqttWireMessage).getMessage().getQos() == 0) {
            mqttToken.internalTok.markComplete(null, null);
            this.callback.asyncOperationComplete(mqttToken);
            this.decrementInFlight();
            this.releaseMessageId(mqttWireMessage.getMessageId());
            this.tokenStore.removeToken(mqttWireMessage);
            this.checkQuiesceLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementInFlight() {
        Object object = this.queueLock;
        synchronized (object) {
            --this.actualInFlight;
            this.log.fine(CLASS_NAME, "decrementInFlight", "646", new Object[]{this.actualInFlight});
            if (!this.checkQuiesceLock()) {
                this.queueLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkQuiesceLock() {
        int n = this.tokenStore.count();
        if (this.quiescing && n == 0 && this.pendingFlows.size() == 0 && this.callback.isQuiesced()) {
            this.log.fine(CLASS_NAME, "checkQuiesceLock", "626", new Object[]{this.quiescing, this.actualInFlight, this.pendingFlows.size(), this.inFlightPubRels, this.callback.isQuiesced(), n});
            Object object = this.quiesceLock;
            synchronized (object) {
                this.quiesceLock.notifyAll();
            }
            return true;
        }
        return false;
    }

    public void notifyReceivedBytes(int n) {
        if (n > 0) {
            this.lastInboundActivity = this.highResolutionTimer.nanoTime();
        }
        this.log.fine(CLASS_NAME, "notifyReceivedBytes", "630", new Object[]{n});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReceivedAck(MqttAck mqttAck) throws MqttException {
        this.lastInboundActivity = this.highResolutionTimer.nanoTime();
        this.log.fine(CLASS_NAME, "notifyReceivedAck", "627", new Object[]{mqttAck.getMessageId(), mqttAck});
        MqttToken mqttToken = this.tokenStore.getToken(mqttAck);
        MqttException mqttException = null;
        if (mqttToken == null) {
            this.log.fine(CLASS_NAME, "notifyReceivedAck", "662", new Object[]{mqttAck.getMessageId()});
        } else if (mqttAck instanceof MqttPubRec) {
            MqttPubRel mqttPubRel = new MqttPubRel((MqttPubRec)mqttAck);
            this.send(mqttPubRel, mqttToken);
        } else if (mqttAck instanceof MqttPubAck || mqttAck instanceof MqttPubComp) {
            this.notifyResult(mqttAck, mqttToken, mqttException);
        } else if (mqttAck instanceof MqttPingResp) {
            Object object = this.pingOutstandingLock;
            synchronized (object) {
                this.pingOutstanding = Math.max(0, this.pingOutstanding - 1);
                this.notifyResult(mqttAck, mqttToken, mqttException);
                if (this.pingOutstanding == 0) {
                    this.tokenStore.removeToken(mqttAck);
                }
            }
            this.log.fine(CLASS_NAME, "notifyReceivedAck", "636", new Object[]{this.pingOutstanding});
        } else if (mqttAck instanceof MqttConnack) {
            Object object;
            int n = ((MqttConnack)mqttAck).getReturnCode();
            if (n == 0) {
                object = this.queueLock;
                synchronized (object) {
                    if (this.cleanSession) {
                        this.clearState();
                        this.tokenStore.saveToken(mqttToken, mqttAck);
                    }
                    this.inFlightPubRels = 0;
                    this.actualInFlight = 0;
                    this.restoreInflightMessages();
                    this.connected();
                }
            } else {
                mqttException = ExceptionHelper.createMqttException(n);
                throw mqttException;
            }
            this.clientComms.connectComplete((MqttConnack)mqttAck, mqttException);
            this.notifyResult(mqttAck, mqttToken, mqttException);
            this.tokenStore.removeToken(mqttAck);
            object = this.queueLock;
            synchronized (object) {
                this.queueLock.notifyAll();
            }
        } else {
            this.notifyResult(mqttAck, mqttToken, mqttException);
            this.releaseMessageId(mqttAck.getMessageId());
            this.tokenStore.removeToken(mqttAck);
        }
        this.checkQuiesceLock();
    }

    protected void notifyReceivedMsg(MqttWireMessage mqttWireMessage) throws MqttException {
        this.lastInboundActivity = this.highResolutionTimer.nanoTime();
        this.log.fine(CLASS_NAME, "notifyReceivedMsg", "651", new Object[]{mqttWireMessage.getMessageId(), mqttWireMessage});
        if (!this.quiescing) {
            if (mqttWireMessage instanceof MqttPublish) {
                MqttPublish mqttPublish = (MqttPublish)mqttWireMessage;
                switch (mqttPublish.getMessage().getQos()) {
                    case 0: 
                    case 1: {
                        if (this.callback == null) break;
                        this.callback.messageArrived(mqttPublish);
                        break;
                    }
                    case 2: {
                        this.persistence.put(this.getReceivedPersistenceKey(mqttWireMessage), (MqttPublish)mqttWireMessage);
                        this.inboundQoS2.put(mqttPublish.getMessageId(), mqttPublish);
                        this.send(new MqttPubRec(mqttPublish), null);
                        break;
                    }
                }
            } else if (mqttWireMessage instanceof MqttPubRel) {
                MqttPublish mqttPublish = (MqttPublish)this.inboundQoS2.get(mqttWireMessage.getMessageId());
                if (mqttPublish != null) {
                    if (this.callback != null) {
                        this.callback.messageArrived(mqttPublish);
                    }
                } else {
                    MqttPubComp mqttPubComp = new MqttPubComp(mqttWireMessage.getMessageId());
                    this.send(mqttPubComp, null);
                }
            }
        }
    }

    protected void notifyComplete(MqttToken mqttToken) throws MqttException {
        MqttWireMessage mqttWireMessage = mqttToken.internalTok.getWireMessage();
        if (mqttWireMessage != null && mqttWireMessage instanceof MqttAck) {
            this.log.fine(CLASS_NAME, "notifyComplete", "629", new Object[]{mqttWireMessage.getMessageId(), mqttToken, mqttWireMessage});
            MqttAck mqttAck = (MqttAck)mqttWireMessage;
            if (mqttAck instanceof MqttPubAck) {
                this.persistence.remove(this.getSendPersistenceKey(mqttWireMessage));
                this.persistence.remove(this.getSendBufferedPersistenceKey(mqttWireMessage));
                this.outboundQoS1.remove(mqttAck.getMessageId());
                this.decrementInFlight();
                this.releaseMessageId(mqttWireMessage.getMessageId());
                this.tokenStore.removeToken(mqttWireMessage);
                this.log.fine(CLASS_NAME, "notifyComplete", "650", new Object[]{mqttAck.getMessageId()});
            } else if (mqttAck instanceof MqttPubComp) {
                this.persistence.remove(this.getSendPersistenceKey(mqttWireMessage));
                this.persistence.remove(this.getSendConfirmPersistenceKey(mqttWireMessage));
                this.persistence.remove(this.getSendBufferedPersistenceKey(mqttWireMessage));
                this.outboundQoS2.remove(mqttAck.getMessageId());
                --this.inFlightPubRels;
                this.decrementInFlight();
                this.releaseMessageId(mqttWireMessage.getMessageId());
                this.tokenStore.removeToken(mqttWireMessage);
                this.log.fine(CLASS_NAME, "notifyComplete", "645", new Object[]{mqttAck.getMessageId(), this.inFlightPubRels});
            }
            this.checkQuiesceLock();
        }
    }

    protected void notifyResult(MqttWireMessage mqttWireMessage, MqttToken mqttToken, MqttException mqttException) {
        mqttToken.internalTok.markComplete(mqttWireMessage, mqttException);
        mqttToken.internalTok.notifyComplete();
        if (mqttWireMessage != null && mqttWireMessage instanceof MqttAck && !(mqttWireMessage instanceof MqttPubRec)) {
            this.log.fine(CLASS_NAME, "notifyResult", "648", new Object[]{mqttToken.internalTok.getKey(), mqttWireMessage, mqttException});
            this.callback.asyncOperationComplete(mqttToken);
        }
        if (mqttWireMessage == null) {
            this.log.fine(CLASS_NAME, "notifyResult", "649", new Object[]{mqttToken.internalTok.getKey(), mqttException});
            this.callback.asyncOperationComplete(mqttToken);
        }
    }

    public void connected() {
        this.log.fine(CLASS_NAME, "connected", "631");
        this.connected = true;
        this.pingSender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector resolveOldTokens(MqttException mqttException) {
        this.log.fine(CLASS_NAME, "resolveOldTokens", "632", new Object[]{mqttException});
        MqttException mqttException2 = mqttException;
        if (mqttException == null) {
            mqttException2 = new MqttException(32102);
        }
        Vector vector = this.tokenStore.getOutstandingTokens();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MqttToken mqttToken;
            MqttToken mqttToken2 = mqttToken = (MqttToken)enumeration.nextElement();
            synchronized (mqttToken2) {
                if (!mqttToken.isComplete() && !mqttToken.internalTok.isCompletePending() && mqttToken.getException() == null) {
                    mqttToken.internalTok.setException(mqttException2);
                }
            }
            if (mqttToken instanceof MqttDeliveryToken) continue;
            this.tokenStore.removeToken(mqttToken.internalTok.getKey());
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(MqttException mqttException) {
        this.log.fine(CLASS_NAME, "disconnected", "633", new Object[]{mqttException});
        this.connected = false;
        try {
            if (this.cleanSession) {
                this.clearState();
            }
            this.pendingMessages.clear();
            this.pendingFlows.clear();
            Object object = this.pingOutstandingLock;
            synchronized (object) {
                this.pingOutstanding = 0;
            }
        }
        catch (MqttException mqttException2) {
            // empty catch block
        }
    }

    private synchronized void releaseMessageId(int n) {
        this.inUseMsgIds.remove(n);
    }

    private synchronized int getNextMessageId() throws MqttException {
        int n = this.nextMsgId;
        int n2 = 0;
        do {
            ++this.nextMsgId;
            if (this.nextMsgId > 65535) {
                this.nextMsgId = 1;
            }
            if (this.nextMsgId != n || ++n2 != 2) continue;
            throw ExceptionHelper.createMqttException(32001);
        } while (this.inUseMsgIds.containsKey(this.nextMsgId));
        Integer n3 = this.nextMsgId;
        this.inUseMsgIds.put(n3, n3);
        return this.nextMsgId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce(long l) {
        if (l > 0L) {
            this.log.fine(CLASS_NAME, "quiesce", "637", new Object[]{l});
            Object object = this.queueLock;
            synchronized (object) {
                this.quiescing = true;
            }
            this.callback.quiesce();
            this.notifyQueueLock();
            object = this.quiesceLock;
            synchronized (object) {
                try {
                    int n = this.tokenStore.count();
                    if (n > 0 || this.pendingFlows.size() > 0 || !this.callback.isQuiesced()) {
                        this.log.fine(CLASS_NAME, "quiesce", "639", new Object[]{this.actualInFlight, this.pendingFlows.size(), this.inFlightPubRels, n});
                        this.quiesceLock.wait(l);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            object = this.queueLock;
            synchronized (object) {
                this.pendingMessages.clear();
                this.pendingFlows.clear();
                this.quiescing = false;
                this.actualInFlight = 0;
            }
            this.log.fine(CLASS_NAME, "quiesce", "640");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyQueueLock() {
        Object object = this.queueLock;
        synchronized (object) {
            this.log.fine(CLASS_NAME, "notifyQueueLock", "638");
            this.queueLock.notifyAll();
        }
    }

    protected void deliveryComplete(MqttPublish mqttPublish) throws MqttPersistenceException {
        this.log.fine(CLASS_NAME, "deliveryComplete", "641", new Object[]{mqttPublish.getMessageId()});
        this.persistence.remove(this.getReceivedPersistenceKey(mqttPublish));
        this.inboundQoS2.remove(mqttPublish.getMessageId());
    }

    protected void deliveryComplete(int n) throws MqttPersistenceException {
        this.log.fine(CLASS_NAME, "deliveryComplete", "641", new Object[]{n});
        this.persistence.remove(this.getReceivedPersistenceKey(n));
        this.inboundQoS2.remove(n);
    }

    public int getActualInFlight() {
        return this.actualInFlight;
    }

    public int getMaxInFlight() {
        return this.maxInflight;
    }

    protected void close() {
        this.inUseMsgIds.clear();
        if (this.pendingMessages != null) {
            this.pendingMessages.clear();
        }
        this.pendingFlows.clear();
        this.outboundQoS2.clear();
        this.outboundQoS1.clear();
        this.outboundQoS0.clear();
        this.inboundQoS2.clear();
        this.tokenStore.clear();
        this.inUseMsgIds = null;
        this.pendingMessages = null;
        this.pendingFlows = null;
        this.outboundQoS2 = null;
        this.outboundQoS1 = null;
        this.outboundQoS0 = null;
        this.inboundQoS2 = null;
        this.tokenStore = null;
        this.callback = null;
        this.clientComms = null;
        this.persistence = null;
        this.pingCommand = null;
        this.highResolutionTimer = null;
    }

    public Properties getDebug() {
        Properties properties = new Properties();
        properties.put("In use msgids", this.inUseMsgIds);
        properties.put("pendingMessages", this.pendingMessages);
        properties.put("pendingFlows", this.pendingFlows);
        properties.put("maxInflight", (Object)this.maxInflight);
        properties.put("nextMsgID", (Object)this.nextMsgId);
        properties.put("actualInFlight", (Object)this.actualInFlight);
        properties.put("inFlightPubRels", (Object)this.inFlightPubRels);
        properties.put("quiescing", (Object)this.quiescing);
        properties.put("pingoutstanding", (Object)this.pingOutstanding);
        properties.put("lastOutboundActivity", (Object)this.lastOutboundActivity);
        properties.put("lastInboundActivity", (Object)this.lastInboundActivity);
        properties.put("outboundQoS2", this.outboundQoS2);
        properties.put("outboundQoS1", this.outboundQoS1);
        properties.put("outboundQoS0", this.outboundQoS0);
        properties.put("inboundQoS2", this.inboundQoS2);
        properties.put("tokens", this.tokenStore);
        return properties;
    }
}

