/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.BufferedMessage;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsCallback;
import org.eclipse.paho.client.mqttv3.internal.CommsReceiver;
import org.eclipse.paho.client.mqttv3.internal.CommsSender;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.DisconnectedMessageBuffer;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.HighResolutionTimer;
import org.eclipse.paho.client.mqttv3.internal.IDiscardedBufferMessageCallback;
import org.eclipse.paho.client.mqttv3.internal.IDisconnectedBufferCallback;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class ClientComms {
    public static String VERSION = "${project.version}";
    public static String BUILD_LEVEL = "L${build.level}";
    private final String CLASS_NAME = ClientComms.class.getName();
    private final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", this.CLASS_NAME);
    private static final byte CONNECTED = 0;
    private static final byte CONNECTING = 1;
    private static final byte DISCONNECTING = 2;
    private static final byte DISCONNECTED = 3;
    private static final byte CLOSED = 4;
    private IMqttAsyncClient client;
    private int networkModuleIndex;
    private NetworkModule[] networkModules;
    private CommsReceiver receiver;
    private CommsSender sender;
    private CommsCallback callback;
    private ClientState clientState;
    private MqttConnectOptions conOptions;
    private MqttClientPersistence persistence;
    private MqttPingSender pingSender;
    private CommsTokenStore tokenStore;
    private boolean stoppingComms = false;
    private byte conState = (byte)3;
    private final Object conLock = new Object();
    private boolean closePending = false;
    private boolean resting = false;
    private DisconnectedMessageBuffer disconnectedMessageBuffer;
    private ExecutorService executorService;

    public ClientComms(IMqttAsyncClient iMqttAsyncClient, MqttClientPersistence mqttClientPersistence, MqttPingSender mqttPingSender, ExecutorService executorService, HighResolutionTimer highResolutionTimer) throws MqttException {
        this.conState = (byte)3;
        this.client = iMqttAsyncClient;
        this.persistence = mqttClientPersistence;
        this.pingSender = mqttPingSender;
        this.pingSender.init(this);
        this.executorService = executorService;
        this.tokenStore = new CommsTokenStore(this.getClient().getClientId());
        this.callback = new CommsCallback(this);
        this.clientState = new ClientState(mqttClientPersistence, this.tokenStore, this.callback, this, mqttPingSender, highResolutionTimer);
        this.callback.setClientState(this.clientState);
        this.log.setResourceName(this.getClient().getClientId());
    }

    CommsReceiver getReceiver() {
        return this.receiver;
    }

    private void shutdownExecutorService() {
        String string = "shutdownExecutorService";
        this.executorService.shutdown();
        try {
            if (this.executorService != null && this.conOptions != null && !this.executorService.awaitTermination(this.conOptions.getExecutorServiceTimeout(), TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(this.conOptions.getExecutorServiceTimeout(), TimeUnit.SECONDS)) {
                    this.log.fine(this.CLASS_NAME, string, "executorService did not terminate");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    void internalSend(MqttWireMessage mqttWireMessage, MqttToken mqttToken) throws MqttException {
        this.log.fine(this.CLASS_NAME, "internalSend", "200", new Object[]{mqttWireMessage.getKey(), mqttWireMessage, mqttToken});
        if (mqttToken.getClient() != null) {
            this.log.fine(this.CLASS_NAME, "internalSend", "213", new Object[]{mqttWireMessage.getKey(), mqttWireMessage, mqttToken});
            throw new MqttException(32201);
        }
        mqttToken.internalTok.setClient(this.getClient());
        try {
            this.clientState.send(mqttWireMessage, mqttToken);
        }
        catch (MqttException mqttException) {
            mqttToken.internalTok.setClient(null);
            if (mqttWireMessage instanceof MqttPublish) {
                this.clientState.undo((MqttPublish)mqttWireMessage);
            }
            throw mqttException;
        }
    }

    public void sendNoWait(MqttWireMessage mqttWireMessage, MqttToken mqttToken) throws MqttException {
        if (this.isConnected() || !this.isConnected() && mqttWireMessage instanceof MqttConnect || this.isDisconnecting() && mqttWireMessage instanceof MqttDisconnect) {
            if (this.disconnectedMessageBuffer != null && this.disconnectedMessageBuffer.getMessageCount() != 0) {
                this.log.fine(this.CLASS_NAME, "sendNoWait", "507", new Object[]{mqttWireMessage.getKey()});
                if (this.disconnectedMessageBuffer.isPersistBuffer()) {
                    this.clientState.persistBufferedMessage(mqttWireMessage);
                }
                this.disconnectedMessageBuffer.putMessage(mqttWireMessage, mqttToken);
            } else {
                this.internalSend(mqttWireMessage, mqttToken);
            }
        } else if (this.disconnectedMessageBuffer != null) {
            this.log.fine(this.CLASS_NAME, "sendNoWait", "508", new Object[]{mqttWireMessage.getKey()});
            if (this.disconnectedMessageBuffer.isPersistBuffer()) {
                this.clientState.persistBufferedMessage(mqttWireMessage);
            }
            this.disconnectedMessageBuffer.putMessage(mqttWireMessage, mqttToken);
        } else {
            this.log.fine(this.CLASS_NAME, "sendNoWait", "208");
            throw ExceptionHelper.createMqttException(32104);
        }
    }

    public boolean removeMessage(IMqttDeliveryToken iMqttDeliveryToken) throws MqttException {
        return this.clientState.removeMessage(iMqttDeliveryToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl) throws MqttException {
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isClosed()) {
                if (!this.isDisconnected() || bl) {
                    this.log.fine(this.CLASS_NAME, "close", "224");
                    if (this.isConnecting()) {
                        throw new MqttException(32110);
                    }
                    if (this.isConnected()) {
                        throw ExceptionHelper.createMqttException(32100);
                    }
                    if (this.isDisconnecting()) {
                        this.closePending = true;
                        return;
                    }
                }
                this.conState = (byte)4;
                this.clientState.close();
                this.clientState = null;
                this.callback = null;
                this.persistence = null;
                this.sender = null;
                this.pingSender = null;
                this.receiver = null;
                this.networkModules = null;
                this.conOptions = null;
                this.tokenStore = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MqttConnectOptions mqttConnectOptions, MqttToken mqttToken) throws MqttException {
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isDisconnected() || this.closePending) {
                this.log.fine(this.CLASS_NAME, "connect", "207", new Object[]{this.conState});
                if (this.isClosed() || this.closePending) {
                    throw new MqttException(32111);
                }
                if (this.isConnecting()) {
                    throw new MqttException(32110);
                }
                if (this.isDisconnecting()) {
                    throw new MqttException(32102);
                }
                throw ExceptionHelper.createMqttException(32100);
            }
            this.log.fine(this.CLASS_NAME, "connect", "214");
            this.conState = 1;
            this.conOptions = mqttConnectOptions;
            MqttConnect mqttConnect = new MqttConnect(this.client.getClientId(), this.conOptions.getMqttVersion(), this.conOptions.isCleanSession(), this.conOptions.getKeepAliveInterval(), this.conOptions.getUserName(), this.conOptions.getPassword(), this.conOptions.getWillMessage(), this.conOptions.getWillDestination());
            this.clientState.setKeepAliveSecs(this.conOptions.getKeepAliveInterval());
            this.clientState.setCleanSession(this.conOptions.isCleanSession());
            this.clientState.setMaxInflight(this.conOptions.getMaxInflight());
            this.tokenStore.open();
            ConnectBG connectBG = new ConnectBG(this, mqttToken, mqttConnect, this.executorService);
            connectBG.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectComplete(MqttConnack mqttConnack, MqttException mqttException) throws MqttException {
        int n = mqttConnack.getReturnCode();
        Object object = this.conLock;
        synchronized (object) {
            if (n == 0) {
                this.log.fine(this.CLASS_NAME, "connectComplete", "215");
                this.conState = 0;
                return;
            }
        }
        this.log.fine(this.CLASS_NAME, "connectComplete", "204", new Object[]{n});
        throw mqttException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownConnection(MqttToken mqttToken, MqttException mqttException) {
        boolean bl;
        MqttToken mqttToken2 = null;
        Object object = this.conLock;
        synchronized (object) {
            if (this.stoppingComms || this.closePending || this.isClosed()) {
                return;
            }
            this.stoppingComms = true;
            this.log.fine(this.CLASS_NAME, "shutdownConnection", "216");
            bl = this.isConnected() || this.isDisconnecting();
            this.conState = (byte)2;
        }
        if (mqttToken != null && !mqttToken.isComplete()) {
            mqttToken.internalTok.setException(mqttException);
        }
        if (this.callback != null) {
            this.callback.stop();
        }
        if (this.receiver != null) {
            this.receiver.stop();
        }
        try {
            if (this.networkModules != null && (object = this.networkModules[this.networkModuleIndex]) != null) {
                object.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tokenStore.quiesce(new MqttException(32102));
        mqttToken2 = this.handleOldTokens(mqttToken, mqttException);
        try {
            this.clientState.disconnected(mqttException);
            if (this.clientState.getCleanSession()) {
                this.callback.removeMessageListeners();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.sender != null) {
            this.sender.stop();
        }
        if (this.pingSender != null) {
            this.pingSender.stop();
        }
        try {
            if (this.disconnectedMessageBuffer == null && this.persistence != null) {
                this.persistence.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.conLock;
        synchronized (object) {
            this.log.fine(this.CLASS_NAME, "shutdownConnection", "217");
            this.conState = (byte)3;
            this.stoppingComms = false;
        }
        if (mqttToken2 != null && this.callback != null) {
            this.callback.asyncOperationComplete(mqttToken2);
        }
        if (bl && this.callback != null) {
            this.callback.connectionLost(mqttException);
        }
        object = this.conLock;
        synchronized (object) {
            if (this.closePending) {
                try {
                    this.close(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private MqttToken handleOldTokens(MqttToken mqttToken, MqttException mqttException) {
        this.log.fine(this.CLASS_NAME, "handleOldTokens", "222");
        MqttToken mqttToken2 = null;
        try {
            if (mqttToken != null && !mqttToken.isComplete() && this.tokenStore.getToken(mqttToken.internalTok.getKey()) == null) {
                this.tokenStore.saveToken(mqttToken, mqttToken.internalTok.getKey());
            }
            Vector vector = this.clientState.resolveOldTokens(mqttException);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                MqttToken mqttToken3 = (MqttToken)enumeration.nextElement();
                if (mqttToken3.internalTok.getKey().equals("Disc") || mqttToken3.internalTok.getKey().equals("Con")) {
                    mqttToken2 = mqttToken3;
                    continue;
                }
                this.callback.asyncOperationComplete(mqttToken3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mqttToken2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(MqttDisconnect mqttDisconnect, long l, MqttToken mqttToken) throws MqttException {
        Object object = this.conLock;
        synchronized (object) {
            if (this.isClosed()) {
                this.log.fine(this.CLASS_NAME, "disconnect", "223");
                throw ExceptionHelper.createMqttException(32111);
            }
            if (this.isDisconnected()) {
                this.log.fine(this.CLASS_NAME, "disconnect", "211");
                throw ExceptionHelper.createMqttException(32101);
            }
            if (this.isDisconnecting()) {
                this.log.fine(this.CLASS_NAME, "disconnect", "219");
                throw ExceptionHelper.createMqttException(32102);
            }
            if (Thread.currentThread() == this.callback.getThread()) {
                this.log.fine(this.CLASS_NAME, "disconnect", "210");
                throw ExceptionHelper.createMqttException(32107);
            }
            this.log.fine(this.CLASS_NAME, "disconnect", "218");
            this.conState = (byte)2;
            DisconnectBG disconnectBG = new DisconnectBG(mqttDisconnect, l, mqttToken, this.executorService);
            disconnectBG.start();
        }
    }

    public void disconnectForcibly(long l, long l2) throws MqttException {
        this.disconnectForcibly(l, l2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectForcibly(long l, long l2, boolean bl) throws MqttException {
        this.conState = (byte)2;
        if (this.clientState != null) {
            this.clientState.quiesce(l);
        }
        MqttToken mqttToken = new MqttToken(this.client.getClientId());
        try {
            if (bl) {
                this.internalSend(new MqttDisconnect(), mqttToken);
                mqttToken.waitForCompletion(l2);
            }
        }
        catch (Exception exception) {
        }
        finally {
            mqttToken.internalTok.markComplete(null, null);
            this.shutdownConnection(mqttToken, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.resting;
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.callback.setCallback(mqttCallback);
    }

    public void setReconnectCallback(MqttCallbackExtended mqttCallbackExtended) {
        this.callback.setReconnectCallback(mqttCallbackExtended);
    }

    public void setManualAcks(boolean bl) {
        this.callback.setManualAcks(bl);
    }

    public void messageArrivedComplete(int n, int n2) throws MqttException {
        this.callback.messageArrivedComplete(n, n2);
    }

    public void setMessageListener(String string, IMqttMessageListener iMqttMessageListener) {
        this.callback.setMessageListener(string, iMqttMessageListener);
    }

    public void removeMessageListener(String string) {
        this.callback.removeMessageListener(string);
    }

    protected MqttTopic getTopic(String string) {
        return new MqttTopic(string, this);
    }

    public void setNetworkModuleIndex(int n) {
        this.networkModuleIndex = n;
    }

    public int getNetworkModuleIndex() {
        return this.networkModuleIndex;
    }

    public NetworkModule[] getNetworkModules() {
        return this.networkModules;
    }

    public void setNetworkModules(NetworkModule[] networkModuleArray) {
        this.networkModules = (NetworkModule[])networkModuleArray.clone();
    }

    public MqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.tokenStore.getOutstandingDelTokens();
    }

    protected void deliveryComplete(MqttPublish mqttPublish) throws MqttPersistenceException {
        this.clientState.deliveryComplete(mqttPublish);
    }

    protected void deliveryComplete(int n) throws MqttPersistenceException {
        this.clientState.deliveryComplete(n);
    }

    public IMqttAsyncClient getClient() {
        return this.client;
    }

    public long getKeepAlive() {
        return this.clientState.getKeepAlive();
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public MqttConnectOptions getConOptions() {
        return this.conOptions;
    }

    public Properties getDebug() {
        Properties properties = new Properties();
        properties.put("conState", (Object)this.conState);
        properties.put("serverURI", this.getClient().getServerURI());
        properties.put("callback", this.callback);
        properties.put("stoppingComms", (Object)this.stoppingComms);
        return properties;
    }

    public MqttToken checkForActivity() {
        return this.checkForActivity(null);
    }

    public MqttToken checkForActivity(IMqttActionListener iMqttActionListener) {
        MqttToken mqttToken = null;
        try {
            mqttToken = this.clientState.checkForActivity(iMqttActionListener);
        }
        catch (MqttException mqttException) {
            this.handleRunException(mqttException);
        }
        catch (Exception exception) {
            this.handleRunException(exception);
        }
        return mqttToken;
    }

    private void handleRunException(Exception exception) {
        this.log.fine(this.CLASS_NAME, "handleRunException", "804", null, exception);
        MqttException mqttException = !(exception instanceof MqttException) ? new MqttException(32109, (Throwable)exception) : (MqttException)exception;
        this.shutdownConnection(null, mqttException);
    }

    public void setRestingState(boolean bl) {
        this.resting = bl;
    }

    public void setDisconnectedMessageBuffer(DisconnectedMessageBuffer disconnectedMessageBuffer) {
        this.disconnectedMessageBuffer = disconnectedMessageBuffer;
    }

    public int getBufferedMessageCount() {
        return this.disconnectedMessageBuffer.getMessageCount();
    }

    public MqttMessage getBufferedMessage(int n) {
        MqttPublish mqttPublish = (MqttPublish)this.disconnectedMessageBuffer.getMessage(n).getMessage();
        return mqttPublish.getMessage();
    }

    public void deleteBufferedMessage(int n) {
        this.disconnectedMessageBuffer.deleteMessage(n);
    }

    public void notifyConnect() {
        if (this.disconnectedMessageBuffer != null) {
            this.log.fine(this.CLASS_NAME, "notifyConnect", "509", null);
            this.disconnectedMessageBuffer.setPublishCallback(new ReconnectDisconnectedBufferCallback("notifyConnect"));
            this.disconnectedMessageBuffer.setMessageDiscardedCallBack(new MessageDiscardedCallback());
            if (this.executorService == null) {
                new Thread(this.disconnectedMessageBuffer).start();
            } else {
                this.executorService.execute(this.disconnectedMessageBuffer);
            }
        }
    }

    public int getActualInFlight() {
        return this.clientState.getActualInFlight();
    }

    class ReconnectDisconnectedBufferCallback
    implements IDisconnectedBufferCallback {
        final String methodName;

        ReconnectDisconnectedBufferCallback(String string) {
            this.methodName = string;
        }

        @Override
        public void publishBufferedMessage(BufferedMessage bufferedMessage) throws MqttException {
            if (ClientComms.this.isConnected()) {
                while (ClientComms.this.clientState.getActualInFlight() >= ClientComms.this.clientState.getMaxInFlight() - 3) {
                    Thread.yield();
                }
            } else {
                ClientComms.this.log.fine(ClientComms.this.CLASS_NAME, this.methodName, "208");
                throw ExceptionHelper.createMqttException(32104);
            }
            ClientComms.this.log.fine(ClientComms.this.CLASS_NAME, this.methodName, "510", new Object[]{bufferedMessage.getMessage().getKey()});
            ClientComms.this.internalSend(bufferedMessage.getMessage(), bufferedMessage.getToken());
            ClientComms.this.clientState.unPersistBufferedMessage(bufferedMessage.getMessage());
        }
    }

    class MessageDiscardedCallback
    implements IDiscardedBufferMessageCallback {
        MessageDiscardedCallback() {
        }

        @Override
        public void messageDiscarded(MqttWireMessage mqttWireMessage) {
            if (ClientComms.this.disconnectedMessageBuffer.isPersistBuffer()) {
                ClientComms.this.clientState.unPersistBufferedMessage(mqttWireMessage);
            }
        }
    }

    private class DisconnectBG
    implements Runnable {
        MqttDisconnect disconnect;
        long quiesceTimeout;
        MqttToken token;
        private String threadName;

        DisconnectBG(MqttDisconnect mqttDisconnect, long l, MqttToken mqttToken, ExecutorService executorService) {
            this.disconnect = mqttDisconnect;
            this.quiesceTimeout = l;
            this.token = mqttToken;
        }

        void start() {
            this.threadName = "MQTT Disc: " + ClientComms.this.getClient().getClientId();
            if (ClientComms.this.executorService == null) {
                new Thread(this).start();
            } else {
                ClientComms.this.executorService.execute(this);
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName(this.threadName);
            ClientComms.this.log.fine(ClientComms.this.CLASS_NAME, "disconnectBG:run", "221");
            ClientComms.this.clientState.quiesce(this.quiesceTimeout);
            try {
                ClientComms.this.internalSend(this.disconnect, this.token);
                if (ClientComms.this.sender != null && ClientComms.this.sender.isRunning()) {
                    this.token.internalTok.waitUntilSent();
                }
            }
            catch (MqttException mqttException) {
            }
            finally {
                this.token.internalTok.markComplete(null, null);
                if (ClientComms.this.sender == null || !ClientComms.this.sender.isRunning()) {
                    this.token.internalTok.notifyComplete();
                }
                ClientComms.this.shutdownConnection(this.token, null);
            }
        }
    }

    private class ConnectBG
    implements Runnable {
        ClientComms clientComms = null;
        MqttToken conToken;
        MqttConnect conPacket;
        private String threadName;

        ConnectBG(ClientComms clientComms2, MqttToken mqttToken, MqttConnect mqttConnect, ExecutorService executorService) {
            this.clientComms = clientComms2;
            this.conToken = mqttToken;
            this.conPacket = mqttConnect;
            this.threadName = "MQTT Con: " + ClientComms.this.getClient().getClientId();
        }

        void start() {
            if (ClientComms.this.executorService == null) {
                new Thread(this).start();
            } else {
                ClientComms.this.executorService.execute(this);
            }
        }

        @Override
        public void run() {
            Thread.currentThread().setName(this.threadName);
            MqttException mqttException = null;
            ClientComms.this.log.fine(ClientComms.this.CLASS_NAME, "connectBG:run", "220");
            try {
                MqttDeliveryToken[] mqttDeliveryTokenArray = ClientComms.this.tokenStore.getOutstandingDelTokens();
                for (MqttDeliveryToken mqttDeliveryToken : mqttDeliveryTokenArray) {
                    mqttDeliveryToken.internalTok.setException(null);
                }
                ClientComms.this.tokenStore.saveToken(this.conToken, this.conPacket);
                NetworkModule networkModule = ClientComms.this.networkModules[ClientComms.this.networkModuleIndex];
                networkModule.start();
                ClientComms.this.receiver = new CommsReceiver(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getInputStream());
                ClientComms.this.receiver.start("MQTT Rec: " + ClientComms.this.getClient().getClientId(), ClientComms.this.executorService);
                ClientComms.this.sender = new CommsSender(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getOutputStream());
                ClientComms.this.sender.start("MQTT Snd: " + ClientComms.this.getClient().getClientId(), ClientComms.this.executorService);
                ClientComms.this.callback.start("MQTT Call: " + ClientComms.this.getClient().getClientId(), ClientComms.this.executorService);
                ClientComms.this.internalSend(this.conPacket, this.conToken);
            }
            catch (MqttException mqttException2) {
                ClientComms.this.log.fine(ClientComms.this.CLASS_NAME, "connectBG:run", "212", null, mqttException2);
                mqttException = mqttException2;
            }
            catch (Exception exception) {
                ClientComms.this.log.fine(ClientComms.this.CLASS_NAME, "connectBG:run", "209", null, exception);
                mqttException = ExceptionHelper.createMqttException(exception);
            }
            if (mqttException != null) {
                ClientComms.this.shutdownConnection(this.conToken, mqttException);
            }
        }
    }
}

