/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.io.UnsupportedEncodingException;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.util.Strings;

public class MqttTopic {
    public static final String TOPIC_LEVEL_SEPARATOR = "/";
    public static final String MULTI_LEVEL_WILDCARD = "#";
    public static final String SINGLE_LEVEL_WILDCARD = "+";
    public static final String MULTI_LEVEL_WILDCARD_PATTERN = "/#";
    public static final String TOPIC_WILDCARDS = "#+";
    private static final int MIN_TOPIC_LEN = 1;
    private static final int MAX_TOPIC_LEN = 65535;
    private static final char NUL = '\u0000';
    private ClientComms comms;
    private String name;

    public MqttTopic(String string, ClientComms clientComms) {
        this.comms = clientComms;
        this.name = string;
    }

    public MqttDeliveryToken publish(byte[] byArray, int n, boolean bl) throws MqttException, MqttPersistenceException {
        MqttMessage mqttMessage = new MqttMessage(byArray);
        mqttMessage.setQos(n);
        mqttMessage.setRetained(bl);
        return this.publish(mqttMessage);
    }

    public MqttDeliveryToken publish(MqttMessage mqttMessage) throws MqttException, MqttPersistenceException {
        MqttDeliveryToken mqttDeliveryToken = new MqttDeliveryToken(this.comms.getClient().getClientId());
        mqttDeliveryToken.setMessage(mqttMessage);
        this.comms.sendNoWait(this.createPublish(mqttMessage), mqttDeliveryToken);
        mqttDeliveryToken.internalTok.waitUntilSent();
        return mqttDeliveryToken;
    }

    public String getName() {
        return this.name;
    }

    private MqttPublish createPublish(MqttMessage mqttMessage) {
        return new MqttPublish(this.getName(), mqttMessage);
    }

    public String toString() {
        return this.getName();
    }

    public static void validate(String string, boolean bl) throws IllegalArgumentException {
        int n = 0;
        try {
            n = string.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException.getMessage());
        }
        if (n < 1 || n > 65535) {
            throw new IllegalArgumentException(String.format("Invalid topic length, should be in range[%d, %d]!", 1, 65535));
        }
        if (bl) {
            if (Strings.equalsAny(string, new String[]{MULTI_LEVEL_WILDCARD, SINGLE_LEVEL_WILDCARD})) {
                return;
            }
            if (Strings.countMatches(string, MULTI_LEVEL_WILDCARD) > 1 || string.contains(MULTI_LEVEL_WILDCARD) && !string.endsWith(MULTI_LEVEL_WILDCARD_PATTERN)) {
                throw new IllegalArgumentException("Invalid usage of multi-level wildcard in topic string: " + string);
            }
            MqttTopic.validateSingleLevelWildcard(string);
            return;
        }
        if (Strings.containsAny((CharSequence)string, TOPIC_WILDCARDS)) {
            throw new IllegalArgumentException("The topic name MUST NOT contain any wildcard characters (#+)");
        }
    }

    private static void validateSingleLevelWildcard(String string) {
        char c = SINGLE_LEVEL_WILDCARD.charAt(0);
        char c2 = TOPIC_LEVEL_SEPARATOR.charAt(0);
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        char c3 = '\u0000';
        char c4 = '\u0000';
        for (int i = 0; i < n; ++i) {
            c3 = i - 1 >= 0 ? cArray[i - 1] : (char)'\u0000';
            char c5 = c4 = i + 1 < n ? cArray[i + 1] : (char)'\u0000';
            if (cArray[i] != c || (c3 == c2 || c3 == '\u0000') && (c4 == c2 || c4 == '\u0000')) continue;
            throw new IllegalArgumentException(String.format("Invalid usage of single-level wildcard in topic string '%s'!", string));
        }
    }

    public static boolean isMatched(String string, String string2) throws IllegalArgumentException {
        int n;
        int n2 = 0;
        int n3 = string2.length();
        int n4 = string.length();
        MqttTopic.validate(string, true);
        MqttTopic.validate(string2, false);
        if (string.equals(string2)) {
            return true;
        }
        for (n = 0; n < n4 && n2 < n3; ++n, ++n2) {
            if (string.charAt(n) == '#') {
                n2 = n3;
                n = n4;
                break;
            }
            if (string2.charAt(n2) == '/' && string.charAt(n) != '/' || string.charAt(n) != '+' && string.charAt(n) != '#' && string.charAt(n) != string2.charAt(n2)) break;
            if (string.charAt(n) != '+') continue;
            int n5 = n2 + 1;
            while (n5 < n3 && string2.charAt(n5) != '/') {
                n5 = ++n2 + 1;
            }
        }
        if (n2 == n3 && n == n4) {
            return true;
        }
        if (string.length() - n > 0 && n2 == n3) {
            if (string2.charAt(n2 - 1) == '/' && string.charAt(n) == '#') {
                return true;
            }
            if (string.length() - n > 1 && string.substring(n, n + 2).equals(MULTI_LEVEL_WILDCARD_PATTERN)) {
                return true;
            }
        }
        return false;
    }
}

