/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

public class MqttMessage {
    private boolean mutable = true;
    private byte[] payload;
    private int qos = 1;
    private boolean retained = false;
    private boolean dup = false;
    private int messageId;

    public static void validateQos(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException();
        }
    }

    public MqttMessage() {
        this.setPayload(new byte[0]);
    }

    public MqttMessage(byte[] byArray) {
        this.setPayload(byArray);
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void clearPayload() {
        this.checkMutable();
        this.payload = new byte[0];
    }

    public void setPayload(byte[] byArray) {
        this.checkMutable();
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.payload = (byte[])byArray.clone();
    }

    public boolean isRetained() {
        return this.retained;
    }

    public void setRetained(boolean bl) {
        this.checkMutable();
        this.retained = bl;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int n) {
        this.checkMutable();
        MqttMessage.validateQos(n);
        this.qos = n;
    }

    public String toString() {
        return new String(this.payload);
    }

    protected void setMutable(boolean bl) {
        this.mutable = bl;
    }

    protected void checkMutable() throws IllegalStateException {
        if (!this.mutable) {
            throw new IllegalStateException();
        }
    }

    protected void setDuplicate(boolean bl) {
        this.dup = bl;
    }

    public boolean isDuplicate() {
        return this.dup;
    }

    public void setId(int n) {
        this.messageId = n;
    }

    public int getId() {
        return this.messageId;
    }
}

