/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.ScheduledExecutorPingSender;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.eclipse.paho.client.mqttv3.util.Debug;

public class MqttClient
implements IMqttClient {
    protected MqttAsyncClient aClient = null;
    protected long timeToWait = -1L;

    public MqttClient(String string, String string2) throws MqttException {
        this(string, string2, new MqttDefaultFilePersistence());
    }

    public MqttClient(String string, String string2, MqttClientPersistence mqttClientPersistence) throws MqttException {
        this.aClient = new MqttAsyncClient(string, string2, mqttClientPersistence);
    }

    public MqttClient(String string, String string2, MqttClientPersistence mqttClientPersistence, ScheduledExecutorService scheduledExecutorService) throws MqttException {
        this.aClient = new MqttAsyncClient(string, string2, mqttClientPersistence, new ScheduledExecutorPingSender(scheduledExecutorService), scheduledExecutorService);
    }

    @Override
    public void connect() throws MqttSecurityException, MqttException {
        this.connect(new MqttConnectOptions());
    }

    @Override
    public void connect(MqttConnectOptions mqttConnectOptions) throws MqttSecurityException, MqttException {
        this.aClient.connect(mqttConnectOptions, null, null).waitForCompletion(this.getTimeToWait());
    }

    @Override
    public IMqttToken connectWithResult(MqttConnectOptions mqttConnectOptions) throws MqttSecurityException, MqttException {
        IMqttToken iMqttToken = this.aClient.connect(mqttConnectOptions, null, null);
        iMqttToken.waitForCompletion(this.getTimeToWait());
        return iMqttToken;
    }

    @Override
    public void disconnect() throws MqttException {
        this.aClient.disconnect().waitForCompletion();
    }

    @Override
    public void disconnect(long l) throws MqttException {
        this.aClient.disconnect(l, null, null).waitForCompletion();
    }

    @Override
    public void disconnectForcibly() throws MqttException {
        this.aClient.disconnectForcibly();
    }

    @Override
    public void disconnectForcibly(long l) throws MqttException {
        this.aClient.disconnectForcibly(l);
    }

    @Override
    public void disconnectForcibly(long l, long l2) throws MqttException {
        this.aClient.disconnectForcibly(l, l2);
    }

    public void disconnectForcibly(long l, long l2, boolean bl) throws MqttException {
        this.aClient.disconnectForcibly(l, l2, bl);
    }

    @Override
    public void subscribe(String string) throws MqttException {
        this.subscribe(new String[]{string}, new int[]{1});
    }

    @Override
    public void subscribe(String[] stringArray) throws MqttException {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 1;
        }
        this.subscribe(stringArray, nArray);
    }

    @Override
    public void subscribe(String string, int n) throws MqttException {
        this.subscribe(new String[]{string}, new int[]{n});
    }

    @Override
    public void subscribe(String[] stringArray, int[] nArray) throws MqttException {
        this.subscribe(stringArray, nArray, null);
    }

    @Override
    public void subscribe(String string, IMqttMessageListener iMqttMessageListener) throws MqttException {
        this.subscribe(new String[]{string}, new int[]{1}, new IMqttMessageListener[]{iMqttMessageListener});
    }

    @Override
    public void subscribe(String[] stringArray, IMqttMessageListener[] iMqttMessageListenerArray) throws MqttException {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 1;
        }
        this.subscribe(stringArray, nArray, iMqttMessageListenerArray);
    }

    @Override
    public void subscribe(String string, int n, IMqttMessageListener iMqttMessageListener) throws MqttException {
        this.subscribe(new String[]{string}, new int[]{n}, new IMqttMessageListener[]{iMqttMessageListener});
    }

    @Override
    public void subscribe(String[] stringArray, int[] nArray, IMqttMessageListener[] iMqttMessageListenerArray) throws MqttException {
        IMqttToken iMqttToken = this.aClient.subscribe(stringArray, nArray, null, null, iMqttMessageListenerArray);
        iMqttToken.waitForCompletion(this.getTimeToWait());
        int[] nArray2 = iMqttToken.getGrantedQos();
        for (int i = 0; i < nArray2.length; ++i) {
            nArray[i] = nArray2[i];
        }
        if (nArray2.length == 1 && nArray[0] == 128) {
            throw new MqttException(128);
        }
    }

    @Override
    public IMqttToken subscribeWithResponse(String string) throws MqttException {
        return this.subscribeWithResponse(new String[]{string}, new int[]{1});
    }

    @Override
    public IMqttToken subscribeWithResponse(String string, IMqttMessageListener iMqttMessageListener) throws MqttException {
        return this.subscribeWithResponse(new String[]{string}, new int[]{1}, new IMqttMessageListener[]{iMqttMessageListener});
    }

    @Override
    public IMqttToken subscribeWithResponse(String string, int n) throws MqttException {
        return this.subscribeWithResponse(new String[]{string}, new int[]{n});
    }

    @Override
    public IMqttToken subscribeWithResponse(String string, int n, IMqttMessageListener iMqttMessageListener) throws MqttException {
        return this.subscribeWithResponse(new String[]{string}, new int[]{n}, new IMqttMessageListener[]{iMqttMessageListener});
    }

    @Override
    public IMqttToken subscribeWithResponse(String[] stringArray) throws MqttException {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 1;
        }
        return this.subscribeWithResponse(stringArray, nArray);
    }

    @Override
    public IMqttToken subscribeWithResponse(String[] stringArray, IMqttMessageListener[] iMqttMessageListenerArray) throws MqttException {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 1;
        }
        return this.subscribeWithResponse(stringArray, nArray, iMqttMessageListenerArray);
    }

    @Override
    public IMqttToken subscribeWithResponse(String[] stringArray, int[] nArray) throws MqttException {
        return this.subscribeWithResponse(stringArray, nArray, null);
    }

    @Override
    public IMqttToken subscribeWithResponse(String[] stringArray, int[] nArray, IMqttMessageListener[] iMqttMessageListenerArray) throws MqttException {
        IMqttToken iMqttToken = this.aClient.subscribe(stringArray, nArray, null, null, iMqttMessageListenerArray);
        iMqttToken.waitForCompletion(this.getTimeToWait());
        return iMqttToken;
    }

    @Override
    public void unsubscribe(String string) throws MqttException {
        this.unsubscribe(new String[]{string});
    }

    @Override
    public void unsubscribe(String[] stringArray) throws MqttException {
        this.aClient.unsubscribe(stringArray, null, null).waitForCompletion(this.getTimeToWait());
    }

    @Override
    public void publish(String string, byte[] byArray, int n, boolean bl) throws MqttException, MqttPersistenceException {
        MqttMessage mqttMessage = new MqttMessage(byArray);
        mqttMessage.setQos(n);
        mqttMessage.setRetained(bl);
        this.publish(string, mqttMessage);
    }

    @Override
    public void publish(String string, MqttMessage mqttMessage) throws MqttException, MqttPersistenceException {
        this.aClient.publish(string, mqttMessage, null, null).waitForCompletion(this.getTimeToWait());
    }

    public void setTimeToWait(long l) throws IllegalArgumentException {
        if (l < -1L) {
            throw new IllegalArgumentException();
        }
        this.timeToWait = l;
    }

    public long getTimeToWait() {
        return this.timeToWait;
    }

    @Override
    public void close() throws MqttException {
        this.aClient.close(false);
    }

    public void close(boolean bl) throws MqttException {
        this.aClient.close(bl);
    }

    @Override
    public String getClientId() {
        return this.aClient.getClientId();
    }

    @Override
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.aClient.getPendingDeliveryTokens();
    }

    @Override
    public String getServerURI() {
        return this.aClient.getServerURI();
    }

    public String getCurrentServerURI() {
        return this.aClient.getCurrentServerURI();
    }

    @Override
    public MqttTopic getTopic(String string) {
        return this.aClient.getTopic(string);
    }

    @Override
    public boolean isConnected() {
        return this.aClient.isConnected();
    }

    @Override
    public void setCallback(MqttCallback mqttCallback) {
        this.aClient.setCallback(mqttCallback);
    }

    @Override
    public void setManualAcks(boolean bl) {
        this.aClient.setManualAcks(bl);
    }

    @Override
    public void messageArrivedComplete(int n, int n2) throws MqttException {
        this.aClient.messageArrivedComplete(n, n2);
    }

    public static String generateClientId() {
        return MqttAsyncClient.generateClientId();
    }

    @Override
    public void reconnect() throws MqttException {
        this.aClient.reconnect();
    }

    public Debug getDebug() {
        return this.aClient.getDebug();
    }
}

