/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.server;

import certa.modbus.ModbusPdu;
import certa.modbus.server.DefaultRequestProcessor;
import certa.modbus.server.ModbusWriteHandler;
import certa.modbus.server.RegistersTable;
import certa.modbus.server.RequestProcessor;
import org.slf4j.Logger;

public abstract class AModbusServer {
    public final RegistersTable inputs;
    public final RegistersTable coils;
    public final RegistersTable iregs;
    public final RegistersTable hregs;
    public final RequestProcessor processor;
    final Logger log = this.getLog();
    protected ModbusWriteHandler handler;

    public AModbusServer(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, RequestProcessor requestProcessor) {
        this.inputs = new RegistersTable(n, n2);
        this.coils = new RegistersTable(n3, n4);
        this.iregs = new RegistersTable(n5, n6);
        this.hregs = new RegistersTable(n7, n8);
        this.processor = requestProcessor != null ? requestProcessor : new DefaultRequestProcessor(this);
    }

    public void setWriteHandler(ModbusWriteHandler modbusWriteHandler) {
        this.handler = modbusWriteHandler;
    }

    public void logData(String string, byte[] byArray, int n, int n2) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(string + ModbusPdu.toHex(byArray, n, n2));
        }
    }

    protected abstract Logger getLog();

    public abstract void Start();

    public abstract void Stop();
}

