/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus;

public class ModbusPdu {
    protected final byte[] pdu = new byte[253];
    protected int pduSize;
    private static final int[] CrcTable = new int[]{0, 49345, 49537, 320, 49921, 960, 640, 49729, 50689, 1728, 1920, 51009, 1280, 50625, 50305, 1088, 52225, 3264, 3456, 52545, 3840, 53185, 52865, 3648, 2560, 51905, 52097, 2880, 51457, 2496, 2176, 51265, 55297, 6336, 6528, 55617, 6912, 56257, 55937, 6720, 7680, 57025, 57217, 8000, 56577, 7616, 7296, 56385, 5120, 54465, 54657, 5440, 55041, 6080, 5760, 54849, 53761, 4800, 4992, 54081, 4352, 53697, 53377, 4160, 61441, 12480, 12672, 61761, 13056, 62401, 62081, 12864, 13824, 63169, 63361, 14144, 62721, 13760, 13440, 62529, 15360, 64705, 64897, 15680, 65281, 16320, 16000, 65089, 64001, 15040, 15232, 64321, 14592, 63937, 63617, 14400, 10240, 59585, 59777, 10560, 60161, 11200, 10880, 59969, 60929, 11968, 12160, 61249, 11520, 60865, 60545, 11328, 58369, 9408, 9600, 58689, 9984, 59329, 59009, 9792, 8704, 58049, 58241, 9024, 57601, 8640, 8320, 57409, 40961, 24768, 24960, 41281, 25344, 41921, 41601, 25152, 26112, 42689, 42881, 26432, 42241, 26048, 25728, 42049, 27648, 44225, 44417, 27968, 44801, 28608, 28288, 44609, 43521, 27328, 27520, 43841, 26880, 43457, 43137, 26688, 30720, 47297, 47489, 31040, 47873, 31680, 31360, 47681, 48641, 32448, 32640, 48961, 32000, 48577, 48257, 31808, 46081, 29888, 30080, 46401, 30464, 47041, 46721, 30272, 29184, 45761, 45953, 29504, 45313, 29120, 28800, 45121, 20480, 37057, 37249, 20800, 37633, 21440, 21120, 37441, 38401, 22208, 22400, 38721, 21760, 38337, 38017, 21568, 39937, 23744, 23936, 40257, 24320, 40897, 40577, 24128, 23040, 39617, 39809, 23360, 39169, 22976, 22656, 38977, 34817, 18624, 18816, 35137, 19200, 35777, 35457, 19008, 19968, 36545, 36737, 20288, 36097, 19904, 19584, 35905, 17408, 33985, 34177, 17728, 34561, 18368, 18048, 34369, 33281, 17088, 17280, 33601, 16640, 33217, 32897, 16448};

    public static final String toHex(byte[] byArray, int n, int n2) {
        if (byArray.length == 0 || n > byArray.length || n2 < n) {
            return "";
        }
        n2 = Math.min(byArray.length - n, n2);
        StringBuffer stringBuffer = new StringBuffer(n2 * 3);
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[i + n] & 0xFF;
            stringBuffer.append(Integer.toHexString(n3 >>> 4));
            stringBuffer.append(Integer.toHexString(n3 & 0xF));
            if (i >= n2 - 1) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static final String byteToHex(byte by) {
        int n = by & 0xFF;
        return Integer.toHexString(n >>> 4) + Integer.toHexString(n & 0xF);
    }

    public static final int calcCRC16(byte[] byArray, int n, int n2) {
        int n3 = 65535;
        for (int i = 0; i < n2; ++i) {
            n3 = n3 >>> 8 ^ CrcTable[(n3 ^ byArray[n + i]) & 0xFF];
        }
        return n3;
    }

    public static final int bytesToInt16(byte by, byte by2, boolean bl) {
        int n = by2 << 8 | by & 0xFF;
        if (bl) {
            return n & 0xFFFF;
        }
        return n;
    }

    public static final int ints16ToInt32(int n, int n2) {
        return n2 << 16 | n & 0xFFFF;
    }

    public static final float ints16ToFloat(int n, int n2) {
        return Float.intBitsToFloat(ModbusPdu.ints16ToInt32(n, n2));
    }

    public static final byte highByte(int n) {
        return (byte)(n >>> 8);
    }

    public static final byte lowByte(int n) {
        return (byte)n;
    }

    public static final int highInt16(int n) {
        return n >> 16;
    }

    public static final int lowInt16(int n) {
        return (n & 0xFFFF) << 16 >> 16;
    }

    public static final boolean[] int16ToBits(int n) {
        boolean[] blArray = new boolean[16];
        int n2 = 0;
        while (n2 < 16) {
            blArray[n2] = (n & 1) != 0;
            ++n2;
            n >>= 1;
        }
        return blArray;
    }

    public static final int bytesCount(int n) {
        int n2 = n / 8;
        if (n % 8 != 0) {
            ++n2;
        }
        return n2;
    }

    public void setPduSize(int n) {
        if (n < 1 || n > 253) {
            throw new IllegalArgumentException("Invalid PDU size: " + n);
        }
        this.pduSize = n;
    }

    public int getPduSize() {
        return this.pduSize;
    }

    public int getFunction() {
        return this.readByteFromPDU(0, true);
    }

    public void setFunction(int n) {
        this.writeByteToPDU(0, (byte)n);
    }

    public void readFromPdu(int n, int n2, byte[] byArray, int n3) {
        System.arraycopy(this.pdu, n, byArray, n3, n2);
    }

    public void writeToPdu(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(byArray, n, this.pdu, n3, n2);
    }

    public void writeByteToPDU(int n, byte by) {
        if (n < 0 || n >= this.pduSize) {
            throw new IndexOutOfBoundsException();
        }
        this.pdu[n] = by;
    }

    public void writeInt16ToPDU(int n, int n2) {
        if (n < 1 || n >= this.pduSize - 1) {
            throw new IndexOutOfBoundsException();
        }
        this.pdu[n] = ModbusPdu.highByte(n2);
        this.pdu[n + 1] = ModbusPdu.lowByte(n2);
    }

    public void writeBitToPDU(int n, int n2, boolean bl) {
        int n3 = n + n2 / 8;
        byte by = this.readByteFromPDU(n3);
        by = bl ? (byte)(by | 1 << n2 % 8) : (byte)(by & ~(1 << n2 % 8));
        this.writeByteToPDU(n3, by);
    }

    public int readByteFromPDU(int n, boolean bl) {
        if (bl) {
            return this.readByteFromPDU(n) & 0xFF;
        }
        return this.readByteFromPDU(n);
    }

    public byte readByteFromPDU(int n) {
        if (n < 0 || n >= this.pduSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.pdu[n];
    }

    public int readInt16FromPDU(int n, boolean bl) {
        if (n < 1 || n >= this.pduSize - 1) {
            throw new IndexOutOfBoundsException();
        }
        return ModbusPdu.bytesToInt16(this.pdu[n + 1], this.pdu[n], bl);
    }

    protected int readInt32FromPDU(int n, boolean bl) {
        if (bl) {
            return ModbusPdu.ints16ToInt32(this.readInt16FromPDU(n + 2, false), this.readInt16FromPDU(n, false));
        }
        return ModbusPdu.ints16ToInt32(this.readInt16FromPDU(n, false), this.readInt16FromPDU(n + 2, false));
    }

    protected float readFloatFromPDU(int n, boolean bl) {
        return Float.intBitsToFloat(this.readInt32FromPDU(n, bl));
    }

    public boolean readBitFromPDU(int n, int n2) {
        byte by = this.readByteFromPDU(n + n2 / 8);
        return (by & 1 << n2 % 8) != 0;
    }
}

