/*
 * Decompiled with CFR 0.152.
 */
package certa.mentor.tool;

import certa.mentor.tool.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;

public class PropertiesFile {
    private Path path;
    private Properties props;

    public PropertiesFile(String string) {
        this.loadFile(new File(string));
    }

    public PropertiesFile(URL uRL) {
        File file = null;
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            Utils.ProcessException(uRISyntaxException, uRL.toString(), false);
        }
        this.loadFile(file);
    }

    protected void loadFile(File file) {
        try {
            file.createNewFile();
            this.path = file.toPath().toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            this.path = null;
            Utils.ProcessException(iOException, "Cannot create: " + file.getPath(), false);
        }
        this.props = new Properties();
        if (this.path != null) {
            try (FileInputStream fileInputStream = new FileInputStream(this.path.toString());){
                this.props.load(fileInputStream);
            }
            catch (IOException iOException) {
                Utils.ProcessException(iOException, "Load error: " + this.path.toString(), false);
            }
        }
    }

    private void saveData() {
        if (this.path != null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.path.toString());){
                this.props.store(fileOutputStream, "Do not modify this file while program runs. Changes will be lost.");
            }
            catch (IOException iOException) {
                Utils.ProcessException(iOException, "Write error: " + this.path.toString(), false);
            }
        }
    }

    public synchronized String getString(String string, String string2) {
        return this.props.getProperty(string, string2);
    }

    public synchronized double getDouble(String string, double d) {
        String string2 = this.props.getProperty(string, null);
        double d2 = d;
        if (string2 != null && Double.isNaN(d2 = Utils.StringToDouble(string2))) {
            Utils.ProcessError("Invalid double number: " + string + " = " + string2 + " in " + this.path.toString(), false);
            return d;
        }
        return d2;
    }

    public synchronized int getInt(String string, int n) {
        String string2 = this.props.getProperty(string, null);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Utils.ProcessError("Invalid double number: " + string + " = " + string2 + " in " + this.path.toString(), false);
                return n;
            }
        }
        return n;
    }

    public synchronized boolean getBool(String string, boolean bl) {
        String string2 = this.props.getProperty(string, bl ? "1" : "").toUpperCase();
        return string2.equals("TRUE") || string2.equals("YES") || string2.equals("1");
    }

    public synchronized void saveString(String string, String string2) {
        this.props.setProperty(string, string2 != null ? string2 : "");
        this.saveData();
    }

    public synchronized void saveDouble(String string, double d) {
        this.props.setProperty(string, Double.toString(d));
        this.saveData();
    }

    public synchronized void saveInt(String string, int n) {
        this.props.setProperty(string, Integer.toString(n));
        this.saveData();
    }

    public synchronized void saveBool(String string, boolean bl) {
        this.props.setProperty(string, bl ? "1" : "0");
        this.saveData();
    }
}

