/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.util;

import certa.modbus.client.RtuTransportJSerialComm;
import certa.vics.modbus.VicsModbusClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryTool {
    private static final Logger log = LoggerFactory.getLogger(MemoryTool.class);
    static final String[] MEM_TYPES = new String[]{"RAM", "EEPROM", "NVRAM", "FLASH", "Ext.EEPROM"};
    final String comPort;
    final int speed;
    final int id;
    final int model;
    final int firmware;
    private static final int CHUNK_SIZE = 244;

    public MemoryTool(String comPort, int speed, int id, int model, int firmware) {
        this.comPort = comPort;
        this.speed = speed;
        this.id = id;
        this.model = model;
        this.firmware = firmware;
    }

    public void setWriteMode(VicsModbusClient mc, int id, int password, boolean writeMode) throws Exception {
    }

    private int chunksCount(int bytesCount) {
        int i = bytesCount / 244;
        if (bytesCount % 244 > 0) {
            ++i;
        }
        return i;
    }

    private void readChunk(VicsModbusClient mc, int id, int model, int firmware, int memType, int chunk, byte[] buf, int memStart) throws Exception {
        int offset = chunk * 244;
        int size = Math.min(244, buf.length - offset);
        int memAddr = memStart + offset;
        System.out.println("Read part " + (chunk + 1) + " at " + memAddr + ", " + size + " bytes");
        mc.InitReadMemRequest(id, model, firmware, memType, memAddr, size);
        if (!mc.execRequest()) {
            throw new Exception(mc.getResultAsString());
        }
        mc.readFromPdu(2, size, buf, offset);
    }

    private void read(VicsModbusClient mc, int id, int model, int firmware, int memType, byte[] buf, int memStart) throws Exception {
        for (int i = 0; i < this.chunksCount(buf.length); ++i) {
            this.readChunk(mc, id, model, firmware, memType, i, buf, memStart);
        }
        System.out.println("OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBinFile(byte[] data, String fileName) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(fileName);){
            stream.write(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readMemoryToFile(int memType, int addr, int size, String fileName) throws Exception {
        System.out.println();
        System.out.println("Read " + MEM_TYPES[memType] + " at address " + addr + ", size " + size + " (" + this.comPort + ", " + this.speed + ", id:" + this.id + ", model=" + this.model + ", fw=" + this.firmware + ").");
        System.out.println(fileName);
        System.out.println("Press Ctrl+C to break.");
        System.out.println();
        byte[] data = new byte[size];
        boolean ok = false;
        try (VicsModbusClient mc = new VicsModbusClient();){
            mc.setTransport(new RtuTransportJSerialComm(this.comPort, this.speed, 8, 0, 2, 1000, 20));
            System.out.println("Reading " + MEM_TYPES[memType] + "...");
            this.read(mc, this.id, this.model, this.firmware, memType, data, addr);
            ok = true;
        }
        if (ok) {
            System.out.println("Saving file " + fileName);
            this.saveBinFile(data, fileName);
            System.out.println("DONE!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readSysImageToFile(int size, String fileName) throws Exception {
        System.out.println();
        System.out.println("Read system image, size " + size + " (" + this.comPort + ", " + this.speed + ", id:" + this.id);
        System.out.println(fileName);
        System.out.println("Press Ctrl+C to break.");
        System.out.println();
        byte[] data = new byte[size];
        boolean ok = false;
        try (VicsModbusClient mc = new VicsModbusClient();){
            mc.setTransport(new RtuTransportJSerialComm(this.comPort, this.speed, 8, 0, 2, 1000, 20));
            for (int i = 0; i < this.chunksCount(size); ++i) {
                int offset = i * 244;
                int chunkSize = Math.min(244, data.length - offset);
                System.out.println("Read part " + (i + 1) + " at " + offset + ", " + chunkSize + " bytes");
                mc.InitReadSysImgRequest(this.id, offset, chunkSize);
                if (!mc.execRequest()) {
                    throw new Exception(mc.getResultAsString());
                }
                mc.readFromPdu(2, chunkSize, data, offset);
            }
            System.out.println("OK");
            ok = true;
        }
        if (ok) {
            System.out.println("Saving file " + fileName);
            this.saveBinFile(data, fileName);
            System.out.println("DONE!");
        }
    }

    void clearApp() throws Exception {
        System.out.println();
        System.out.println("Clearing application memory (FLASH)");
        System.out.println();
        boolean ok = false;
        try (VicsModbusClient mc = new VicsModbusClient();){
            mc.setTransport(new RtuTransportJSerialComm(this.comPort, this.speed, 8, 0, 2, 2000, 20));
            mc.InitWriteRegisterRequest(this.id, 7000, 18546);
            if (!mc.execRequest()) {
                throw new Exception("ERROR: " + mc.getResultAsString());
            }
            ok = true;
        }
        if (ok) {
            System.out.println("DONE!");
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 8) {
                System.out.println("ViCS Memory Tool");
                System.out.println("Command line parameters: <COM_port> <speed> <id> <model> <firmware> -<command> <address> <size> <input_file>");
                System.out.println("  commands:");
                System.out.println("    -ReadRAM");
                System.out.println("    -ReadFlash");
                System.out.println("    -ReadEEPROM");
                System.out.println("    -ReadNVRAM");
                System.out.println("    -ReadExtEEPROM");
                System.out.println("    -ReadSysImage");
                System.out.println("    -ClearApp");
                System.out.println("    -WriteRAM");
                System.out.println("    -WriteFlash");
                System.out.println("    -WriteEEPROM");
                System.out.println("    -WriteNVRAM");
                System.out.println("    -WriteExtEEPROM");
                return;
            }
            String cmd = args[5];
            int addr = Integer.parseInt(args[6]);
            int size = Integer.parseInt(args[7]);
            File inFile = null;
            if (cmd != null && cmd.contains("Write")) {
                if (args.length < 9) {
                    throw new Exception("Input file not specified");
                }
                inFile = new File(args[8]);
                if (!inFile.exists()) {
                    throw new Exception("File does not exist: " + inFile.getAbsolutePath());
                }
            }
            MemoryTool tool = new MemoryTool(args[0], Integer.parseInt(args[1]), Integer.parseInt(args[2]), Integer.parseInt(args[3]), Integer.parseInt(args[4]));
            if ("-ReadRAM".equalsIgnoreCase(cmd)) {
                tool.readMemoryToFile(0, addr, size, "_ram_" + addr + "_" + size + ".bin");
            } else if ("-ReadFlash".equalsIgnoreCase(cmd)) {
                tool.readMemoryToFile(3, addr, size, "_flash_" + addr + "_" + size + ".bin");
            } else if ("-ReadEEPROM".equalsIgnoreCase(cmd)) {
                tool.readMemoryToFile(1, addr, size, "_eeprom_" + addr + "_" + size + ".bin");
            } else if ("-ReadNVRAM".equalsIgnoreCase(cmd)) {
                tool.readMemoryToFile(2, addr, size, "_nvram_" + addr + "_" + size + ".bin");
            } else if ("-ReadExtEEPROM".equalsIgnoreCase(cmd)) {
                tool.readMemoryToFile(4, addr, size, "_ext_eeprom_" + addr + "_" + size + ".bin");
            } else if ("-ReadSysImage".equalsIgnoreCase(cmd)) {
                tool.readSysImageToFile(size, "vics_sys_image.bin");
            } else if ("-ClearApp".equalsIgnoreCase(cmd)) {
                tool.clearApp();
            } else {
                System.out.println("UNKNOWN COMMAND : " + cmd);
            }
        }
        catch (NoSuchFileException e) {
            System.out.println("");
            System.out.println("ERROR. File not found: " + e.getMessage());
        }
        catch (Throwable e) {
            System.out.println("");
            System.out.println("ERROR (" + e.getClass().getName() + "): " + e.getMessage());
            System.out.println("");
            if (System.getProperty("debug") != null) {
                e.printStackTrace();
            }
            log.error("EXCEPTION", e);
        }
    }

    public static interface ProgressListener {
        public void updateStep(int var1);
    }
}

